/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.table.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTable;
import com.biz.crm.tpm.business.activity.plan.table.local.mapper.ActivityPlanTableMapper;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ActivityPlanTableRepository
extends ServiceImpl<ActivityPlanTableMapper, ActivityPlanTable> {
    @Autowired
    private ActivityPlanTableMapper activityPlanTableMapper;

    public Page<ActivityPlanTableVo> findByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityPlanTableVo> pageList = this.activityPlanTableMapper.findByConditions((Page<ActivityPlanTableVo>)page, dto);
        return pageList;
    }

    public List<ActivityPlanTable> listByCondition(ActivityPlanTableDto dto) {
        if (Objects.isNull(dto)) {
            return new ArrayList<ActivityPlanTable>();
        }
        Validate.isTrue((StringUtils.isEmpty((CharSequence)dto.getOrgCode()) && StringUtils.isEmpty((CharSequence)dto.getYearAndMonth()) ? 1 : 0) != 0, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanTable::getOrgCode, (Object)dto.getOrgCode())).eq(ActivityPlanTable::getYearAndMonth, (Object)dto.getYearAndMonth())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new ArrayList<ActivityPlanTable>();
        }
        return list;
    }

    public List<ActivityPlanTable> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids) || StringUtils.isEmpty((CharSequence)delFlag)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public ActivityPlanTable getByProcessNo(String processNo) {
        if (StringUtils.isEmpty((CharSequence)processNo)) {
            return null;
        }
        return (ActivityPlanTable)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanTable::getProcessNo, (Object)processNo)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public ActivityPlanTable selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto) {
        return (ActivityPlanTable)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityPlanTable::getYearAndMonth, (Object)dto.getYearAndMonth())).eq(ActivityPlanTable::getOrgCode, (Object)dto.getOrgCode())).eq(ActivityPlanTable::getTableVersion, (Object)dto.getTableVersion())).one());
    }
}

