/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.table.local.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.util.ListUtils;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.merge.OnceAbsoluteMergeStrategy;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.CustomerChannelDto;
import com.biz.crm.mdm.business.customer.channel.sdk.service.CustomerChannelVoService;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.CustomerChannelVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.org.sdk.service.OrgVoService;
import com.biz.crm.mdm.business.org.sdk.vo.OrgVo;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDimensionItemDto;
import com.biz.crm.mdm.business.price.sdk.dto.SearchPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.PriceDimensionEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mdm.business.table.sdk.service.ColumnConfigVoService;
import com.biz.crm.mdm.business.table.sdk.vo.ColumnConfigVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.SalesApprovalDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTable;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableActivityPlanProfitEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableCostCollectEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableFinalFixedExpenseEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableFixedExpenseEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTablePriceEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTablePutOutputRatioEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableReferendumCostEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableSaleForecastEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTableSpecialCostEntity;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.ActivityPlanProfitRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.ActivityPlanTableRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.CostCollectRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.FinalFixedExpenseRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.FixedExpenseRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.PriceRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.PutOutputRatioRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.ReferendumCostRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.SaleForecastRepository;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.SpecialCostRepository;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableBatchSubmitApprovalDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.FinalFixedExpenseDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration.SheetNameEnum;
import com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration.TableVersionEnum;
import com.biz.crm.tpm.business.activity.plan.table.sdk.service.ActivityPlanTableService;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanProfitVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ActivityPlanTableVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.CostCollectVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.FinalFixedExpenseVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PriceVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ProcessBusinessFormVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioCustomerVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.PutOutputRatioVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.ReferendumCostVo;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.SaleForecastVo;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.SubComBudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import com.biz.crm.tpm.business.budget.item.sdk.service.BudgetItemMainItemService;
import com.biz.crm.tpm.business.budget.item.sdk.vo.BudgetItemMainItemVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.BudgetAmountTypeEnum;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.eunm.ConfirmEunm;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.service.ProfitGoalDiscountService;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.FixedExpenseVo;
import com.biz.crm.tpm.business.sales.plan.sdk.dto.SalesPlanDto;
import com.biz.crm.tpm.business.sales.plan.sdk.service.SalesPlanService;
import com.biz.crm.tpm.business.sales.plan.sdk.vo.SalesPlanVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignApproveSubmitDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDetailDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.FeeSourceEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsBigDateOrNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.IsPriceRelatedNoEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.enums.RelationTypeEnum;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignBudgetService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignDetailService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignBudgetVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignVo;
import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.service.ProcessBusinessService;
import com.biz.crm.workflow.sdk.vo.ProcessBusinessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.SetUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ActivityPlanTableServiceImpl
implements ActivityPlanTableService {
    private static final Logger log = LoggerFactory.getLogger(ActivityPlanTableServiceImpl.class);
    @Autowired(required=false)
    private ActivityPlanTableRepository activityPlanTableRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private SalesPlanService salesPlanService;
    @Autowired(required=false)
    private OrgVoService orgVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SubComBudgetForecastService subComBudgetForecastService;
    @Autowired(required=false)
    private SubComActivityDesignDetailService subComActivityDesignDetailService;
    @Autowired(required=false)
    private ProfitGoalDiscountService profitGoalDiscountService;
    @Autowired(required=false)
    private ProcessBusinessService processBusinessService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private SubComActivityDesignService subComActivityDesignService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private CustomerChannelVoService customerChannelVoService;
    @Autowired(required=false)
    private ActivityPlanProfitRepository activityPlanProfitRepository;
    @Autowired(required=false)
    private CostCollectRepository costCollectRepository;
    @Autowired(required=false)
    private FinalFixedExpenseRepository finalFixedExpenseRepository;
    @Autowired(required=false)
    private FixedExpenseRepository fixedExpenseRepository;
    @Autowired(required=false)
    private PutOutputRatioRepository putOutputRatioRepository;
    @Autowired(required=false)
    private ReferendumCostRepository referendumCostRepository;
    @Autowired(required=false)
    private SaleForecastRepository saleForecastRepository;
    @Autowired(required=false)
    private SpecialCostRepository specialCostRepository;
    @Autowired(required=false)
    private PriceRepository priceRepository;
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private SubComActivityDesignBudgetService subComActivityDesignBudgetService;
    @Autowired(required=false)
    private BudgetItemMainItemService budgetItemMainItemService;
    @Autowired(required=false)
    private ColumnConfigVoService columnConfigVoService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    private static final String PARENT_CODE = "CRM202211221669085054";
    @Autowired(required=false)
    private CustomerVoService customerVoService;

    public Page<ActivityPlanTableVo> findByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivityPlanTableDto();
        }
        return this.activityPlanTableRepository.findByConditions(pageable, dto);
    }

    public ActivityPlanTableVo getById(String id, SheetNameEnum sheetNameEnum) {
        return this.getById(id, sheetNameEnum, false);
    }

    private ActivityPlanTableVo getById(String id, SheetNameEnum sheetNameEnum, boolean refresh) {
        SubComActivityDesignDetailDto subComActivityDesignDetailDto;
        Validate.notBlank((CharSequence)id, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ActivityPlanTable activityPlanTable = (ActivityPlanTable)((Object)this.activityPlanTableRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)activityPlanTable), (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        ActivityPlanTableVo activityPlanTableVo = (ActivityPlanTableVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanTable, ActivityPlanTableVo.class, null, null, new String[0]);
        if (!(refresh || sheetNameEnum != null && SheetNameEnum.SKIP.getCode() == sheetNameEnum.getCode())) {
            if (TableVersionEnum.PROCESS_COMMIT_VERSION.getCode().equals(activityPlanTableVo.getTableVersion()) && (ProcessStatusEnum.PASS.getDictCode().equals(activityPlanTableVo.getProcessStatus()) || ProcessStatusEnum.COMMIT.getDictCode().equals(activityPlanTableVo.getProcessStatus()))) {
                String tableCode = activityPlanTableVo.getActivityPlanTableCode();
                try {
                    if (Objects.isNull(sheetNameEnum)) {
                        List<ActivityPlanProfitVo> profitVoList = this.activityPlanProfitRepository.findByTableCode(tableCode);
                        if (CollectionUtils.isNotEmpty(profitVoList)) {
                            for (ActivityPlanProfitVo profitVo : profitVoList) {
                                profitVo.setSpecialCostList(this.specialCostRepository.findByProfitId(profitVo.getId()));
                                profitVo.setFixedExpenseList(this.fixedExpenseRepository.findByProfitId(profitVo.getId()));
                            }
                        }
                        activityPlanTableVo.setActivityPlanProfitList(profitVoList);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.PUT_OUTPUT_RATIO.equals((Object)sheetNameEnum)) {
                        log.info("\u5206\u9875\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4\u5ba1\u6279\u7248\u672c");
                        List<PutOutputRatioVo> putOutputRatioVoList = this.putOutputRatioRepository.findByTableCodeGroupByOrgCode(tableCode);
                        activityPlanTableVo.setPutOutputRatioList(putOutputRatioVoList);
                        if (CollectionUtils.isNotEmpty(putOutputRatioVoList)) {
                            Date feeYearMonth = putOutputRatioVoList.get(0).getFeeYearMonth();
                            List<PutOutputRatioCustomerVo> putOutputRatioVoCustomerList = this.putOutputRatioRepository.findByTableCodeGroupByCustomerCode(feeYearMonth);
                            activityPlanTableVo.setPutOutputRatioCustomerList(putOutputRatioVoCustomerList);
                        }
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.SALE_FORECAST.equals((Object)sheetNameEnum)) {
                        List<SaleForecastVo> saleForecastVoList = this.saleForecastRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setSaleForecastList(saleForecastVoList);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.PRICE.equals((Object)sheetNameEnum)) {
                        List<PriceVo> priceVoList = this.priceRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setPriceList(priceVoList);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.COST_COLLECT.equals((Object)sheetNameEnum)) {
                        List<CostCollectVo> costCollectVoList = this.costCollectRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setCostCollectList(costCollectVoList);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.REFERENDUM_COST.equals((Object)sheetNameEnum)) {
                        List orgVoList = this.orgVoService.findAllChildrenByOrgCode(activityPlanTableVo.getOrgCode());
                        Set orgCodes = orgVoList.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
                        orgCodes = Optional.ofNullable(orgCodes).orElse(SetUtils.emptySet());
                        orgCodes.add(activityPlanTableVo.getOrgCode());
                        activityPlanTableVo.setReferendumCostList(this.getReferendumCostList(activityPlanTableVo, orgCodes));
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                try {
                    if (Objects.isNull(sheetNameEnum) || SheetNameEnum.FINAL_FIXED_EXPENSE.equals((Object)sheetNameEnum)) {
                        List<FinalFixedExpenseVo> finalFixedExpenseVoList = this.finalFixedExpenseRepository.findByTableCode(tableCode);
                        activityPlanTableVo.setFixedExpenseList(finalFixedExpenseVoList);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                this.convertActivityTableData(activityPlanTableVo, null);
                if (CollectionUtils.isNotEmpty((Collection)activityPlanTableVo.getCostCollectList())) {
                    this.fillDesignName(activityPlanTableVo.getCostCollectList());
                }
                return activityPlanTableVo;
            }
        } else if (null != sheetNameEnum && SheetNameEnum.SKIP.getCode() == sheetNameEnum.getCode()) {
            sheetNameEnum = null;
        }
        List orgVoList = this.orgVoService.findAllChildrenByOrgCode(activityPlanTableVo.getOrgCode());
        Set orgCodes = orgVoList.stream().map(OrgVo::getOrgCode).collect(Collectors.toSet());
        orgCodes = Optional.ofNullable(orgCodes).orElse(SetUtils.emptySet());
        orgCodes.add(activityPlanTableVo.getOrgCode());
        SalesPlanDto salesPlanDto = new SalesPlanDto();
        salesPlanDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        OrgVo orgVo = this.orgVoService.findByOrgCode(activityPlanTableVo.getOrgCode());
        Validate.notNull((Object)orgVo, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u7f16\u7801\u3010%s\u3011\u7ec4\u7ec7\u6570\u636e", (Object[])new Object[]{activityPlanTableVo.getOrgCode()});
        Validate.notNull((Object)orgVo.getSalesOrgCode(), (String)"\u7ec4\u7ec7\u3010%s\u3011\u672a\u7ef4\u62a4\u5bf9\u5e94\u9500\u552e\u7ec4\u7ec7", (Object[])new Object[]{activityPlanTableVo.getOrgCode()});
        SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        Validate.notNull((Object)salesOrgVo, (String)"\u672a\u627e\u5230\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u3010%s\u3011\u7ec4\u7ec7\u6570\u636e", (Object[])new Object[]{orgVo.getSalesOrgCode()});
        salesPlanDto.setSalesInstitutionErpCode(salesOrgVo.getErpCode());
        salesPlanDto.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
        List salesPlanVoList = this.salesPlanService.findByConditions(salesPlanDto);
        List subComActivityDesignDetailVoList = null;
        if (refresh) {
            subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
            subComActivityDesignDetailDto.setProcessNo(activityPlanTableVo.getProcessNo());
            subComActivityDesignDetailVoList = this.subComActivityDesignDetailService.findBudgetDetailByConditions(subComActivityDesignDetailDto);
        } else {
            subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
            try {
                Validate.notBlank((CharSequence)activityPlanTableVo.getYearAndMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Date yearAndMonth = df.parse(activityPlanTableVo.getYearAndMonth());
                subComActivityDesignDetailDto.setFeeYearMonth(yearAndMonth);
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
            subComActivityDesignDetailVoList = this.subComActivityDesignDetailService.findBudgetDetailByConditions(subComActivityDesignDetailDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)subComActivityDesignDetailVoList)) {
            subComActivityDesignDetailVoList.stream().forEach(d -> d.setTotalCost(Optional.ofNullable(d.getTotalCost()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(d.getWillRefundAmount()).orElse(BigDecimal.ZERO))));
        }
        try {
            if (Objects.isNull(sheetNameEnum)) {
                List<ActivityPlanProfitVo> activityPlanProfit = this.getActivityPlanProfit(activityPlanTableVo, orgCodes, salesPlanVoList, subComActivityDesignDetailVoList);
                activityPlanTableVo.setActivityPlanProfitList(activityPlanProfit);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.PUT_OUTPUT_RATIO.equals((Object)sheetNameEnum)) {
                log.info("\u5206\u9875\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4\u5b9e\u65f6\u7248\u672c");
                List<PutOutputRatioVo> putOutputRatioList = this.getPutOutputRatioListGroupByOrgCode(salesPlanVoList, subComActivityDesignDetailVoList);
                activityPlanTableVo.setPutOutputRatioList(putOutputRatioList);
                List<PutOutputRatioCustomerVo> putOutputRatioCustomerList = this.getPutOutputRatioListGroupByCustomerCode(salesPlanVoList, subComActivityDesignDetailVoList);
                activityPlanTableVo.setPutOutputRatioCustomerList(putOutputRatioCustomerList);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.SALE_FORECAST.equals((Object)sheetNameEnum)) {
                activityPlanTableVo.setSaleForecastList(this.getSaleForecastList(activityPlanTableVo, orgCodes, salesPlanVoList, subComActivityDesignDetailVoList));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.PRICE.equals((Object)sheetNameEnum)) {
                activityPlanTableVo.setPriceList(this.getPriceList(activityPlanTableVo, orgCodes, salesPlanVoList));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.COST_COLLECT.equals((Object)sheetNameEnum)) {
                activityPlanTableVo.setCostCollectList(this.getCostCollectList(subComActivityDesignDetailVoList));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.REFERENDUM_COST.equals((Object)sheetNameEnum)) {
                activityPlanTableVo.setReferendumCostList(this.getReferendumCostList(activityPlanTableVo, orgCodes));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            if (Objects.isNull(sheetNameEnum) || SheetNameEnum.FINAL_FIXED_EXPENSE.equals((Object)sheetNameEnum)) {
                activityPlanTableVo.setFixedExpenseList(this.getFixedExpenseList(activityPlanTableVo, orgCodes));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.convertActivityTableData(activityPlanTableVo, subComActivityDesignDetailVoList);
        return activityPlanTableVo;
    }

    private void fillDesignName(List<CostCollectVo> costCollectVoList) {
        if (CollectionUtils.isEmpty(costCollectVoList)) {
            return;
        }
        List designCodes = costCollectVoList.stream().map(CostCollectVo::getActivityDesignCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List designVoList = this.subComActivityDesignService.findByDesignCodes(designCodes);
        if (CollectionUtils.isNotEmpty((Collection)designVoList)) {
            Map designVoMap = designVoList.stream().collect(Collectors.toMap(SubComActivityDesignVo::getActivityDesignCode, Function.identity(), (v1, v2) -> v2));
            costCollectVoList.forEach(cost -> {
                SubComActivityDesignVo designVo = (SubComActivityDesignVo)designVoMap.get(cost.getActivityDesignCode());
                if (!Objects.isNull(designVo)) {
                    cost.setActivityDesignName(designVo.getActivityDesignName());
                }
            });
        }
    }

    private void convertActivityTableData(ActivityPlanTableVo activityPlanTableVo, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        if (null == activityPlanTableVo) {
            return;
        }
        Date curDate = new Date();
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (!CollectionUtils.isEmpty((Collection)activityPlanTableVo.getPutOutputRatioList())) {
            for (PutOutputRatioVo putOutputRatioVo : activityPlanTableVo.getPutOutputRatioList()) {
                if (null != putOutputRatioVo.getBeforeDiscountIncome() && BigDecimal.ZERO.compareTo(putOutputRatioVo.getBeforeDiscountIncome()) != 0) {
                    putOutputRatioVo.setBeforeInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getBeforeDiscountIncome(), 4, 1));
                }
                if (null == putOutputRatioVo.getAfterDiscountIncome() || BigDecimal.ZERO.compareTo(putOutputRatioVo.getAfterDiscountIncome()) == 0) continue;
                putOutputRatioVo.setAfterInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(), 4, 1));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityPlanTableVo.getPriceList())) {
            for (PriceVo priceVo : activityPlanTableVo.getPriceList()) {
                if (null != priceVo.getStandardSupplyPrice() && priceVo.getStandardSupplyPrice().compareTo(BigDecimal.ZERO) != 0) {
                    priceVo.setTheoryGrossProfit(priceVo.getStandardSupplyPrice().subtract(Optional.ofNullable(priceVo.getCifPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getStandardSupplyPrice(), 4, RoundingMode.HALF_UP));
                }
                if (null != priceVo.getRestoredPrice() && priceVo.getRestoredPrice().compareTo(BigDecimal.ZERO) != 0) {
                    priceVo.setGrossProfit(priceVo.getRestoredPrice().subtract(Optional.ofNullable(priceVo.getActivityLowestPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getRestoredPrice(), 4, RoundingMode.HALF_UP));
                }
                if (null == priceVo.getActivityRetailPrice() || priceVo.getActivityRetailPrice().compareTo(BigDecimal.ZERO) == 0) continue;
                priceVo.setFrontGrossProfit(priceVo.getActivityRetailPrice().subtract(Optional.ofNullable(priceVo.getRestoredPrice()).orElse(BigDecimal.ZERO)).divide(priceVo.getActivityRetailPrice(), 4, RoundingMode.HALF_UP));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)activityPlanTableVo.getCostCollectList())) {
            Set activityDesignDetailCodeSet = activityPlanTableVo.getCostCollectList().stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toSet());
            if (null == subComActivityDesignDetailVoList) {
                subComActivityDesignDetailVoList = this.subComActivityDesignDetailService.findDesignDetailByCodeList(activityDesignDetailCodeSet);
            }
            Map subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity()));
            List budgetVoList = this.subComActivityDesignBudgetService.listByActivityDetailCodes((List)Lists.newArrayList(activityDesignDetailCodeSet));
            Map<String, List<SubComActivityDesignBudgetVo>> budgetVoMap = null;
            if (!org.springframework.util.CollectionUtils.isEmpty((Collection)budgetVoList)) {
                budgetVoMap = budgetVoList.stream().collect(Collectors.groupingBy(SubComActivityDesignBudgetVo::getActivityDesignDetailCode));
            }
            Map budgetItemMainItemMap = null;
            HashSet mainBudgetItemCodeSet = new HashSet();
            List upDetailCodes = subComActivityDesignDetailVoList.stream().filter(d -> RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(d.getAssociationType())).map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).distinct().collect(Collectors.toList());
            if (!org.springframework.util.CollectionUtils.isEmpty(upDetailCodes) && !org.springframework.util.CollectionUtils.isEmpty(budgetVoMap)) {
                for (String key : budgetVoMap.keySet()) {
                    List<SubComActivityDesignBudgetVo> subComActivityDesignBudgetVos = budgetVoMap.get(key);
                    if (org.springframework.util.CollectionUtils.isEmpty(subComActivityDesignBudgetVos)) continue;
                    List mainBudgetItemCodes = subComActivityDesignBudgetVos.stream().filter(s -> !FeeSourceEnum.AUTO_FEE.getCode().equals(s.getFeeSourceCode())).map(SubComActivityDesignBudgetVo::getBudgetItemCode).distinct().collect(Collectors.toList());
                    mainBudgetItemCodeSet.addAll(mainBudgetItemCodes);
                }
                List budgetItemMainItemVos = this.budgetItemMainItemService.listByMainBudgetItemCodeList((List)Lists.newArrayList(mainBudgetItemCodeSet));
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)budgetItemMainItemVos)) {
                    budgetItemMainItemMap = budgetItemMainItemVos.stream().collect(Collectors.toMap(BudgetItemMainItemVo::getMainBudgetItemCode, Function.identity(), (v1, v2) -> v2));
                }
            }
            for (CostCollectVo costCollectVo : activityPlanTableVo.getCostCollectList()) {
                List<SubComActivityDesignBudgetVo> budgetVos;
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = (SubComActivityDesignDetailVo)subComActivityDesignDetailVoMap.get(costCollectVo.getActivityDesignDetailCode());
                BeanUtils.copyProperties((Object)subComActivityDesignDetailVo, (Object)costCollectVo);
                if (null != costCollectVo.getPromotionAmount() && BigDecimal.ZERO.compareTo(costCollectVo.getPromotionAmount()) != 0) {
                    costCollectVo.setCostSaleRate(Optional.ofNullable(costCollectVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(costCollectVo.getPromotionAmount(), 4, 1));
                }
                if (!org.springframework.util.CollectionUtils.isEmpty(budgetVoMap) && !org.springframework.util.CollectionUtils.isEmpty(budgetVos = budgetVoMap.get(costCollectVo.getActivityDesignDetailCode()))) {
                    for (SubComActivityDesignBudgetVo budget : budgetVos) {
                        if (RelationTypeEnum.UP_RELATION_DETAIL_PLAN.getCode().equals(costCollectVo.getAssociationType()) && !org.springframework.util.CollectionUtils.isEmpty(budgetItemMainItemMap)) {
                            BudgetItemMainItemVo budgetItemMainItemVo;
                            if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) && !Objects.isNull(budgetItemMainItemVo = (BudgetItemMainItemVo)budgetItemMainItemMap.get(budget.getBudgetItemCode()))) {
                                costCollectVo.setInPointBudgetItemCode(budgetItemMainItemVo.getBudgetItemCode());
                                costCollectVo.setInternalPointFee(budget.getBudgetAmount());
                            }
                            if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode()) && !Objects.isNull(budgetItemMainItemVo = (BudgetItemMainItemVo)budgetItemMainItemMap.get(budget.getBudgetItemCode()))) {
                                costCollectVo.setOffPointBudgetItemCode(budgetItemMainItemVo.getBudgetItemCode());
                                costCollectVo.setOffPointFee(budget.getBudgetAmount());
                            }
                        } else {
                            if (FeeSourceEnum.INTERNAL_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                costCollectVo.setInPointBudgetItemCode(budget.getBudgetItemCode());
                                costCollectVo.setInternalPointFee(budget.getBudgetAmount());
                            }
                            if (FeeSourceEnum.OFF_POINT_FEE.getCode().equals(budget.getFeeSourceCode())) {
                                costCollectVo.setOffPointBudgetItemCode(budget.getBudgetItemCode());
                                costCollectVo.setOffPointFee(budget.getBudgetAmount());
                            }
                        }
                        if (!FeeSourceEnum.AUTO_FEE.getCode().equals(budget.getFeeSourceCode())) continue;
                        costCollectVo.setAutoBudgetItemCode(budget.getBudgetItemCode());
                        costCollectVo.setAutoFee(budget.getBudgetAmount());
                    }
                }
                costCollectVo.setHeadquartersSupportedAmount(Optional.ofNullable(costCollectVo.getOffPointFee()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(costCollectVo.getInternalPointFee()).orElse(BigDecimal.ZERO)));
                costCollectVo.setSubComAutoAmount(costCollectVo.getAutoAmount());
                if (null == costCollectVo.getProductExpirationDate() || StringUtils.isEmpty((CharSequence)costCollectVo.getBigDateNo())) continue;
                try {
                    Date bigDate = dayFormat.parse(costCollectVo.getBigDateNo());
                    long distanceDay = DateUtil.getDistanceDay((long)(curDate.getTime() / 1000L), (long)(bigDate.getTime() / 1000L));
                    if (curDate.after(bigDate)) {
                        costCollectVo.setBigDateRemainDay(Integer.valueOf(-((int)distanceDay)));
                    } else {
                        costCollectVo.setBigDateRemainDay(Integer.valueOf((int)distanceDay));
                    }
                    costCollectVo.setBigDateRemainDay(Integer.valueOf(costCollectVo.getBigDateRemainDay() + costCollectVo.getProductExpirationDate()));
                }
                catch (Exception e) {
                    log.error("\u5927\u65e5\u671f\u5269\u4f59\u5929\u6570\u5904\u7406\u5931\u8d25", (Throwable)e);
                }
            }
        }
    }

    private List<PutOutputRatioVo> withOutCustomer(List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoListl) {
        if (CollectionUtils.isEmpty(subComActivityDesignDetailVoListl)) {
            return Lists.newArrayList();
        }
        List subComActivityDesignDetailVoList = subComActivityDesignDetailVoListl.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getCustomerCode())).collect(Collectors.toList());
        ArrayList<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<PutOutputRatioVo>();
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)) {
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("") + "" + Optional.ofNullable(item.getActivityTypeCode()).orElse("")));
            subComActivityDesignDetailVoMap.forEach((key, value) -> {
                Map value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = (SubComActivityDesignDetailVo)value.get(0);
                PutOutputRatioVo putOutputRatioVo = (PutOutputRatioVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null, new String[0]);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<PutOutputRatioVo>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public void save(ActivityPlanTableDto dto) {
        Validate.notNull((Object)dto, (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getYearAndMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        try {
            if (this.redisLockService.tryLock("tpm:activity:plan:table:lock", TimeUnit.SECONDS, 10L)) {
                dto.setActivityPlanTableCode((String)this.generateCodeService.generateCode("GHTB", 1, Integer.valueOf(10), 30L, TimeUnit.DAYS).get(0));
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityPlanTableRepository.lambdaQuery().eq(ActivityPlanTable::getOrgCode, (Object)dto.getOrgCode())).eq(ActivityPlanTable::getYearAndMonth, (Object)dto.getYearAndMonth())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
                if (CollectionUtils.isEmpty((Collection)list)) {
                    ActivityPlanTable activityPlanTable = (ActivityPlanTable)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, ActivityPlanTable.class, null, null, new String[0]));
                    activityPlanTable.setProcessStatus(ProcessStatusEnum.PREPARE.getDictCode());
                    activityPlanTable.setTableVersion(TableVersionEnum.ACTUAL_TIME_VERSION.getCode());
                    this.activityPlanTableRepository.save((Object)activityPlanTable);
                    activityPlanTable.setId(null);
                    activityPlanTable.setTableVersion(TableVersionEnum.PROCESS_COMMIT_VERSION.getCode());
                    activityPlanTable.setActivityPlanTableCode((String)this.generateCodeService.generateCode("GHTB", 1, Integer.valueOf(10), 30L, TimeUnit.DAYS).get(0));
                    this.activityPlanTableRepository.save((Object)activityPlanTable);
                }
            }
        }
        finally {
            if (this.redisLockService.isLock("tpm:activity:plan:table:lock")) {
                this.redisLockService.unlock("tpm:activity:plan:table:lock");
            }
        }
    }

    public List<ActivityPlanTableVo> listByCondition(ActivityPlanTableDto dto) {
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByCondition(dto);
        if (CollectionUtils.isEmpty(activityPlanTables)) {
            return new ArrayList<ActivityPlanTableVo>();
        }
        Collection activityPlanTableVos = this.nebulaToolkitService.copyCollectionByBlankList(activityPlanTables, ActivityPlanTable.class, ActivityPlanTableVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)activityPlanTableVos;
    }

    @Transactional
    public List<String> batchSubmitApproval(ActivityPlanTableBatchSubmitApprovalDto dto) {
        Validate.isTrue((boolean)Objects.nonNull(dto), (String)"\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List ids = dto.getIds();
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)ids), (String)"\u8f93\u5165id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u53ea\u80fd\u5355\u6761\u5ba1\u6279", (Object[])new Object[0]);
        List activityPlanTables = this.activityPlanTableRepository.listByIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)activityPlanTables), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        Collection activityPlanTableDtos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)activityPlanTables, ActivityPlanTable.class, ActivityPlanTableDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList processNoList = Lists.newArrayList();
        activityPlanTableDtos.forEach(item -> {
            String processNo = this.submitApproval((ActivityPlanTableDto)item, dto.getProcessBusiness());
            processNoList.add(processNo);
        });
        return processNoList;
    }

    public void generateData(String id) {
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByIds(Arrays.asList(id), DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(activityPlanTables)) {
            return;
        }
        ActivityPlanTable activityPlanTable = activityPlanTables.get(0);
        Validate.isTrue((boolean)ProcessStatusEnum.PASS.getDictCode().equals(activityPlanTable.getProcessStatus()), (String)"\u53ea\u6709\u5ba1\u6279\u901a\u8fc7\u7684\u5957\u8868\u80fd\u751f\u6210\u6570\u636e\uff01", (Object[])new Object[0]);
        Validate.isTrue((!BooleanEnum.TRUE.getCapital().equals(activityPlanTable.getGenerateStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u6570\u636e\u5df2\u7ecf\u751f\u6210\u4e86\u5bf9\u5e94\u5206\u5b50\u516c\u53f8\u9884\u7b97\u3001\u7ec6\u6848\uff0c\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb\uff01", (Object[])new Object[0]);
        this.subComActivityDesignService.passBatch(activityPlanTable.getProcessNo(), id);
    }

    public ActivityPlanTableVo download(String id, HttpServletResponse response) throws IOException {
        ActivityPlanTableVo resultVo = this.getById(id, null);
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode("\u6d3b\u52a8\u89c4\u5212\u5957\u8868" + resultVo.getOrgName() + resultVo.getYearAndMonth(), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
        ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream()).autoCloseStream(Boolean.FALSE).build();
        for (int i = 0; i < 7; ++i) {
            ExcelWriterSheetBuilder excelWriterSheetBuilder = EasyExcel.writerSheet((Integer)i, (String)SheetNameEnum.getName((int)i));
            if (i == 0) {
                List<OnceAbsoluteMergeStrategy> mergeStrategyList = this.getMergeStrategy(resultVo.getActivityPlanProfitList());
                excelWriterSheetBuilder = (ExcelWriterSheetBuilder)excelWriterSheetBuilder.head(this.getProfitHead(resultVo.getActivityPlanProfitList()));
                for (OnceAbsoluteMergeStrategy onceAbsoluteMergeStrategy : mergeStrategyList) {
                    excelWriterSheetBuilder = (ExcelWriterSheetBuilder)excelWriterSheetBuilder.registerWriteHandler((WriteHandler)onceAbsoluteMergeStrategy);
                }
                WriteSheet writeSheet = excelWriterSheetBuilder.build();
                excelWriter.write(this.getProfitData(resultVo.getActivityPlanProfitList()), writeSheet);
                continue;
            }
            List column = this.columnConfigVoService.findByParentCodeAndFunctionCodeOrderByFormorder(PARENT_CODE, SheetNameEnum.getFunctionCode((int)i));
            List<ColumnConfigVo> visibleColumnList = column.stream().filter(ColumnConfigVo::getVisible).sorted(Comparator.comparing(item -> Integer.valueOf(Optional.ofNullable(item.getFormorder()).orElse("99")))).collect(Collectors.toList());
            List headList = visibleColumnList.stream().map(item -> Lists.newArrayList((Object[])new String[]{item.getTitle()})).collect(Collectors.toList());
            excelWriterSheetBuilder = (ExcelWriterSheetBuilder)excelWriterSheetBuilder.head(headList);
            WriteSheet writeSheet = excelWriterSheetBuilder.build();
            excelWriter.write(this.getData(i, resultVo, visibleColumnList), writeSheet);
        }
        excelWriter.finish();
        return resultVo;
    }

    public Page<PutOutputRatioVo> findPutOutputRatioByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.PUT_OUTPUT_RATIO);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List putOutputRatioList = byId.getPutOutputRatioList();
        if (CollectionUtils.isNotEmpty((Collection)putOutputRatioList)) {
            List limit = putOutputRatioList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)putOutputRatioList.size());
        }
        return page;
    }

    public Page<PutOutputRatioCustomerVo> findPutOutputRatioCustomerByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4\uff08\u5ba2\u6237\uff09\uff0c\u53c2\u6570{}", (Object)com.alibaba.fastjson.JSONObject.toJSONString((Object)dto));
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.PUT_OUTPUT_RATIO);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List putOutputRatioList = byId.getPutOutputRatioCustomerList();
        if (CollectionUtils.isNotEmpty((Collection)putOutputRatioList)) {
            List limit = putOutputRatioList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)putOutputRatioList.size());
        }
        return page;
    }

    public Page<SaleForecastVo> findSaleForecastByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.SALE_FORECAST);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List saleForecastList = byId.getSaleForecastList();
        if (CollectionUtils.isNotEmpty((Collection)saleForecastList)) {
            List limit = saleForecastList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)saleForecastList.size());
        }
        return page;
    }

    public Page<CostCollectVo> findCostCollectByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.COST_COLLECT);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List costCollectList = byId.getCostCollectList();
        if (CollectionUtils.isNotEmpty((Collection)costCollectList)) {
            List limit = costCollectList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)costCollectList.size());
        }
        return page;
    }

    public Page<ReferendumCostVo> findReferendumCostByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.REFERENDUM_COST);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List referendumCostList = byId.getReferendumCostList();
        if (CollectionUtils.isNotEmpty((Collection)referendumCostList)) {
            List limit = referendumCostList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)referendumCostList.size());
        }
        return page;
    }

    public Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.FINAL_FIXED_EXPENSE);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List fixedExpenseVos = byId.getFixedExpenseList();
        if (CollectionUtils.isNotEmpty((Collection)fixedExpenseVos)) {
            List limit = fixedExpenseVos.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            page.setRecords(limit);
            page.setTotal((long)fixedExpenseVos.size());
        }
        return page;
    }

    public Page<PriceVo> findPriceByConditions(Pageable pageable, ActivityPlanTableDto dto) {
        ActivityPlanTableVo byId = this.getById(dto.getId(), SheetNameEnum.PRICE);
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        List priceList = byId.getPriceList();
        if (CollectionUtils.isNotEmpty((Collection)priceList)) {
            List<PriceVo> limit = priceList.stream().skip((page.getCurrent() - 1L) * page.getSize()).limit(page.getSize()).collect(Collectors.toList());
            this.loadActivityLowerPrice(byId, limit);
            page.setRecords(limit);
            page.setTotal((long)priceList.size());
        }
        return page;
    }

    private void loadActivityLowerPrice(ActivityPlanTableVo byId, List<PriceVo> limit) {
        for (PriceVo priceVo : limit) {
            SubComActivityDesignDetailVo designDetailVo = new SubComActivityDesignDetailVo();
            designDetailVo.setCustomerCode(priceVo.getCustomerCode());
            designDetailVo.setOrgCode(priceVo.getOrgCode());
            designDetailVo.setProductCode(priceVo.getApportionProductCode());
            designDetailVo.setActivityBeginTimeStart(byId.getYearAndMonth() + "-01");
            designDetailVo.setActivityBeginTimeEnd(DateUtil.format((Date)DateUtil.dateAddMonth((Date)DateUtil.parse((String)(byId.getYearAndMonth() + "-01"), (String)"yyyy-MM-dd"), (Integer)1), (String)"yyyy-MM-dd"));
            priceVo.setActivityLowestPrice(this.subComActivityDesignDetailService.findActivityLowestPrice(designDetailVo));
            if (priceVo.getActivityLowestPrice() != null) continue;
            priceVo.setActivityLowestPrice(BigDecimal.ZERO);
        }
    }

    public void updateGenerateStatus(String tableId) {
        Validate.notEmpty((CharSequence)tableId, (String)"\u8981\u66f4\u65b0\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<ActivityPlanTable> activityPlanTables = this.activityPlanTableRepository.listByIds(Arrays.asList(tableId), DelFlagStatusEnum.NORMAL.getCode());
        activityPlanTables.forEach(activityPlanTable -> activityPlanTable.setGenerateStatus(BooleanEnum.TRUE.getCapital()));
        this.activityPlanTableRepository.updateBatchById(activityPlanTables);
    }

    private List<OnceAbsoluteMergeStrategy> getMergeStrategy(List<ActivityPlanProfitVo> activityPlanProfitList) {
        ArrayList<OnceAbsoluteMergeStrategy> onceAbsoluteMergeStrategyList = new ArrayList<OnceAbsoluteMergeStrategy>();
        OnceAbsoluteMergeStrategy mergeStrategy2 = new OnceAbsoluteMergeStrategy(1, 1, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy2);
        OnceAbsoluteMergeStrategy mergeStrategy3 = new OnceAbsoluteMergeStrategy(2, 2, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy3);
        OnceAbsoluteMergeStrategy mergeStrategy4 = new OnceAbsoluteMergeStrategy(3, 3, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy4);
        OnceAbsoluteMergeStrategy mergeStrategy5 = new OnceAbsoluteMergeStrategy(4, 4, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy5);
        OnceAbsoluteMergeStrategy mergeStrategy6 = new OnceAbsoluteMergeStrategy(5, 5, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy6);
        OnceAbsoluteMergeStrategy mergeStrategy7 = new OnceAbsoluteMergeStrategy(6, 6, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy7);
        OnceAbsoluteMergeStrategy mergeStrategy8 = new OnceAbsoluteMergeStrategy(7, 7, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy8);
        OnceAbsoluteMergeStrategy mergeStrategy9 = new OnceAbsoluteMergeStrategy(8, 8, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy9);
        int specialCostCount = this.getSpecialCostTotalRow(activityPlanProfitList);
        int fixedExpenseCount = this.getFixedExpenseTotalRow(activityPlanProfitList);
        if (specialCostCount > 0 && fixedExpenseCount > 0) {
            OnceAbsoluteMergeStrategy mergeStrategy10 = new OnceAbsoluteMergeStrategy(9, 9 + specialCostCount + fixedExpenseCount + 1, 0, 0);
            onceAbsoluteMergeStrategyList.add(mergeStrategy10);
        }
        if (specialCostCount > 0) {
            OnceAbsoluteMergeStrategy mergeStrategy101 = new OnceAbsoluteMergeStrategy(9, 9 + specialCostCount, 1, 1);
            onceAbsoluteMergeStrategyList.add(mergeStrategy101);
        }
        if (fixedExpenseCount > 1) {
            OnceAbsoluteMergeStrategy mergeStrategy103 = new OnceAbsoluteMergeStrategy(9 + specialCostCount + 1, 9 + specialCostCount + 1 + fixedExpenseCount, 1, 1);
            onceAbsoluteMergeStrategyList.add(mergeStrategy103);
        }
        OnceAbsoluteMergeStrategy mergeStrategy11 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount, 11 + specialCostCount + fixedExpenseCount + 5, 0, 0);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11);
        OnceAbsoluteMergeStrategy mergeStrategy11_0 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount, 11 + specialCostCount + fixedExpenseCount, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_0);
        OnceAbsoluteMergeStrategy mergeStrategy11_1 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount + 1, 11 + specialCostCount + fixedExpenseCount + 1, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_1);
        OnceAbsoluteMergeStrategy mergeStrategy11_2 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount + 2, 11 + specialCostCount + fixedExpenseCount + 2, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_2);
        OnceAbsoluteMergeStrategy mergeStrategy11_3 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount + 3, 11 + specialCostCount + fixedExpenseCount + 3, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_3);
        OnceAbsoluteMergeStrategy mergeStrategy11_4 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount + 4, 11 + specialCostCount + fixedExpenseCount + 4, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_4);
        OnceAbsoluteMergeStrategy mergeStrategy11_5 = new OnceAbsoluteMergeStrategy(11 + specialCostCount + fixedExpenseCount + 5, 11 + specialCostCount + fixedExpenseCount + 5, 1, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy11_5);
        OnceAbsoluteMergeStrategy mergeStrategy12 = new OnceAbsoluteMergeStrategy(17 + specialCostCount + fixedExpenseCount, 17 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy12);
        OnceAbsoluteMergeStrategy mergeStrategy13 = new OnceAbsoluteMergeStrategy(18 + specialCostCount + fixedExpenseCount, 18 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy13);
        OnceAbsoluteMergeStrategy mergeStrategy14 = new OnceAbsoluteMergeStrategy(19 + specialCostCount + fixedExpenseCount, 19 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy14);
        OnceAbsoluteMergeStrategy mergeStrategy15 = new OnceAbsoluteMergeStrategy(20 + specialCostCount + fixedExpenseCount, 20 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy15);
        OnceAbsoluteMergeStrategy mergeStrategy16 = new OnceAbsoluteMergeStrategy(21 + specialCostCount + fixedExpenseCount, 21 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy16);
        OnceAbsoluteMergeStrategy mergeStrategy17 = new OnceAbsoluteMergeStrategy(22 + specialCostCount + fixedExpenseCount, 22 + specialCostCount + fixedExpenseCount, 0, 2);
        onceAbsoluteMergeStrategyList.add(mergeStrategy17);
        return onceAbsoluteMergeStrategyList;
    }

    private int getFixedExpenseTotalRow(List<ActivityPlanProfitVo> activityPlanProfitList) {
        if (CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            HashSet<String> rows = new HashSet<String>();
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                List fixedExpenseList;
                if (activityPlanProfitVo.getIsTotal().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(fixedExpenseList = activityPlanProfitVo.getFixedExpenseList()))) continue;
                for (FixedExpenseVo fixedExpenseVo : fixedExpenseList) {
                    if (fixedExpenseVo.getIsTotal().booleanValue()) continue;
                    rows.add(fixedExpenseVo.getBudgetSortCode());
                }
            }
            return rows.size();
        }
        return 0;
    }

    private int getSpecialCostTotalRow(List<ActivityPlanProfitVo> activityPlanProfitList) {
        if (CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            HashSet<String> rows = new HashSet<String>();
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                List specialCostList;
                if (activityPlanProfitVo.getIsTotal().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(specialCostList = activityPlanProfitVo.getSpecialCostList()))) continue;
                for (SpecialCostVo specialCostVo : specialCostList) {
                    if (specialCostVo.getIsTotal().booleanValue()) continue;
                    rows.add(specialCostVo.getActivityTypeCode());
                }
            }
            return rows.size();
        }
        return 0;
    }

    private List<List<String>> getProfitHead(List<ActivityPlanProfitVo> activityPlanProfitList) {
        ArrayList list = ListUtils.newArrayList();
        ArrayList head0 = ListUtils.newArrayList();
        head0.add("\u9879\u76ee\u540d\u79f0");
        list.add(head0);
        ArrayList head1 = ListUtils.newArrayList();
        head1.add("\u9879\u76ee\u540d\u79f0");
        list.add(head1);
        ArrayList head2 = ListUtils.newArrayList();
        head2.add("\u9879\u76ee\u540d\u79f0");
        list.add(head2);
        List collect = activityPlanProfitList.stream().sorted(Comparator.comparing(ActivityPlanProfitVo::getIsTotal)).collect(Collectors.toList());
        for (ActivityPlanProfitVo activityPlanProfitVo : collect) {
            ArrayList head = ListUtils.newArrayList();
            head.add(activityPlanProfitVo.getIsTotal() != false ? "\u5408\u8ba1" : activityPlanProfitVo.getCustomerChannelName());
            list.add(head);
        }
        return list;
    }

    private Collection<?> getData(int i, ActivityPlanTableVo resultVo, List<ColumnConfigVo> columnConfigVos) {
        List priceList;
        if (i == 1) {
            List putOutputRatioList = resultVo.getPutOutputRatioList();
            if (CollectionUtils.isNotEmpty((Collection)putOutputRatioList)) {
                return this.findExportData(putOutputRatioList, columnConfigVos);
            }
        } else if (i == 2) {
            List saleForecastList = resultVo.getSaleForecastList();
            if (CollectionUtils.isNotEmpty((Collection)saleForecastList)) {
                return this.findExportData(saleForecastList, columnConfigVos);
            }
        } else if (i == 3) {
            List costCollectList = resultVo.getCostCollectList();
            if (CollectionUtils.isNotEmpty((Collection)costCollectList)) {
                return this.findExportData(costCollectList, columnConfigVos);
            }
        } else if (i == 4) {
            List referendumCostList = resultVo.getReferendumCostList();
            if (CollectionUtils.isNotEmpty((Collection)referendumCostList)) {
                return this.findExportData(referendumCostList, columnConfigVos);
            }
        } else if (i == 5) {
            List fixedExpenseList = resultVo.getFixedExpenseList();
            if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList)) {
                return this.findExportData(fixedExpenseList, columnConfigVos);
            }
        } else if (i == 6 && CollectionUtils.isNotEmpty((Collection)(priceList = resultVo.getPriceList()))) {
            this.loadActivityLowerPrice(resultVo, priceList);
            return this.findExportData(priceList, columnConfigVos);
        }
        return null;
    }

    private Collection<?> findExportData(Collection<?> data, List<ColumnConfigVo> columnConfigVos) {
        LinkedList list = Lists.newLinkedList();
        List dictCodeList = columnConfigVos.stream().map(ColumnConfigVo::getDictCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<Object, Object> dictMapMap = Maps.newHashMap();
        if (!CollectionUtils.isEmpty(dictCodeList)) {
            Map dictMap = this.dictDataVoService.findByDictTypeCodeList(dictCodeList);
            dictMapMap = dictMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((List)item.getValue()).stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue, (o, n) -> n)), (o, n) -> n));
        }
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        for (Object o2 : data) {
            JSONObject obj = JSONUtil.parseObj(o2);
            LinkedList cur = Lists.newLinkedList();
            for (ColumnConfigVo columnConfigVo : columnConfigVos) {
                String fieldName = columnConfigVo.getField();
                Object objectValue = obj.getOrDefault((Object)fieldName, null);
                if (null != objectValue) {
                    if (StringUtils.isNotEmpty((CharSequence)columnConfigVo.getDictCode())) {
                        Map columnDictMap = (Map)dictMapMap.get(columnConfigVo.getDictCode());
                        if (null != columnDictMap) {
                            String objectStrValue = objectValue.toString();
                            objectValue = columnDictMap.getOrDefault(objectStrValue, objectStrValue);
                        }
                    } else if (objectValue instanceof Date) {
                        objectValue = columnConfigVo.getField().equals("feeYearMonth") ? yearMonthFormat.format((Date)objectValue) : dayFormat.format((Date)objectValue);
                    }
                }
                cur.add(objectValue);
            }
            list.add(cur);
        }
        return list;
    }

    private Collection<?> getProfitData(List<ActivityPlanProfitVo> activityPlanProfitList) {
        ArrayList<ArrayList> dataList = new ArrayList<ArrayList>();
        activityPlanProfitList = activityPlanProfitList.stream().sorted(Comparator.comparing(ActivityPlanProfitVo::getIsTotal)).collect(Collectors.toList());
        Map<String, String> specialCostMap = this.getSpecialCostMap(activityPlanProfitList);
        Map<String, String> fixedExpenseMap = this.getFixedExpenseMap(activityPlanProfitList);
        ArrayList data1 = ListUtils.newArrayList();
        data1.add("\u51fa\u5e93\u4ef6\u6570");
        data1.add("\u51fa\u5e93\u4ef6\u6570");
        data1.add("\u51fa\u5e93\u4ef6\u6570");
        ArrayList data2 = ListUtils.newArrayList();
        data2.add("\u6298\u524d\u6536\u5165");
        data2.add("\u6298\u524d\u6536\u5165");
        data2.add("\u6298\u524d\u6536\u5165");
        ArrayList data3 = ListUtils.newArrayList();
        data3.add("\u6298\u524d\u6210\u672c");
        data3.add("\u6298\u524d\u6210\u672c");
        data3.add("\u6298\u524d\u6210\u672c");
        ArrayList data4 = ListUtils.newArrayList();
        data4.add("\u6298\u540e\u6536\u5165");
        data4.add("\u6298\u540e\u6536\u5165");
        data4.add("\u6298\u540e\u6536\u5165");
        ArrayList data5 = ListUtils.newArrayList();
        data5.add("\u9500\u91cf\u5360\u6bd4");
        data5.add("\u9500\u91cf\u5360\u6bd4");
        data5.add("\u9500\u91cf\u5360\u6bd4");
        ArrayList data6 = ListUtils.newArrayList();
        data6.add("\u7406\u8bba\u6bdb\u5229\u989d");
        data6.add("\u7406\u8bba\u6bdb\u5229\u989d");
        data6.add("\u7406\u8bba\u6bdb\u5229\u989d");
        ArrayList data7 = ListUtils.newArrayList();
        data7.add("\u7406\u8bba\u6bdb\u5229\u7387");
        data7.add("\u7406\u8bba\u6bdb\u5229\u7387");
        data7.add("\u7406\u8bba\u6bdb\u5229\u7387");
        ArrayList data8 = ListUtils.newArrayList();
        data8.add("\u7a0e\u91d1\u53ca\u9644\u52a0");
        data8.add("\u7a0e\u91d1\u53ca\u9644\u52a0");
        data8.add("\u7a0e\u91d1\u53ca\u9644\u52a0");
        HashMap<String, Object> specialCostDataMap = new HashMap<String, Object>();
        for (Map.Entry<String, String> one : specialCostMap.entrySet()) {
            ArrayList specialCostDataList = ListUtils.newArrayList();
            specialCostDataList.add("\u6574\u4f53\u5411\u4e0b\u652f\u51fa");
            specialCostDataList.add("\u4e13\u9879\u8d39\u7528");
            specialCostDataList.add(one.getValue());
            specialCostDataMap.put(one.getKey(), specialCostDataList);
        }
        ArrayList data81 = ListUtils.newArrayList();
        if (specialCostMap.size() > 0) {
            data81.add("\u6574\u4f53\u5411\u4e0b\u652f\u51fa");
            data81.add("\u4e13\u9879\u8d39\u7528");
            data81.add("\u5c0f\u8ba1");
        }
        HashMap fixedExpenseDataMap = new HashMap();
        for (Map.Entry entry : fixedExpenseMap.entrySet()) {
            ArrayList fixedExpenseDataList = ListUtils.newArrayList();
            fixedExpenseDataList.add("\u6574\u4f53\u5411\u4e0b\u652f\u51fa");
            fixedExpenseDataList.add("\u56fa\u5b9a\u652f\u51fa");
            fixedExpenseDataList.add(entry.getValue());
            fixedExpenseDataMap.put(entry.getKey(), fixedExpenseDataList);
        }
        ArrayList data82 = ListUtils.newArrayList();
        if (fixedExpenseMap.size() > 0) {
            data82.add("\u6574\u4f53\u5411\u4e0b\u652f\u51fa");
            data82.add("\u56fa\u5b9a\u652f\u51fa");
            data82.add("\u5c0f\u8ba1");
        }
        ArrayList arrayList = ListUtils.newArrayList();
        arrayList.add("\u603b\u90e8\u652f\u6301");
        arrayList.add("\u70b9\u5185\u8d39\u7528");
        arrayList.add("\u70b9\u5185\u8d39\u7528");
        ArrayList data10 = ListUtils.newArrayList();
        data10.add("\u603b\u90e8\u652f\u6301");
        data10.add("\u70b9\u5916\u8d39\u7528");
        data10.add("\u70b9\u5916\u8d39\u7528");
        ArrayList data91 = ListUtils.newArrayList();
        data91.add("\u603b\u90e8\u652f\u6301");
        data91.add("\u70b9\u6570\u5185\u8d39\u7387");
        data91.add("\u70b9\u6570\u5185\u8d39\u7387");
        ArrayList data101 = ListUtils.newArrayList();
        data101.add("\u603b\u90e8\u652f\u6301");
        data101.add("\u70b9\u6570\u5916\u8d39\u7387");
        data101.add("\u70b9\u6570\u5916\u8d39\u7387");
        ArrayList data11 = ListUtils.newArrayList();
        data11.add("\u603b\u90e8\u652f\u6301");
        data11.add("\u603b\u90e8\u8003\u6838");
        data11.add("\u603b\u90e8\u8003\u6838");
        ArrayList data12 = ListUtils.newArrayList();
        data12.add("\u603b\u90e8\u652f\u6301");
        data12.add("\u5c0f\u8ba1");
        data12.add("\u5c0f\u8ba1");
        ArrayList data13 = ListUtils.newArrayList();
        data13.add("\u5229\u6da6\u989d");
        data13.add("\u5229\u6da6\u989d");
        data13.add("\u5229\u6da6\u989d");
        ArrayList data14 = ListUtils.newArrayList();
        data14.add("\u4ea7\u54c1\u4fc3\u9500\u8d39\u7528\u7387");
        data14.add("\u4ea7\u54c1\u4fc3\u9500\u8d39\u7528\u7387");
        data14.add("\u4ea7\u54c1\u4fc3\u9500\u8d39\u7528\u7387");
        ArrayList data15 = ListUtils.newArrayList();
        data15.add("\u5176\u4ed6\u8d39\u7528\u7387");
        data15.add("\u5176\u4ed6\u8d39\u7528\u7387");
        data15.add("\u5176\u4ed6\u8d39\u7528\u7387");
        ArrayList data16 = ListUtils.newArrayList();
        data16.add("\u4e13\u9879\u8d39\u7528\u7387");
        data16.add("\u4e13\u9879\u8d39\u7528\u7387");
        data16.add("\u4e13\u9879\u8d39\u7528\u7387");
        ArrayList data17 = ListUtils.newArrayList();
        data17.add("\u56fa\u5b9a\u652f\u51fa\u8d39\u7528\u7387");
        data17.add("\u56fa\u5b9a\u652f\u51fa\u8d39\u7528\u7387");
        data17.add("\u56fa\u5b9a\u652f\u51fa\u8d39\u7528\u7387");
        ArrayList data18 = ListUtils.newArrayList();
        data18.add("\u6574\u4f53\u8d39\u7528\u7387");
        data18.add("\u6574\u4f53\u8d39\u7528\u7387");
        data18.add("\u6574\u4f53\u8d39\u7528\u7387");
        for (int i = 0; i < activityPlanProfitList.size(); ++i) {
            ActivityPlanProfitVo activityPlanProfitVo = (ActivityPlanProfitVo)activityPlanProfitList.get(i);
            data1.add(activityPlanProfitVo.getOutStorageQuantity());
            data2.add(activityPlanProfitVo.getBeforeDiscountIncome());
            data3.add(activityPlanProfitVo.getBeforeDiscountCost());
            data4.add(activityPlanProfitVo.getAfterDiscountIncome());
            data5.add(activityPlanProfitVo.getSaleQuantityRatio());
            data6.add(activityPlanProfitVo.getTheoryGrossMarginAmount());
            data7.add(activityPlanProfitVo.getTheoryGrossMarginRate());
            data8.add(activityPlanProfitVo.getTaxAndAddition());
            List specialCostList = activityPlanProfitVo.getSpecialCostList();
            Map<Object, Object> specialCostVoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)specialCostList)) {
                specialCostVoMap = specialCostList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getActivityTypeCode())).collect(Collectors.toMap(SpecialCostVo::getActivityTypeCode, Function.identity()));
            }
            for (Map.Entry<String, String> specialCostEntry : specialCostMap.entrySet()) {
                List specialCostList2 = (List)specialCostDataMap.get(specialCostEntry.getKey());
                SpecialCostVo specialCostVo = (SpecialCostVo)specialCostVoMap.get(specialCostEntry.getKey());
                if (specialCostVo != null) {
                    specialCostList2.add(specialCostVo.getSpecialCost());
                    continue;
                }
                specialCostList2.add(null);
            }
            List specialCostTotal = Optional.ofNullable(specialCostList).orElse(Lists.newArrayList()).stream().filter(o -> Objects.nonNull(o.getIsTotal()) && o.getIsTotal() != false).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(specialCostTotal)) {
                data81.add(((SpecialCostVo)specialCostTotal.get(0)).getSpecialCost());
            } else {
                data81.add(null);
            }
            List fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
            Map<Object, Object> fixedExpenseVoMap = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList)) {
                fixedExpenseVoMap = fixedExpenseList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getBudgetSortCode())).collect(Collectors.toMap(FixedExpenseVo::getBudgetSortCode, Function.identity()));
            }
            for (Map.Entry entry : fixedExpenseMap.entrySet()) {
                List fixedExpenseDataList2 = (List)fixedExpenseDataMap.get(entry.getKey());
                FixedExpenseVo fixedExpenseVo = (FixedExpenseVo)fixedExpenseVoMap.get(entry.getKey());
                if (fixedExpenseVo != null) {
                    fixedExpenseDataList2.add(fixedExpenseVo.getFixedExpense());
                    continue;
                }
                fixedExpenseDataList2.add(null);
            }
            List fixedExpenseTotal = Optional.ofNullable(fixedExpenseList).orElse(Lists.newArrayList()).stream().filter(o -> Objects.nonNull(o.getIsTotal()) && o.getIsTotal() != false).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(fixedExpenseTotal)) {
                data82.add(((FixedExpenseVo)fixedExpenseTotal.get(0)).getFixedExpense());
            } else {
                data82.add(null);
            }
            arrayList.add(activityPlanProfitVo.getPointInCost());
            data10.add(activityPlanProfitVo.getPointOutCost());
            if (activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                if (activityPlanProfitVo.getPointInCost() != null) {
                    data91.add(activityPlanProfitVo.getPointInCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, 4));
                }
                if (activityPlanProfitVo.getPointOutCost() != null) {
                    data101.add(activityPlanProfitVo.getPointOutCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, 4));
                }
            }
            data11.add(activityPlanProfitVo.getHeadquartersAssess());
            data12.add(activityPlanProfitVo.getHeadquartersExpenseTotal());
            data13.add(activityPlanProfitVo.getProfitAmount());
            data14.add(activityPlanProfitVo.getProductPromotionCost());
            data15.add(activityPlanProfitVo.getOtherCostRatio());
            data16.add(activityPlanProfitVo.getSpecialCostRate());
            data17.add(activityPlanProfitVo.getPointInExpendCostRate());
            data18.add(activityPlanProfitVo.getAllCostRate());
        }
        dataList.add(data1);
        dataList.add(data2);
        dataList.add(data3);
        dataList.add(data4);
        dataList.add(data5);
        dataList.add(data6);
        dataList.add(data7);
        dataList.add(data8);
        dataList.addAll(specialCostDataMap.values());
        dataList.add(data81);
        dataList.addAll(fixedExpenseDataMap.values());
        dataList.add(data82);
        dataList.add(arrayList);
        dataList.add(data10);
        dataList.add(data91);
        dataList.add(data101);
        dataList.add(data11);
        dataList.add(data12);
        dataList.add(data13);
        dataList.add(data14);
        dataList.add(data15);
        dataList.add(data16);
        dataList.add(data17);
        dataList.add(data18);
        return dataList;
    }

    private Map<String, String> getFixedExpenseMap(List<ActivityPlanProfitVo> activityPlanProfitList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                List fixedExpenseList;
                if (activityPlanProfitVo.getIsTotal().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(fixedExpenseList = activityPlanProfitVo.getFixedExpenseList()))) continue;
                for (FixedExpenseVo fixedExpenseVo : fixedExpenseList) {
                    String budgetSortName;
                    if (fixedExpenseVo.getIsTotal().booleanValue() || !StringUtils.isEmpty((CharSequence)(budgetSortName = (String)resultMap.get(fixedExpenseVo.getBudgetSortCode())))) continue;
                    resultMap.put(fixedExpenseVo.getBudgetSortCode(), fixedExpenseVo.getBudgetSortName());
                }
            }
        }
        return resultMap;
    }

    private Map<String, String> getSpecialCostMap(List<ActivityPlanProfitVo> activityPlanProfitList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
                List specialCostList;
                if (activityPlanProfitVo.getIsTotal().booleanValue() || !CollectionUtils.isNotEmpty((Collection)(specialCostList = activityPlanProfitVo.getSpecialCostList()))) continue;
                for (SpecialCostVo specialCostVo : specialCostList) {
                    String typeName;
                    if (specialCostVo.getIsTotal().booleanValue() || !StringUtils.isEmpty((CharSequence)(typeName = (String)resultMap.get(specialCostVo.getActivityTypeCode())))) continue;
                    resultMap.put(specialCostVo.getActivityTypeCode(), specialCostVo.getActivityTypeName());
                }
            }
        }
        return resultMap;
    }

    private String submitApproval(ActivityPlanTableDto dto, ProcessBusinessDto processBusiness) {
        Validate.notNull((Object)dto, (String)"\u63d0\u4ea4\u5ba1\u6279\u6d41\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.submitApprovalValidate(dto);
        processBusiness.setBusinessNo(dto.getId());
        processBusiness.setProcessTitle("\u6d3b\u52a8\u89c4\u5212\u5957\u8868[" + dto.getOrgCode() + "-" + dto.getYearAndMonth() + "]\u53d1\u8d77\u5ba1\u6279\u6d41");
        ProcessBusinessFormVo processBusinessForm = new ProcessBusinessFormVo();
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthLy(dto.getYearAndMonth());
        subComBudgetForecastDto.setOrgCode(dto.getOrgCode());
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.AUTO_FEE.getCode());
        List subComBudgetForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)subComBudgetForecastVos)) {
            SubComBudgetForecastVo subComBudgetForecastVo = (SubComBudgetForecastVo)subComBudgetForecastVos.get(0);
            processBusinessForm.setRemainderAmount(subComBudgetForecastVo.getRemainderAmount());
        }
        processBusiness.setBusinessCode("ordinary_activity_plan_table_process");
        ActivityPlanTableVo tablePriceVo = this.getById(dto.getId(), SheetNameEnum.PRICE);
        List priceVoList = tablePriceVo.getPriceList();
        if (CollectionUtils.isNotEmpty((Collection)priceVoList)) {
            List customerCodeList = priceVoList.stream().map(PriceVo::getCustomerCode).distinct().collect(Collectors.toList());
            List productCodeList = priceVoList.stream().map(PriceVo::getApportionProductCode).distinct().collect(Collectors.toList());
            List channelCodeList = priceVoList.stream().map(PriceVo::getDistributionChannelCode).distinct().collect(Collectors.toList());
            SubComActivityDesignDetailVo conditionVo = new SubComActivityDesignDetailVo();
            conditionVo.setCustomerCodeList(customerCodeList);
            conditionVo.setProductCodeList(productCodeList);
            conditionVo.setChannelCodeList(channelCodeList);
            conditionVo.setOrgCode(dto.getOrgCode());
            conditionVo.setActivityBeginTimeStart(dto.getYearAndMonth() + "-01");
            conditionVo.setActivityBeginTimeEnd(DateUtil.format((Date)DateUtil.dateAddMonth((Date)DateUtil.parse((String)(dto.getYearAndMonth() + "-01"), (String)"yyyy-MM-dd"), (Integer)1), (String)"yyyy-MM-dd"));
            List lowestPriceList = this.subComActivityDesignDetailService.findActivityLowestPriceByConditions(conditionVo);
            boolean isSpecial = false;
            if (CollectionUtils.isNotEmpty((Collection)lowestPriceList)) {
                Map lowestPriceMap = lowestPriceList.stream().collect(Collectors.toMap(o -> o.getCustomerCode() + o.getProductCode() + o.getDistributionChannelCode(), Function.identity()));
                for (PriceVo priceVo : priceVoList) {
                    SubComActivityDesignDetailVo lowestPrice = (SubComActivityDesignDetailVo)lowestPriceMap.get(priceVo.getCustomerCode() + priceVo.getApportionProductCode() + priceVo.getDistributionChannelCode());
                    if (lowestPrice.getActivityPrice().compareTo(priceVo.getSupplyMaterialRedLinePrice()) >= 0 && priceVo.getStandardSupplyPrice().subtract(priceVo.getAvgPriceEffect()).compareTo(priceVo.getSupplyMaterialRedLinePrice()) >= 0) continue;
                    isSpecial = true;
                    break;
                }
            }
            if (isSpecial) {
                processBusinessForm.setIsBreakPrice(BooleanEnum.TRUE.getCapital());
                processBusinessForm.setIsSpecialGrantProcess(BooleanEnum.TRUE.getCapital());
                processBusinessForm.setIsSpecialProcess(BooleanEnum.TRUE.getCapital());
            } else {
                processBusinessForm.setIsBreakPrice(BooleanEnum.FALSE.getCapital());
                processBusinessForm.setIsSpecialGrantProcess(BooleanEnum.FALSE.getCapital());
                processBusinessForm.setIsSpecialProcess(BooleanEnum.FALSE.getCapital());
            }
        }
        SubComActivityDesignDto subComActivityDesignDto = new SubComActivityDesignDto();
        subComActivityDesignDto.setOrgCode(dto.getOrgCode());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        Date yearAndMonth = null;
        try {
            yearAndMonth = df.parse(dto.getYearAndMonth());
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        subComActivityDesignDto.setFeeYearMonth(yearAndMonth);
        List designDtos = this.subComActivityDesignService.listByYearMonthAndOrg(subComActivityDesignDto);
        List activityDesignCodeList = designDtos.stream().map(SubComActivityDesignDto::getActivityDesignCode).collect(Collectors.toList());
        SubComActivityDesignApproveSubmitDto businessFormDto = this.subComActivityDesignDetailService.getProcessBusinessForm(activityDesignCodeList);
        processBusinessForm.setIsUnderRedLinePrice(Optional.ofNullable(businessFormDto.getIsUnderRedLinePrice()).orElse(BooleanEnum.FALSE.getCapital()));
        processBusiness.setBusinessFormJson(com.alibaba.fastjson.JSONObject.toJSONString((Object)processBusinessForm));
        ProcessBusinessVo processBusinessVo = this.processBusinessService.processStart(processBusiness);
        ActivityPlanTable activityPlanTable = new ActivityPlanTable();
        activityPlanTable.setProcessStatus(ProcessStatusEnum.COMMIT.getDictCode());
        activityPlanTable.setProcessNo(processBusinessVo.getProcessNo());
        activityPlanTable.setId(dto.getId());
        this.activityPlanTableRepository.updateById((Object)activityPlanTable);
        this.subComActivityDesignService.submitBatch(designDtos, processBusinessVo.getProcessNo());
        return processBusinessVo.getProcessNo();
    }

    public void saveSubmitBatchByMq(List<String> processNoList) {
        MqMessageVo mqMessageVo = new MqMessageVo();
        mqMessageVo.setMsgBody(com.alibaba.fastjson.JSONObject.toJSONString(processNoList));
        mqMessageVo.setTopic("TPM_SUB_COM_ACTIVITY_DESIGN_MODIFY_PROCESS_PASS_TOPIC" + RocketMqUtil.mqEnvironment());
        mqMessageVo.setTag("TPM_SUB_COM_ACTIVITY_DESIGN_SAVE_DATA_TAG");
        this.rocketMqProducer.sendMqMsg(mqMessageVo, 10L);
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveSubmitTimeData(String processNo) {
        if (StringUtil.isEmpty((CharSequence)processNo)) {
            return;
        }
        ActivityPlanTable table = this.activityPlanTableRepository.getByProcessNo(processNo);
        ActivityPlanTableVo tableVo = this.getById(table.getId(), null, true);
        log.error("\u5f02\u6b65\u4fdd\u5b58\u5206\u5b50\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u6570\u636e\u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)tableVo));
        if (Objects.isNull(tableVo)) {
            return;
        }
        ArrayList activityPlanTableActivityPlanProfitEntityList = new ArrayList();
        ArrayList activityPlanTableFixedExpenseEntityList = new ArrayList();
        ArrayList activityPlanTableSpecialCostEntityList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)tableVo.getActivityPlanProfitList())) {
            for (int i = 0; i < tableVo.getActivityPlanProfitList().size(); ++i) {
                ((ActivityPlanProfitVo)tableVo.getActivityPlanProfitList().get(i)).setId(UUID.randomUUID().toString().replaceAll("-", ""));
            }
            activityPlanTableActivityPlanProfitEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getActivityPlanProfitList(), ActivityPlanProfitVo.class, ActivityPlanTableActivityPlanProfitEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanProfitVo profitVo : tableVo.getActivityPlanProfitList()) {
                if (!CollectionUtils.isEmpty((Collection)profitVo.getFixedExpenseList())) {
                    ArrayList profitFixedList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)profitVo.getFixedExpenseList(), FixedExpenseVo.class, ActivityPlanTableFixedExpenseEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                    for (ActivityPlanTableFixedExpenseEntity activityPlanTableFixedExpenseEntity : profitFixedList) {
                        activityPlanTableFixedExpenseEntity.setProfitId(profitVo.getId());
                        activityPlanTableFixedExpenseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        activityPlanTableFixedExpenseEntity.setTenantCode(TenantUtils.getTenantCode());
                    }
                    activityPlanTableFixedExpenseEntityList.addAll(profitFixedList);
                }
                if (CollectionUtils.isEmpty((Collection)profitVo.getSpecialCostList())) continue;
                ArrayList profitSpecialList = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)profitVo.getSpecialCostList(), SpecialCostVo.class, ActivityPlanTableSpecialCostEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                for (ActivityPlanTableSpecialCostEntity activityPlanTableSpecialCostEntity : profitSpecialList) {
                    activityPlanTableSpecialCostEntity.setProfitId(profitVo.getId());
                    activityPlanTableSpecialCostEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    activityPlanTableSpecialCostEntity.setTenantCode(TenantUtils.getTenantCode());
                }
                activityPlanTableSpecialCostEntityList.addAll(profitSpecialList);
            }
        }
        ArrayList activityPlanTableCostCollectEntityList = new ArrayList();
        ArrayList activityPlanTableFinalFixedExpenseEntityList = new ArrayList();
        ArrayList activityPlanTablePutOutputRatioEntityList = new ArrayList();
        ArrayList referendumCostEntityList = new ArrayList();
        ArrayList activityPlanTableSaleForecastEntityList = new ArrayList();
        ArrayList activityPlanTablePriceEntityList = new ArrayList();
        String tableCode = tableVo.getActivityPlanTableCode();
        if (!CollectionUtils.isEmpty(activityPlanTableActivityPlanProfitEntityList)) {
            for (ActivityPlanTableActivityPlanProfitEntity profitEntity : activityPlanTableActivityPlanProfitEntityList) {
                profitEntity.setActivityPlanTableCode(tableCode);
                profitEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                profitEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getCostCollectList())) {
            activityPlanTableCostCollectEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getCostCollectList(), CostCollectVo.class, ActivityPlanTableCostCollectEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTableCostCollectEntity activityPlanTableCostCollectEntity : activityPlanTableCostCollectEntityList) {
                activityPlanTableCostCollectEntity.setId(null);
                activityPlanTableCostCollectEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableCostCollectEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableCostCollectEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getFixedExpenseList())) {
            activityPlanTableFinalFixedExpenseEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getFixedExpenseList(), FinalFixedExpenseVo.class, ActivityPlanTableFinalFixedExpenseEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTableFinalFixedExpenseEntity activityPlanTableFinalFixedExpenseEntity : activityPlanTableFinalFixedExpenseEntityList) {
                activityPlanTableFinalFixedExpenseEntity.setId(null);
                activityPlanTableFinalFixedExpenseEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableFinalFixedExpenseEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableFinalFixedExpenseEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getPutOutputRatioList())) {
            activityPlanTablePutOutputRatioEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getPutOutputRatioList(), PutOutputRatioVo.class, ActivityPlanTablePutOutputRatioEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTablePutOutputRatioEntity activityPlanTablePutOutputRatioEntity : activityPlanTablePutOutputRatioEntityList) {
                activityPlanTablePutOutputRatioEntity.setId(null);
                activityPlanTablePutOutputRatioEntity.setActivityPlanTableCode(tableCode);
                activityPlanTablePutOutputRatioEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTablePutOutputRatioEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getReferendumCostList())) {
            referendumCostEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getReferendumCostList(), ReferendumCostVo.class, ActivityPlanTableReferendumCostEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTableReferendumCostEntity referendumCostEntity : referendumCostEntityList) {
                referendumCostEntity.setId(null);
                referendumCostEntity.setActivityPlanTableCode(tableCode);
                referendumCostEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                referendumCostEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getSaleForecastList())) {
            activityPlanTableSaleForecastEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getSaleForecastList(), SaleForecastVo.class, ActivityPlanTableSaleForecastEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTableSaleForecastEntity activityPlanTableSaleForecastEntity : activityPlanTableSaleForecastEntityList) {
                activityPlanTableSaleForecastEntity.setId(null);
                activityPlanTableSaleForecastEntity.setActivityPlanTableCode(tableCode);
                activityPlanTableSaleForecastEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTableSaleForecastEntity.setTenantCode(TenantUtils.getTenantCode());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)tableVo.getPriceList())) {
            activityPlanTablePriceEntityList.addAll(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)tableVo.getPriceList(), PriceVo.class, ActivityPlanTablePriceEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            for (ActivityPlanTablePriceEntity activityPlanTablePriceEntity : activityPlanTablePriceEntityList) {
                activityPlanTablePriceEntity.setId(null);
                activityPlanTablePriceEntity.setActivityPlanTableCode(tableCode);
                activityPlanTablePriceEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                activityPlanTablePriceEntity.setTenantCode(TenantUtils.getTenantCode());
                SubComActivityDesignDetailVo designDetailVo = new SubComActivityDesignDetailVo();
                designDetailVo.setCustomerCode(activityPlanTablePriceEntity.getCustomerCode());
                designDetailVo.setOrgCode(activityPlanTablePriceEntity.getOrgCode());
                designDetailVo.setProductCode(activityPlanTablePriceEntity.getApportionProductCode());
                activityPlanTablePriceEntity.setActivityLowestPrice(this.subComActivityDesignDetailService.findActivityLowestPrice(designDetailVo));
            }
        }
        this.specialCostRepository.deleteByTableCode(tableCode);
        this.fixedExpenseRepository.deleteByTableCode(tableCode);
        this.activityPlanProfitRepository.deleteByTableCode(tableCode);
        this.costCollectRepository.deleteByTableCode(tableCode);
        this.finalFixedExpenseRepository.deleteByTableCode(tableCode);
        this.putOutputRatioRepository.deleteByTableCode(tableCode);
        this.referendumCostRepository.deleteByTableCode(tableCode);
        this.saleForecastRepository.deleteByTableCode(tableCode);
        this.priceRepository.deleteByTableCode(tableCode);
        this.activityPlanProfitRepository.saveBatch(activityPlanTableActivityPlanProfitEntityList);
        this.costCollectRepository.saveBatch(activityPlanTableCostCollectEntityList);
        this.finalFixedExpenseRepository.saveBatch(activityPlanTableFinalFixedExpenseEntityList);
        this.fixedExpenseRepository.saveBatch(activityPlanTableFixedExpenseEntityList);
        this.putOutputRatioRepository.saveBatch(activityPlanTablePutOutputRatioEntityList);
        this.referendumCostRepository.saveBatch(referendumCostEntityList);
        this.saleForecastRepository.saveBatch(activityPlanTableSaleForecastEntityList);
        this.specialCostRepository.saveBatch(activityPlanTableSpecialCostEntityList);
        this.priceRepository.saveBatch(activityPlanTablePriceEntityList);
    }

    private void submitApprovalValidate(ActivityPlanTableDto dto) {
        ActivityPlanTable table = (ActivityPlanTable)((Object)this.activityPlanTableRepository.getById((Serializable)((Object)dto.getId())));
        if (StringUtils.isNotEmpty((CharSequence)table.getTableVersion()) && !TableVersionEnum.PROCESS_COMMIT_VERSION.getCode().equals(table.getTableVersion())) {
            throw new UnsupportedOperationException("\u5b9e\u65f6\u7248\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u4e0d\u80fd\u63d0\u4ea4");
        }
    }

    private List<PriceVo> getPriceList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList) {
        if (Objects.isNull(activityPlanTableVo)) {
            return null;
        }
        Map<Object, Object> salesPlanVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(o -> o.getErpCode() + "-" + o.getProductCode()));
        }
        SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM");
        try {
            Validate.notBlank((CharSequence)activityPlanTableVo.getYearAndMonth(), (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Date yearAndMonth = df.parse(activityPlanTableVo.getYearAndMonth());
            subComActivityDesignDetailDto.setFeeYearMonth(yearAndMonth);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
        subComActivityDesignDetailDto.setIsPriceRelation(IsPriceRelatedNoEnum.isPriceRelated.getCode());
        List subComActivityDesignDetailVoList = this.subComActivityDesignDetailService.findApportionDetailByConditions(subComActivityDesignDetailDto);
        if (CollectionUtils.isEmpty((Collection)subComActivityDesignDetailVoList)) {
            return null;
        }
        if (CollectionUtils.isEmpty(subComActivityDesignDetailVoList = subComActivityDesignDetailVoList.stream().filter(o -> StringUtils.isNotEmpty((CharSequence)o.getProductCode()) && !"Z".equals(o.getIsSupplyAmount())).collect(Collectors.toList()))) {
            return null;
        }
        Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(o -> o.getCustomerCode() + o.getProductCode() + o.getActivityDesignDetailCode()));
        Set customerErpCodeSet = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
        HashMap<String, List<CustomerVo>> customerMap = new HashMap<String, List<CustomerVo>>();
        if (CollectionUtils.isNotEmpty(customerErpCodeSet)) {
            List customerVoList = this.customerVoService.findByErpCodeList(new ArrayList(customerErpCodeSet));
            if (CollectionUtils.isNotEmpty((Collection)customerVoList)) {
                customerMap.putAll(customerVoList.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode)));
            } else {
                log.error("\u6d3b\u52a8\u89c4\u5212\u5957\u8868-\u4ef7\u683c\uff0c\u5ba2\u6237\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38\uff0c\u5ba2\u6237\u7f16\u7801\u5217\u8868\uff1a" + JSONArray.toJSONString(customerErpCodeSet));
                return null;
            }
        }
        ArrayList<PriceVo> priceVoList = new ArrayList<PriceVo>();
        Map<Object, Object> finalSalesPlanVoMap = salesPlanVoMap;
        subComActivityDesignDetailVoMap.forEach((uniqueKey, value2) -> {
            PriceVo priceVo = (PriceVo)this.nebulaToolkitService.copyObjectByWhiteList(value2.get(0), PriceVo.class, null, null, new String[0]);
            priceVo.setRestoredPrice(((SubComActivityDesignDetailVo)value2.get(0)).getOriginalProductActivityPrice());
            List customerVoList = (List)customerMap.get(priceVo.getCustomerCode());
            priceVo.setOrgName(activityPlanTableVo.getOrgName());
            priceVo.setDistributionChannelName(((SubComActivityDesignDetailVo)value2.get(0)).getDistributionChannelName());
            priceVo.setActivityDesignCode(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignCode).collect(Collectors.joining(",")));
            priceVo.setActivityDesignName(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignName).collect(Collectors.joining(",")));
            priceVo.setActivityDesignDetailCode(value2.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.joining(",")));
            priceVo.setApportionProductCode(((SubComActivityDesignDetailVo)value2.get(0)).getProductCode());
            priceVo.setApportionProductName(((SubComActivityDesignDetailVo)value2.get(0)).getProductName());
            List salesPlanVos = (List)finalSalesPlanVoMap.get(((SubComActivityDesignDetailVo)value2.get(0)).getCustomerCode() + ((SubComActivityDesignDetailVo)value2.get(0)).getProductCode());
            if (CollectionUtils.isNotEmpty((Collection)salesPlanVos)) {
                priceVo.setCifPrice(salesPlanVos.stream().map(SalesPlanVo::getCifPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
            }
            BigDecimal promoteSales = BigDecimal.ZERO;
            for (SubComActivityDesignDetailVo subComActivityDesignDetailVo : value2) {
                if (subComActivityDesignDetailVo.getPromoteSales() == null) continue;
                promoteSales = promoteSales.add(subComActivityDesignDetailVo.getPromoteSales());
            }
            priceVo.setPromoteSales(promoteSales);
            BigDecimal totalFeeAmount = value2.stream().map(SubComActivityDesignDetailVo::getTotalCost).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalPromotionQuantity = value2.stream().map(SubComActivityDesignDetailVo::getPromoteSales).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal avgPriceEffect = BigDecimal.ZERO;
            if (totalPromotionQuantity != null && BigDecimal.ZERO.compareTo(totalPromotionQuantity) != 0 && totalFeeAmount != null) {
                avgPriceEffect = totalFeeAmount.divide(totalPromotionQuantity, 2, 4);
            }
            priceVo.setAvgPriceEffect(avgPriceEffect);
            priceVo.setStandardSupplyPrice(BigDecimal.ZERO);
            priceVo.setActivityAfterUnitPrice(BigDecimal.ZERO);
            Optional<SubComActivityDesignDetailVo> activityAfterUnitPriceOptional = value2.stream().filter(o -> Objects.nonNull(o.getActivityPrice())).findAny();
            activityAfterUnitPriceOptional.ifPresent(o -> priceVo.setActivityAfterUnitPrice(o.getActivityPrice()));
            if (StringUtils.isNotEmpty((CharSequence)priceVo.getDistributionChannelCode())) {
                PriceModelVo priceModelVo;
                SearchPriceDto searchPriceDto = new SearchPriceDto();
                searchPriceDto.setPriceTypeCode("price1");
                ArrayList<SearchPriceDimensionItemDto> itemDtos = new ArrayList<SearchPriceDimensionItemDto>();
                SearchPriceDimensionItemDto dimensionItemDto1 = new SearchPriceDimensionItemDto();
                dimensionItemDto1.setDimensionCode(PriceDimensionEnum.MATERIAL.getDictCode());
                dimensionItemDto1.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{priceVo.getApportionProductCode()}));
                itemDtos.add(dimensionItemDto1);
                SearchPriceDimensionItemDto dimensionItemDto2 = new SearchPriceDimensionItemDto();
                dimensionItemDto2.setDimensionCode(PriceDimensionEnum.SALES_INSTITUTION_CODE.getDictCode());
                dimensionItemDto2.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{priceVo.getSalesInstitutionCode().substring(4, 8)}));
                itemDtos.add(dimensionItemDto2);
                SearchPriceDimensionItemDto dimensionItemDto3 = new SearchPriceDimensionItemDto();
                dimensionItemDto3.setDimensionCode(PriceDimensionEnum.DISTRIBUTION_CHANNEL.getDictCode());
                dimensionItemDto3.setRelateCodeSet((Set)Sets.newHashSet((Object[])new String[]{priceVo.getDistributionChannelCode()}));
                itemDtos.add(dimensionItemDto3);
                searchPriceDto.setDimensionItems(itemDtos);
                Map priceVoMap = this.priceModelVoService.handleSearchPrice(searchPriceDto);
                if (priceVoMap != null && (priceModelVo = (PriceModelVo)priceVoMap.get(priceVo.getApportionProductCode())) != null) {
                    priceVo.setStandardSupplyPrice(priceModelVo.getPrice());
                }
                searchPriceDto.setPriceTypeCode("fzredlineprice");
                Map redLinePriceVoMap = this.priceModelVoService.handleSearchPrice(searchPriceDto);
                if (redLinePriceVoMap != null && redLinePriceVoMap.get(priceVo.getApportionProductCode()) != null) {
                    priceVo.setSupplyMaterialRedLinePrice(((PriceModelVo)redLinePriceVoMap.get(priceVo.getApportionProductCode())).getPrice());
                } else {
                    priceVo.setSupplyMaterialRedLinePrice(BigDecimal.ZERO);
                }
            }
            priceVo.setInternalAmount(value2.stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            priceVo.setOffAmount(value2.stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            priceVo.setAutoAmount(value2.stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            priceVo.setActivityCost(value2.stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            BigDecimal promotionAmount = BigDecimal.ZERO;
            for (SubComActivityDesignDetailVo o2 : value2) {
                promotionAmount = promotionAmount.add(Optional.ofNullable(o2.getPromotionAmount()).orElse(BigDecimal.ZERO));
            }
            priceVo.setPromotionAmount(promotionAmount);
            priceVoList.add(priceVo);
        });
        return priceVoList;
    }

    private BigDecimal getMaxAmount(Date thisDate, List<SubComActivityDesignDetailVo> value2, List<String> activityDesignDetailCodeList) {
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (SubComActivityDesignDetailVo item : value2) {
            if (item.getActivityBeginTime().compareTo(thisDate) > 0 || item.getActivityEndTime().compareTo(thisDate) < 0) continue;
            totalAmount = totalAmount.add(Optional.ofNullable(item.getDiscountAmount()).orElse(BigDecimal.ZERO));
            activityDesignDetailCodeList.add(item.getActivityDesignDetailCode());
        }
        return totalAmount;
    }

    private List<FinalFixedExpenseVo> getFixedExpenseList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes) {
        if (Objects.isNull(activityPlanTableVo)) {
            return null;
        }
        ArrayList<FinalFixedExpenseVo> fixedExpenseVoList = new ArrayList<FinalFixedExpenseVo>();
        ProfitGoalDiscountDto profitGoalDiscountDto = new ProfitGoalDiscountDto();
        profitGoalDiscountDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        profitGoalDiscountDto.setOrgCode(activityPlanTableVo.getOrgCode());
        profitGoalDiscountDto.setTypeCodeList(Arrays.asList(BudgetAmountTypeEnum.FIXED_PAY.getCode(), BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode()));
        profitGoalDiscountDto.setSpecialDataStatus(ConfirmEunm.COMPLETETHECONFIRMATION.getCode());
        List profitGoalDiscountVos = this.profitGoalDiscountService.groupListByConditions(profitGoalDiscountDto);
        if (CollectionUtils.isNotEmpty((Collection)profitGoalDiscountVos)) {
            profitGoalDiscountVos.forEach(item -> {
                FinalFixedExpenseVo finalFixedExpenseVo = (FinalFixedExpenseVo)this.nebulaToolkitService.copyObjectByWhiteList(item, FinalFixedExpenseVo.class, null, null, new String[0]);
                fixedExpenseVoList.add(finalFixedExpenseVo);
            });
        }
        return fixedExpenseVoList;
    }

    private List<ReferendumCostVo> getReferendumCostList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes) {
        if (Objects.isNull(activityPlanTableVo)) {
            return null;
        }
        ArrayList<ReferendumCostVo> referendumCostVoList = new ArrayList<ReferendumCostVo>();
        SalesApprovalDto salesApprovalDto = new SalesApprovalDto();
        salesApprovalDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        salesApprovalDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
        OrgVo orgVo = this.orgVoService.findByOrgCode(activityPlanTableVo.getOrgCode());
        if (null == orgVo || StringUtils.isEmpty((CharSequence)orgVo.getSalesOrgCode())) {
            return null;
        }
        SalesOrgVo salesOrgVo = this.salesOrgVoService.findBySalesOrgCode(orgVo.getSalesOrgCode());
        if (null == salesOrgVo || StringUtils.isEmpty((CharSequence)salesOrgVo.getErpCode())) {
            return null;
        }
        List salesOrgSubComOrgVos = this.salesOrgSubComOrgService.findBySaleOrgErpCode(salesOrgVo.getErpCode());
        if (CollectionUtils.isEmpty((Collection)salesOrgSubComOrgVos)) {
            return null;
        }
        List customerErpCodeList = salesOrgSubComOrgVos.stream().map(SalesOrgSubComOrgVo::getSubComOrgCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(customerErpCodeList)) {
            return null;
        }
        List customerVos = this.customerVoService.findByErpCodeList(customerErpCodeList);
        if (CollectionUtils.isEmpty((Collection)customerVos)) {
            return null;
        }
        List customerCodeList = customerVos.stream().map(CustomerVo::getCustomerCode).collect(Collectors.toList());
        salesApprovalDto.setCustomerCodeList(customerCodeList);
        salesApprovalDto.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
        List psmList = this.activityDetailPlanItemSdkService.findPsmList(salesApprovalDto);
        if (CollectionUtils.isEmpty((Collection)psmList)) {
            return null;
        }
        psmList.forEach(item -> {
            ReferendumCostVo referendumCostVo = (ReferendumCostVo)this.nebulaToolkitService.copyObjectByWhiteList(item, ReferendumCostVo.class, null, null, new String[0]);
            referendumCostVoList.add(referendumCostVo);
        });
        return referendumCostVoList;
    }

    private List<CostCollectVo> getCostCollectList(List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        List productVoList;
        List productCodeList;
        ArrayList<CostCollectVo> costCollectVoList = new ArrayList<CostCollectVo>();
        if (CollectionUtils.isEmpty(subComActivityDesignDetailVoList)) {
            return new ArrayList<CostCollectVo>();
        }
        Map<String, List<SubComActivityDesignDetailVo>> collect = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(SubComActivityDesignDetailVo::getActivityDesignDetailCode));
        collect.forEach((key, value) -> {
            SubComActivityDesignDetailVo designDetail = (SubComActivityDesignDetailVo)value.get(0);
            BigDecimal priceEffect = this.calculatePriceEffect(designDetail);
            CostCollectVo costCollectVo = (CostCollectVo)this.nebulaToolkitService.copyObjectByWhiteList(value.get(0), CostCollectVo.class, null, null, new String[0]);
            costCollectVo.setPriceEffect(priceEffect);
            costCollectVoList.add(costCollectVo);
        });
        List bigDateList = costCollectVoList.stream().filter(item -> IsBigDateOrNoEnum.isbigdate.getCode().equals(item.getIsBigDate())).collect(Collectors.toList());
        if (!(CollectionUtils.isEmpty(bigDateList) || CollectionUtils.isEmpty(productCodeList = bigDateList.stream().map(CostCollectVo::getProductCode).filter(Objects::nonNull).distinct().collect(Collectors.toList())) || CollectionUtils.isEmpty((Collection)(productVoList = this.productVoService.findByCodes(productCodeList))))) {
            Map productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (o, n) -> n));
            for (CostCollectVo costCollectVo : bigDateList) {
                if (!productVoMap.containsKey(costCollectVo.getProductCode())) continue;
                ProductVo productVo = (ProductVo)productVoMap.get(costCollectVo.getProductCode());
                costCollectVo.setProductExpirationDate(productVo.getExpirationDate());
            }
        }
        return costCollectVoList;
    }

    private BigDecimal calculatePriceEffect(SubComActivityDesignDetailVo designDetail) {
        if (ObjectUtils.isEmpty((Object)designDetail)) {
            return null;
        }
        BigDecimal priceEffect = BigDecimal.ZERO;
        if (!"HDMBPZ3919".equals(designDetail.getTemplateConfigCode())) {
            return null;
        }
        if (BooleanEnum.TRUE.getCapital().equals(designDetail.getIsAssPromotion())) {
            if (ObjectUtils.isNotEmpty((Object)designDetail.getTotalCost()) && ObjectUtils.isNotEmpty((Object)designDetail.getPromoteSales())) {
                return designDetail.getTotalCost().divide(designDetail.getPromoteSales(), 2, 1);
            }
        } else if ("ZS03".equals(designDetail.getActivityFormCode())) {
            if (ObjectUtils.isNotEmpty((Object)designDetail.getOriginalProductPrice()) && ObjectUtils.isNotEmpty((Object)designDetail.getActivityPrice())) {
                return designDetail.getOriginalProductPrice().subtract(designDetail.getActivityPrice());
            }
        } else if ("ZS01".equals(designDetail.getActivityFormCode())) {
            if (ObjectUtils.isNotEmpty((Object)designDetail.getOriginalProductPrice()) && ObjectUtils.isNotEmpty((Object)designDetail.getOriginalProductNumber()) && ObjectUtils.isNotEmpty((Object)designDetail.getGiftProductNumber())) {
                BigDecimal multiply = designDetail.getOriginalProductPrice().multiply(designDetail.getOriginalProductNumber());
                BigDecimal add = designDetail.getOriginalProductNumber().add(designDetail.getGiftProductNumber());
                if (BigDecimal.ZERO.compareTo(add) == 0) {
                    return null;
                }
                return designDetail.getOriginalProductPrice().subtract(multiply.divide(add, 2, 1));
            }
        } else if (ObjectUtils.isNotEmpty((Object)designDetail.getTotalCost()) && ObjectUtils.isNotEmpty((Object)designDetail.getPromoteSales())) {
            return designDetail.getTotalCost().divide(designDetail.getPromoteSales(), 2, 1);
        }
        return null;
    }

    private List<SaleForecastVo> getSaleForecastList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        ArrayList<SaleForecastVo> saleForecastVoList = new ArrayList<SaleForecastVo>();
        Map<String, List<Object>> salesPlanVoMap = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(o -> o.getErpCode() + "-" + o.getProductCode()));
        }
        salesPlanVoMap.forEach((key, value) -> {
            SaleForecastVo saleForecastVo = new SaleForecastVo();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
            try {
                saleForecastVo.setFeeYearMonth(sdf.parse(activityPlanTableVo.getYearAndMonth()));
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            SalesPlanVo salesPlanVo = (SalesPlanVo)value.get(0);
            saleForecastVo.setOrgCode(activityPlanTableVo.getOrgCode());
            saleForecastVo.setOrgName(activityPlanTableVo.getOrgName());
            saleForecastVo.setDepartmentCode(salesPlanVo.getSalesOrgRegionCode());
            saleForecastVo.setDepartmentName(salesPlanVo.getSalesOrgRegionName());
            saleForecastVo.setSalesOrgCode(salesPlanVo.getSalesOrgProvinceCode());
            saleForecastVo.setSalesOrgName(salesPlanVo.getSalesOrgProvinceName());
            saleForecastVo.setCustomerCode(salesPlanVo.getErpCode());
            saleForecastVo.setCustomerName(salesPlanVo.getCustomerName());
            saleForecastVo.setProductBrandCode(salesPlanVo.getProductBrandCode());
            saleForecastVo.setProductBrandName(salesPlanVo.getProductBrandName());
            saleForecastVo.setProductCategoryCode(salesPlanVo.getProductCategoryCode());
            saleForecastVo.setProductCategoryName(salesPlanVo.getProductCategoryName());
            saleForecastVo.setProductItemCode(salesPlanVo.getProductItemCode());
            saleForecastVo.setProductItemName(salesPlanVo.getProductItemName());
            saleForecastVo.setProductCode(salesPlanVo.getProductCode());
            saleForecastVo.setProductName(salesPlanVo.getProductName());
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                saleForecastVo.setBeforeDiscountCostAndFreight(value.stream().map(SalesPlanVo::getCifPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
                saleForecastVo.setBeforeDiscountProvideGoodsPrice(value.stream().map(SalesPlanVo::getStandardSupplyPrice).filter(Objects::nonNull).findFirst().orElse(BigDecimal.ZERO));
                saleForecastVo.setMonthOutStockQuantity(value.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                saleForecastVo.setBeforeDiscountSaleIncome(value.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                saleForecastVo.setBeforeDiscountSaleCost(value.stream().map(SalesPlanVo::getTheoryCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                saleForecastVo.setTheoryProfit(saleForecastVo.getBeforeDiscountSaleIncome().subtract(saleForecastVo.getBeforeDiscountSaleCost()));
                if (saleForecastVo.getBeforeDiscountSaleIncome().compareTo(BigDecimal.ZERO) != 0) {
                    saleForecastVo.setTheoryGrossMarginRate(saleForecastVo.getTheoryProfit().divide(saleForecastVo.getBeforeDiscountSaleIncome(), 6, RoundingMode.HALF_UP));
                }
                saleForecastVo.setAfterDiscountSaleQuantity(value.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                saleForecastVo.setAfterDiscountCost(value.stream().map(SalesPlanVo::getDiscountedCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
            }
            saleForecastVoList.add(saleForecastVo);
        });
        return saleForecastVoList;
    }

    private List<PutOutputRatioVo> getPutOutputRatioList(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoListl) {
        Map<Object, Object> salesPlanVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getErpCode()).orElse("")));
        }
        List subComActivityDesignDetailVoList = subComActivityDesignDetailVoListl.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())).collect(Collectors.toList());
        ArrayList<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<PutOutputRatioVo>();
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)) {
            List customerVoList;
            Set customerErpCodeSet = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getCustomerCode).filter(Objects::nonNull).collect(Collectors.toSet());
            HashMap<String, List<CustomerVo>> customerMap = new HashMap<String, List<CustomerVo>>();
            if (CollectionUtils.isNotEmpty(customerErpCodeSet) && CollectionUtils.isNotEmpty((Collection)(customerVoList = this.customerVoService.findByErpCodeList(new ArrayList(customerErpCodeSet))))) {
                customerMap.putAll(customerVoList.stream().collect(Collectors.groupingBy(CustomerVo::getErpCode)));
            }
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerCode()).orElse("")));
            Map<Object, Object> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value) -> {
                Map value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = (SubComActivityDesignDetailVo)value.get(0);
                PutOutputRatioVo putOutputRatioVo = (PutOutputRatioVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null, new String[0]);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                List salesPlanVoList1 = (List)finalSalesPlanVoMap.get(key);
                if (CollectionUtils.isNotEmpty((Collection)salesPlanVoList1)) {
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                }
                if (null != putOutputRatioVo.getCustomerCode() && customerMap.containsKey(putOutputRatioVo.getCustomerCode())) {
                    CustomerVo customerVo = (CustomerVo)((List)customerMap.get(putOutputRatioVo.getCustomerCode())).get(0);
                    putOutputRatioVo.setDepartmentCode(customerVo.getSalesOrgCode());
                    putOutputRatioVo.setDepartmentName(customerVo.getSalesOrgName());
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<PutOutputRatioVo>();
    }

    private List<PutOutputRatioVo> getPutOutputRatioListGroupByOrgCode(List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4salesPlanVoList:{}", (Object)JSON.toJSONString(salesPlanVoList));
        log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4subComActivityDesignDetailVoList:{}", (Object)JSON.toJSONString(subComActivityDesignDetailVoList));
        Map<Object, Object> salesPlanVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("")));
        }
        log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4salesPlanVoMap:{}", (Object)JSON.toJSONString(salesPlanVoMap));
        ArrayList<PutOutputRatioVo> putOutputRatioVoList = new ArrayList<PutOutputRatioVo>();
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)) {
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getOrgCode()).orElse("")));
            log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4subComActivityDesignDetailVoMap:{}", (Object)JSON.toJSONString(subComActivityDesignDetailVoMap));
            Map<Object, Object> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value) -> {
                log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4key:{},value:{}", (Object)JSON.toJSONString((Object)key), (Object)JSON.toJSONString((Object)subComActivityDesignDetailVoMap));
                Map value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = (SubComActivityDesignDetailVo)value.get(0);
                PutOutputRatioVo putOutputRatioVo = (PutOutputRatioVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignDetailVo, PutOutputRatioVo.class, null, null, new String[0]);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                List salesPlanVoList1 = (List)finalSalesPlanVoMap.get(key);
                log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4salesPlanVoList1:{}", (Object)JSON.toJSONString((Object)salesPlanVoList1));
                if (CollectionUtils.isNotEmpty((Collection)salesPlanVoList1)) {
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    log.info("\u5b9e\u65f6\u7248\u67e5\u8be2\u6295\u5165\u4ea7\u51fa\u6bd4putOutputRatioVo:{}", (Object)JSON.toJSONString((Object)putOutputRatioVo));
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                    if (putOutputRatioVo.getBeforeDiscountIncome() != null && putOutputRatioVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setBeforeInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setAfterInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<PutOutputRatioVo>();
    }

    private List<PutOutputRatioCustomerVo> getPutOutputRatioListGroupByCustomerCode(List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        Map<Object, Object> salesPlanVoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getErpCode()).orElse("")));
        }
        subComActivityDesignDetailVoList = subComActivityDesignDetailVoList.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())).collect(Collectors.toList());
        ArrayList<PutOutputRatioCustomerVo> putOutputRatioVoList = new ArrayList<PutOutputRatioCustomerVo>();
        if (CollectionUtils.isNotEmpty(subComActivityDesignDetailVoList)) {
            Map<String, List<SubComActivityDesignDetailVo>> subComActivityDesignDetailVoMap = subComActivityDesignDetailVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerCode()).orElse("")));
            Map<Object, Object> finalSalesPlanVoMap = salesPlanVoMap;
            subComActivityDesignDetailVoMap.forEach((key, value) -> {
                Map value2 = value.stream().collect(Collectors.toMap(SubComActivityDesignDetailVo::getActivityDesignDetailCode, Function.identity(), (o, n) -> o));
                SubComActivityDesignDetailVo subComActivityDesignDetailVo = (SubComActivityDesignDetailVo)value.get(0);
                PutOutputRatioCustomerVo putOutputRatioVo = (PutOutputRatioCustomerVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)subComActivityDesignDetailVo, PutOutputRatioCustomerVo.class, null, null, new String[0]);
                putOutputRatioVo.setTotalCost(value2.values().stream().map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOffAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setInternalAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setAutoAmount(value2.values().stream().map(SubComActivityDesignDetailVo::getAutoAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setDisplay(value2.values().stream().filter(e -> "Z0001".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setPersonnel(value2.values().stream().filter(e -> "Z0002".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setPromotion(value2.values().stream().filter(e -> "Z0003".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setSell(value2.values().stream().filter(e -> "Z0006".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setMaterial(value2.values().stream().filter(e -> "Z0008".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setChannelConstruction(value2.values().stream().filter(e -> "Z0014".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setDisposalOfUsedGoods(value2.values().stream().filter(e -> "Z0038".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                putOutputRatioVo.setOther(value2.values().stream().filter(e -> "Z0039".equals(e.getActivityTypeCode())).map(SubComActivityDesignDetailVo::getTotalCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                List salesPlanVoList1 = (List)finalSalesPlanVoMap.get(key);
                if (CollectionUtils.isNotEmpty((Collection)salesPlanVoList1)) {
                    putOutputRatioVo.setBeforeDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    putOutputRatioVo.setAfterDiscountIncome(salesPlanVoList1.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setInputOutputRatio(Optional.ofNullable(putOutputRatioVo.getTotalCost()).orElse(BigDecimal.ZERO).divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                        DecimalFormat df = new DecimalFormat("0.0000%");
                        putOutputRatioVo.setInputOutPutRatioStr(df.format(putOutputRatioVo.getInputOutputRatio()));
                    }
                    if (putOutputRatioVo.getBeforeDiscountIncome() != null && putOutputRatioVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setBeforeInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                    if (putOutputRatioVo.getAfterDiscountIncome() != null && putOutputRatioVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        putOutputRatioVo.setAfterInputOutputRatio(putOutputRatioVo.getTotalCost().divide(putOutputRatioVo.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    }
                }
                putOutputRatioVoList.add(putOutputRatioVo);
            });
            return putOutputRatioVoList;
        }
        return new ArrayList<PutOutputRatioCustomerVo>();
    }

    private List<ActivityPlanProfitVo> getActivityPlanProfit(ActivityPlanTableVo activityPlanTableVo, Set<String> orgCodes, List<SalesPlanVo> salesPlanVoList, List<SubComActivityDesignDetailVo> subComActivityDesignDetailVoList) {
        List specialCostVos1;
        List fixedExpenseVos;
        List specialCostList;
        PageRequest page = PageRequest.of((int)0, (int)Integer.MAX_VALUE);
        CustomerChannelDto customerChannelDto = new CustomerChannelDto();
        Page customerChannelVoPage = this.customerChannelVoService.findByConditions((Pageable)page, customerChannelDto);
        Map<Object, Object> customerChannelVoMap = new HashMap();
        if (customerChannelVoPage != null && CollectionUtils.isNotEmpty((Collection)customerChannelVoPage.getRecords())) {
            customerChannelVoMap = customerChannelVoPage.getRecords().stream().collect(Collectors.toMap(CustomerChannelVo::getCustomerChannelCode, Function.identity()));
        }
        ActivityPlanProfitVo total = new ActivityPlanProfitVo();
        total.setIsTotal(Boolean.valueOf(true));
        total.setOutStorageQuantity(BigDecimal.ZERO);
        total.setBeforeDiscountIncome(BigDecimal.ZERO);
        total.setBeforeDiscountCost(BigDecimal.ZERO);
        total.setAfterDiscountIncome(BigDecimal.ZERO);
        total.setTheoryGrossMarginAmount(BigDecimal.ZERO);
        total.setTheoryGrossMarginRate(BigDecimal.ZERO);
        ArrayList<ActivityPlanProfitVo> activityPlanProfitList = new ArrayList<ActivityPlanProfitVo>();
        HashMap chanalCodeToSaleQuantityRatioMap = Maps.newHashMap();
        SubComBudgetForecastVo subComBudgetForecastVo = new SubComBudgetForecastVo();
        subComBudgetForecastVo.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        subComBudgetForecastVo.setOrgCode(activityPlanTableVo.getOrgCode());
        subComBudgetForecastVo.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        BigDecimal totalTaxAndAddition = this.subComBudgetForecastService.queryTaxAndAddition(subComBudgetForecastVo);
        total.setTaxAndAddition(totalTaxAndAddition);
        if (CollectionUtils.isNotEmpty(salesPlanVoList)) {
            Map<String, List<SalesPlanVo>> salesPlanVoMap = salesPlanVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse("")));
            ArrayList<ActivityPlanProfitVo> finalActivityPlanProfitList = activityPlanProfitList;
            salesPlanVoMap.forEach((key, value) -> {
                ActivityPlanProfitVo activityPlanProfitVo = new ActivityPlanProfitVo();
                activityPlanProfitVo.setIsTotal(Boolean.valueOf(false));
                activityPlanProfitVo.setCustomerChannelCode(key);
                SalesPlanVo salesPlanVo = (SalesPlanVo)value.get(0);
                BigDecimal planQuantity = value.stream().map(SalesPlanVo::getPlanQuantity).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setOutStorageQuantity(planQuantity);
                activityPlanProfitVo.setCustomerChannelName(salesPlanVo.getCustomerChannelName());
                total.setOutStorageQuantity(total.getOutStorageQuantity().add(planQuantity));
                BigDecimal amount = value.stream().map(SalesPlanVo::getAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                BigDecimal theoryIncome = value.stream().map(SalesPlanVo::getTheoryIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setBeforeDiscountIncome(theoryIncome);
                total.setBeforeDiscountIncome(total.getBeforeDiscountIncome().add(theoryIncome));
                BigDecimal theoryCost = value.stream().map(SalesPlanVo::getTheoryCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setBeforeDiscountCost(theoryCost);
                total.setBeforeDiscountCost(total.getBeforeDiscountCost().add(theoryCost));
                BigDecimal discountAmount = value.stream().map(SalesPlanVo::getDiscountedIncome).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                activityPlanProfitVo.setAfterDiscountIncome(discountAmount);
                total.setAfterDiscountIncome(total.getAfterDiscountIncome().add(discountAmount));
                activityPlanProfitVo.setTheoryGrossMarginAmount(theoryIncome.subtract(theoryCost));
                total.setTheoryGrossMarginAmount(total.getTheoryGrossMarginAmount().add(activityPlanProfitVo.getTheoryGrossMarginAmount()));
                if (Objects.nonNull(activityPlanProfitVo.getTheoryGrossMarginAmount()) && Objects.nonNull(activityPlanProfitVo.getBeforeDiscountIncome()) && activityPlanProfitVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                    activityPlanProfitVo.setTheoryGrossMarginRate(activityPlanProfitVo.getTheoryGrossMarginAmount().divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
                }
                finalActivityPlanProfitList.add(activityPlanProfitVo);
            });
            if (Objects.nonNull(total.getBeforeDiscountIncome()) && total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                total.setTheoryGrossMarginRate(Optional.ofNullable(total.getTheoryGrossMarginAmount()).orElse(BigDecimal.ZERO).divide(total.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            }
            activityPlanProfitList.forEach(item -> {
                if (Objects.nonNull(item.getAfterDiscountIncome()) && item.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                    item.setSaleQuantityRatio(Optional.ofNullable(item.getAfterDiscountIncome()).orElse(BigDecimal.ZERO).divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
                    BigDecimal saleQuantityRatio = item.getSaleQuantityRatio();
                    chanalCodeToSaleQuantityRatioMap.put(item.getCustomerChannelCode(), saleQuantityRatio);
                    item.setTaxAndAddition(saleQuantityRatio.multiply(Optional.ofNullable(totalTaxAndAddition).orElse(BigDecimal.ZERO)));
                }
            });
            total.setSaleQuantityRatio(BigDecimal.ONE);
        }
        SubComActivityDesignDetailDto subComActivityDesignDetailDto = new SubComActivityDesignDetailDto();
        List activityDesignDetailCodeList = subComActivityDesignDetailVoList.stream().map(SubComActivityDesignDetailVo::getActivityDesignDetailCode).collect(Collectors.toList());
        subComActivityDesignDetailDto.setActivityDesignDetailCodeList(activityDesignDetailCodeList);
        subComActivityDesignDetailDto.setOrgCodeSet(orgCodes);
        List specialCostVoList = Optional.ofNullable(this.subComActivityDesignDetailService.findSpecialCost(subComActivityDesignDetailDto)).orElse(new ArrayList());
        Map activityPlanProfitVoMap = activityPlanProfitList.stream().collect(Collectors.toMap(ActivityPlanProfitVo::getCustomerChannelCode, Function.identity()));
        specialCostVoList = specialCostVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SpecialCostVo>(Comparator.comparing(SpecialCostVo::getActivityDesignDetailCode))), ArrayList::new));
        Map<String, Map<String, List<SpecialCostVo>>> specialCostVoMap = specialCostVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(""), Collectors.groupingBy(item -> Optional.ofNullable(item.getActivityTypeCode()).orElse(""))));
        Map<Object, Object> finalCustomerChannelVoMap = customerChannelVoMap;
        specialCostVoMap.forEach((key, value) -> {
            SpecialCostVo specialCostVoTotal = new SpecialCostVo();
            specialCostVoTotal.setIsTotal(Boolean.valueOf(true));
            specialCostVoTotal.setCustomerChannelCode(key);
            specialCostVoTotal.setSpecialCost(BigDecimal.ZERO);
            ActivityPlanProfitVo activityPlanProfitVo = (ActivityPlanProfitVo)activityPlanProfitVoMap.get(key);
            ArrayList<SpecialCostVo> specialCostList = new ArrayList<SpecialCostVo>();
            if (activityPlanProfitVo == null) {
                ActivityPlanProfitVo activityPlanProfitVo2 = new ActivityPlanProfitVo();
                activityPlanProfitVo2.setIsTotal(Boolean.valueOf(false));
                activityPlanProfitVo2.setCustomerChannelCode(key);
                CustomerChannelVo customerChannelVo = (CustomerChannelVo)finalCustomerChannelVoMap.get(key);
                if (customerChannelVo != null) {
                    activityPlanProfitVo2.setCustomerChannelName(customerChannelVo.getCustomerChannelName());
                }
                activityPlanProfitVo2.setPointInCost(BigDecimal.ZERO);
                activityPlanProfitVo2.setPointOutCost(BigDecimal.ZERO);
                activityPlanProfitVo2.setProductPromotionCostNumerator(BigDecimal.ZERO);
                activityPlanProfitVo2.setPointInCostRateNumerator(BigDecimal.ZERO);
                value.forEach((key2, value2) -> {
                    SpecialCostVo specialCostVo = (SpecialCostVo)value2.get(0);
                    specialCostVoTotal.setCustomerChannelName(specialCostVo.getCustomerChannelName());
                    SpecialCostVo specialCostVo1 = new SpecialCostVo();
                    specialCostVo1.setIsTotal(Boolean.valueOf(false));
                    specialCostVo1.setActivityTypeCode(key2);
                    specialCostVo1.setActivityTypeName(specialCostVo.getActivityTypeName());
                    specialCostVo1.setSpecialCost(value2.stream().map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    specialCostList.add(specialCostVo1);
                    activityPlanProfitVo2.setPointInCost(activityPlanProfitVo2.getPointInCost().add(value2.stream().map(SpecialCostVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    activityPlanProfitVo2.setPointOutCost(activityPlanProfitVo2.getPointOutCost().add(value2.stream().map(SpecialCostVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo1.getSpecialCost()));
                    activityPlanProfitVo2.setProductPromotionCostNumerator(activityPlanProfitVo2.getProductPromotionCostNumerator().add(value2.stream().filter(o -> Objects.nonNull(o.getIsRelatePrice())).filter(SpecialCostVo::getIsRelatePrice).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    activityPlanProfitVo2.setPointInCostRateNumerator(activityPlanProfitVo2.getPointInCostRateNumerator().add(value2.stream().filter(o -> Objects.nonNull(o.getIsRelatePrice())).filter(o -> o.getIsRelatePrice() == false).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                });
                specialCostList.add(specialCostVoTotal);
                activityPlanProfitVo2.setSpecialCostList(specialCostList);
                activityPlanProfitVoMap.put((String)key, activityPlanProfitVo2);
            } else {
                specialCostVoTotal.setCustomerChannelName(activityPlanProfitVo.getCustomerChannelName());
                activityPlanProfitVo.setPointInCost(BigDecimal.ZERO);
                activityPlanProfitVo.setPointOutCost(BigDecimal.ZERO);
                activityPlanProfitVo.setProductPromotionCostNumerator(BigDecimal.ZERO);
                activityPlanProfitVo.setPointInCostRateNumerator(BigDecimal.ZERO);
                value.forEach((key2, value2) -> {
                    SpecialCostVo specialCostVo = (SpecialCostVo)value2.get(0);
                    SpecialCostVo specialCostVo1 = new SpecialCostVo();
                    specialCostVo1.setIsTotal(Boolean.valueOf(false));
                    specialCostVo1.setActivityTypeCode(key2);
                    specialCostVo1.setActivityTypeName(specialCostVo.getActivityTypeName());
                    specialCostVo1.setSpecialCost(value2.stream().map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    specialCostList.add(specialCostVo1);
                    activityPlanProfitVo.setPointInCost(activityPlanProfitVo.getPointInCost().add(value2.stream().map(SpecialCostVo::getInternalAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    activityPlanProfitVo.setPointOutCost(activityPlanProfitVo.getPointOutCost().add(value2.stream().map(SpecialCostVo::getOffAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    if (activityPlanProfitVo.getPointInCost() != null && activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        activityPlanProfitVo.setPointInCostRatio(activityPlanProfitVo.getPointInCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, 4));
                    }
                    if (activityPlanProfitVo.getPointOutCost() != null && activityPlanProfitVo.getAfterDiscountIncome() != null && activityPlanProfitVo.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                        activityPlanProfitVo.setPointOutCostRatio(activityPlanProfitVo.getPointOutCost().divide(activityPlanProfitVo.getAfterDiscountIncome(), 2, 4));
                    }
                    specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo1.getSpecialCost()));
                    activityPlanProfitVo.setProductPromotionCostNumerator(activityPlanProfitVo.getProductPromotionCostNumerator().add(value2.stream().filter(o -> Objects.nonNull(o.getIsRelatePrice())).filter(SpecialCostVo::getIsRelatePrice).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                    activityPlanProfitVo.setPointInCostRateNumerator(activityPlanProfitVo.getPointInCostRateNumerator().add(value2.stream().filter(o -> Objects.nonNull(o.getIsRelatePrice())).filter(o -> o.getIsRelatePrice() == false).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
                });
                specialCostList.add(specialCostVoTotal);
                activityPlanProfitVo.setSpecialCostList(specialCostList);
            }
        });
        HashMap specialCostVoTotalMap = new HashMap();
        SpecialCostVo specialCostVoVo1 = new SpecialCostVo();
        activityPlanProfitVoMap.forEach((key, value) -> {
            List specialCostVoList2 = value.getSpecialCostList();
            if (CollectionUtils.isNotEmpty((Collection)specialCostVoList2)) {
                for (SpecialCostVo specialCostVo : specialCostVoList2) {
                    if (!specialCostVo.getIsTotal().booleanValue()) {
                        SpecialCostVo specialCostVoTotal = (SpecialCostVo)specialCostVoTotalMap.get(specialCostVo.getActivityTypeCode());
                        if (null == specialCostVoTotal) {
                            specialCostVoTotal = new SpecialCostVo();
                            specialCostVoTotal.setIsTotal(Boolean.valueOf(false));
                            specialCostVoTotal.setActivityTypeCode(specialCostVo.getActivityTypeCode());
                            specialCostVoTotal.setActivityTypeName(specialCostVo.getActivityTypeName());
                            specialCostVoTotal.setSpecialCost(BigDecimal.ZERO);
                            specialCostVoTotalMap.put(specialCostVo.getActivityTypeCode(), specialCostVoTotal);
                        }
                        specialCostVoTotal.setSpecialCost(specialCostVoTotal.getSpecialCost().add(specialCostVo.getSpecialCost()));
                        continue;
                    }
                    specialCostVoVo1.setIsTotal(Boolean.valueOf(true));
                    specialCostVoVo1.setSpecialCost(Optional.ofNullable(specialCostVoVo1.getSpecialCost()).orElse(BigDecimal.ZERO).add(specialCostVo.getSpecialCost()));
                }
            }
        });
        ArrayList<SpecialCostVo> specialCostVos = new ArrayList<SpecialCostVo>();
        if (CollectionUtils.isNotEmpty(specialCostVoTotalMap.values())) {
            specialCostVoTotalMap.values().forEach(item -> specialCostVos.add((SpecialCostVo)item));
            specialCostVos.add(specialCostVoVo1);
        }
        total.setSpecialCostList(specialCostVos);
        activityPlanProfitList = new ArrayList();
        if (CollectionUtils.isNotEmpty(activityPlanProfitVoMap.values())) {
            activityPlanProfitList.addAll(activityPlanProfitVoMap.values());
        }
        ProfitGoalDiscountDto profitGoalDiscountDto = new ProfitGoalDiscountDto();
        profitGoalDiscountDto.setOrgCode(activityPlanTableVo.getOrgCode());
        profitGoalDiscountDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        List fixedExpenseVoList = this.profitGoalDiscountService.findFixedExpense(profitGoalDiscountDto);
        if (CollectionUtils.isNotEmpty((Collection)fixedExpenseVoList) && CollectionUtils.isNotEmpty(activityPlanProfitList)) {
            Map<String, String> budgetItemCodeToNameMap = fixedExpenseVoList.stream().filter(item -> BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(item.getTypeCode())).filter(item -> StringUtils.isNotEmpty((CharSequence)item.getBudgetSortCode()) && StringUtils.isNotEmpty((CharSequence)item.getBudgetSortName())).collect(Collectors.toMap(FixedExpenseVo::getBudgetSortCode, FixedExpenseVo::getBudgetSortName, (o, n) -> n));
            Map<String, Map<String, List<FixedExpenseVo>>> fixedExpenseVoMap = fixedExpenseVoList.stream().filter(item -> BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(item.getTypeCode())).filter(item -> Objects.nonNull(item.getFixedExpense()) && StringUtils.isNotEmpty((CharSequence)item.getBudgetSortCode())).collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(" "), Collectors.groupingBy(FixedExpenseVo::getBudgetSortCode)));
            Map<String, List<FixedExpenseVo>> assessDeductionVoMap = fixedExpenseVoList.stream().filter(item -> BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(item.getTypeCode())).filter(item -> Objects.nonNull(item.getFixedExpense())).collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getCustomerChannelCode()).orElse(" ")));
            Map<String, List<FixedExpenseVo>> haveNoChannelExpenseVoMap = fixedExpenseVoMap.getOrDefault(" ", Maps.newHashMap());
            HashMap budgetItemToNoChannelExpenseMap = Maps.newHashMap();
            haveNoChannelExpenseVoMap.forEach((key, value) -> budgetItemToNoChannelExpenseMap.put(key, value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            HashMap channelToAssessDeductionAmountMap = Maps.newHashMap();
            assessDeductionVoMap.forEach((key, value) -> channelToAssessDeductionAmountMap.put(key, value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)));
            activityPlanProfitList.forEach(activityPlanProfit -> {
                String thisChannelCode = activityPlanProfit.getCustomerChannelCode();
                BigDecimal saleQuantityRatio = (BigDecimal)chanalCodeToSaleQuantityRatioMap.get(thisChannelCode);
                HashMap thisChannelbudgetItemToNoChannelExpenseMap = Maps.newHashMap();
                BigDecimal noChannelAssessDeductionShareAmount = BigDecimal.ZERO;
                if (Objects.nonNull(saleQuantityRatio) && BigDecimal.ZERO.compareTo(saleQuantityRatio) != 0) {
                    if (!budgetItemToNoChannelExpenseMap.isEmpty()) {
                        budgetItemToNoChannelExpenseMap.forEach((key, value) -> thisChannelbudgetItemToNoChannelExpenseMap.put(key, saleQuantityRatio.multiply((BigDecimal)value)));
                    }
                    noChannelAssessDeductionShareAmount = saleQuantityRatio.multiply(channelToAssessDeductionAmountMap.getOrDefault(" ", BigDecimal.ZERO));
                }
                Map thisChannelbudgetItemToHaveChannelExpenseMap = fixedExpenseVoMap.getOrDefault(thisChannelCode, Maps.newHashMap());
                ArrayList fixedExpenseList = Lists.newArrayList();
                thisChannelbudgetItemToHaveChannelExpenseMap.forEach((key, value) -> {
                    FixedExpenseVo fixedExpenseVo1 = (FixedExpenseVo)value.get(0);
                    FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                    fixedExpenseVo.setBudgetSortCode(key);
                    fixedExpenseVo.setBudgetSortName(fixedExpenseVo1.getBudgetSortName());
                    BigDecimal fixedExpense = value.stream().map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                    fixedExpenseVo.setFixedExpense(fixedExpense.add(thisChannelbudgetItemToNoChannelExpenseMap.getOrDefault(key, BigDecimal.ZERO)));
                    fixedExpenseVo.setIsTotal(Boolean.valueOf(false));
                    fixedExpenseList.add(fixedExpenseVo);
                });
                thisChannelbudgetItemToNoChannelExpenseMap.forEach((key, value) -> {
                    if (!thisChannelbudgetItemToHaveChannelExpenseMap.containsKey(key)) {
                        FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                        fixedExpenseVo.setBudgetSortCode(key);
                        fixedExpenseVo.setBudgetSortName((String)budgetItemCodeToNameMap.get(key));
                        fixedExpenseVo.setIsTotal(Boolean.valueOf(false));
                        fixedExpenseVo.setFixedExpense(value);
                        fixedExpenseList.add(fixedExpenseVo);
                    }
                });
                activityPlanProfit.setHeadquartersAssess(noChannelAssessDeductionShareAmount.add(channelToAssessDeductionAmountMap.getOrDefault(thisChannelCode, BigDecimal.ZERO)).negate());
                if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList)) {
                    FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                    fixedExpenseVo.setFixedExpense(fixedExpenseList.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    fixedExpenseVo.setIsTotal(Boolean.valueOf(true));
                    fixedExpenseList.add(fixedExpenseVo);
                }
                activityPlanProfit.setFixedExpenseList((List)fixedExpenseList);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)fixedExpenseVoList)) {
            Map<String, List<FixedExpenseVo>> fixedExpenseVoMap = fixedExpenseVoList.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getTypeCode()).orElse("")));
            fixedExpenseVoMap.forEach((key, value) -> {
                if (BudgetAmountTypeEnum.FIXED_PAY.getCode().equals(key)) {
                    ArrayList<FixedExpenseVo> fixedExpenseVoList1 = new ArrayList<FixedExpenseVo>();
                    Map<String, List<FixedExpenseVo>> collect = value.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getBudgetSortCode()).orElse("")));
                    collect.forEach((key2, value2) -> {
                        FixedExpenseVo fixedExpenseVo1 = (FixedExpenseVo)value2.get(0);
                        FixedExpenseVo fixedExpenseVo = new FixedExpenseVo();
                        fixedExpenseVo.setIsTotal(Boolean.valueOf(false));
                        fixedExpenseVo.setBudgetSortCode(key2);
                        fixedExpenseVo.setBudgetSortName(fixedExpenseVo1.getBudgetSortName());
                        fixedExpenseVo.setFixedExpense(value2.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                        fixedExpenseVoList1.add(fixedExpenseVo);
                    });
                    FixedExpenseVo fixedExpenseVoTotal = new FixedExpenseVo();
                    fixedExpenseVoTotal.setIsTotal(Boolean.valueOf(true));
                    fixedExpenseVoTotal.setFixedExpense(fixedExpenseVoList1.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO));
                    fixedExpenseVoList1.add(fixedExpenseVoTotal);
                    total.setFixedExpenseList(fixedExpenseVoList1);
                }
                if (BudgetAmountTypeEnum.ASSESS_DEDUCTION.getCode().equals(key)) {
                    total.setHeadquartersAssess(value.stream().map(FixedExpenseVo::getFixedExpense).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO).negate());
                }
            });
        }
        SubComBudgetForecastDto subComBudgetForecastDto = new SubComBudgetForecastDto();
        subComBudgetForecastDto.setYearMonthLy(activityPlanTableVo.getYearAndMonth());
        subComBudgetForecastDto.setOrgCode(activityPlanTableVo.getOrgCode());
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.INTERNAL_POINT_FEE.getCode());
        List internalForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        BigDecimal internalApplyAmountUp = internalForecastVos.stream().map(SubComBudgetForecastVo::getApplyAmountUp).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal activityPointInCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointInCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal internalUsableAmount = internalApplyAmountUp.subtract(activityPointInCost);
        subComBudgetForecastDto.setFeeSourceCode(com.biz.crm.tpm.business.budget.forecast.sdk.enums.FeeSourceEnum.OFF_POINT_FEE.getCode());
        List offPointForecastVos = this.subComBudgetForecastService.listByConditions(subComBudgetForecastDto);
        BigDecimal offPointApplyAmountUp = offPointForecastVos.stream().map(SubComBudgetForecastVo::getApplyAmountUp).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal activityPointOutCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointOutCost).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal offPointUsableAmount = offPointApplyAmountUp.subtract(activityPointOutCost);
        activityPlanProfitList.forEach(activityPlanProfit -> {
            String thisChannelCode = activityPlanProfit.getCustomerChannelCode();
            BigDecimal saleQuantityRatio = (BigDecimal)chanalCodeToSaleQuantityRatioMap.get(thisChannelCode);
            if (Objects.nonNull(saleQuantityRatio) && BigDecimal.ZERO.compareTo(saleQuantityRatio) != 0) {
                activityPlanProfit.setPointInCost(saleQuantityRatio.multiply(internalUsableAmount).add(Optional.ofNullable(activityPlanProfit.getPointInCost()).orElse(BigDecimal.ZERO)));
                activityPlanProfit.setPointOutCost(saleQuantityRatio.multiply(offPointUsableAmount).add(Optional.ofNullable(activityPlanProfit.getPointOutCost()).orElse(BigDecimal.ZERO)));
            }
            if (activityPlanProfit.getPointInCost() != null && activityPlanProfit.getAfterDiscountIncome() != null && activityPlanProfit.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                activityPlanProfit.setPointInCostRatio(activityPlanProfit.getPointInCost().divide(activityPlanProfit.getAfterDiscountIncome(), 6, 4));
            }
            if (activityPlanProfit.getPointOutCost() != null && activityPlanProfit.getAfterDiscountIncome() != null && activityPlanProfit.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
                activityPlanProfit.setPointOutCostRatio(activityPlanProfit.getPointOutCost().divide(activityPlanProfit.getAfterDiscountIncome(), 6, 4));
            }
        });
        BigDecimal pointInCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointInCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal pointOutCost = activityPlanProfitList.stream().map(ActivityPlanProfitVo::getPointOutCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        total.setPointInCost(pointInCost);
        total.setPointOutCost(pointOutCost);
        if (total.getPointInCost() != null && total.getAfterDiscountIncome() != null && total.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
            total.setPointInCostRatio(total.getPointInCost().divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        if (total.getPointOutCost() != null && total.getAfterDiscountIncome() != null && total.getAfterDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
            total.setPointOutCostRatio(total.getPointOutCost().divide(total.getAfterDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        activityPlanProfitList.add(total);
        for (ActivityPlanProfitVo activityPlanProfitVo : activityPlanProfitList) {
            BigDecimal specialCostTotal = BigDecimal.ZERO;
            specialCostList = activityPlanProfitVo.getSpecialCostList();
            if (CollectionUtils.isNotEmpty((Collection)specialCostList)) {
                specialCostTotal = specialCostList.stream().filter(o -> Objects.nonNull(o.getIsTotal())).filter(SpecialCostVo::getIsTotal).map(SpecialCostVo::getSpecialCost).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            BigDecimal fixedExpenseTotal = BigDecimal.ZERO;
            List fixedExpenseList = activityPlanProfitVo.getFixedExpenseList();
            if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList)) {
                fixedExpenseTotal = fixedExpenseList.stream().filter(FixedExpenseVo::getIsTotal).map(FixedExpenseVo::getFixedExpense).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            }
            BigDecimal totalDownPay = specialCostTotal.add(fixedExpenseTotal);
            activityPlanProfitVo.setHeadquartersExpenseTotal(Optional.ofNullable(activityPlanProfitVo.getPointInCost()).orElse(BigDecimal.ZERO).add(Optional.ofNullable(activityPlanProfitVo.getPointOutCost()).orElse(BigDecimal.ZERO)).add(Optional.ofNullable(activityPlanProfitVo.getHeadquartersAssess()).orElse(BigDecimal.ZERO)));
            if (activityPlanProfitVo.getIsTotal().booleanValue()) {
                activityPlanProfitVo.setProfitAmount(Optional.ofNullable(activityPlanProfitVo.getTheoryGrossMarginAmount()).orElse(BigDecimal.ZERO).subtract(Optional.ofNullable(activityPlanProfitVo.getTaxAndAddition()).orElse(BigDecimal.ZERO)).subtract(totalDownPay).add(Optional.ofNullable(activityPlanProfitVo.getHeadquartersExpenseTotal()).orElse(BigDecimal.ZERO)));
            }
            if (!Objects.nonNull(activityPlanProfitVo.getBeforeDiscountIncome()) || activityPlanProfitVo.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) == 0) continue;
            activityPlanProfitVo.setProductPromotionCost(Optional.ofNullable(activityPlanProfitVo.getProductPromotionCostNumerator()).orElse(BigDecimal.ZERO).divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            activityPlanProfitVo.setOtherCostRatio(Optional.ofNullable(activityPlanProfitVo.getPointInCostRateNumerator()).orElse(BigDecimal.ZERO).divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            if (CollectionUtils.isNotEmpty((Collection)specialCostList)) {
                activityPlanProfitVo.setSpecialCostRate(specialCostTotal.divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            }
            if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList)) {
                activityPlanProfitVo.setPointInExpendCostRate(fixedExpenseTotal.divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
            }
            activityPlanProfitVo.setAllCostRate(totalDownPay.divide(activityPlanProfitVo.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        List fixedExpenseList = total.getFixedExpenseList();
        BigDecimal fixedExpense = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty((Collection)fixedExpenseList) && CollectionUtils.isNotEmpty(fixedExpenseVos = fixedExpenseList.stream().filter(o -> Objects.nonNull(o.getIsTotal())).filter(FixedExpenseVo::getIsTotal).collect(Collectors.toList()))) {
            fixedExpense = ((FixedExpenseVo)fixedExpenseVos.get(0)).getFixedExpense();
        }
        if (Objects.nonNull(total.getBeforeDiscountIncome()) && total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
            total.setPointInExpendCostRate(fixedExpense.divide(total.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        BigDecimal specialCost = BigDecimal.ZERO;
        specialCostList = total.getSpecialCostList();
        if (CollectionUtils.isNotEmpty((Collection)specialCostList) && CollectionUtils.isNotEmpty(specialCostVos1 = specialCostList.stream().filter(o -> Objects.nonNull(o.getIsTotal())).filter(SpecialCostVo::getIsTotal).collect(Collectors.toList()))) {
            specialCost = ((SpecialCostVo)specialCostVos1.get(0)).getSpecialCost();
        }
        if (Objects.nonNull(total.getBeforeDiscountIncome()) && total.getBeforeDiscountIncome().compareTo(BigDecimal.ZERO) != 0) {
            total.setAllCostRate(fixedExpense.add(specialCost).divide(total.getBeforeDiscountIncome(), 6, RoundingMode.HALF_UP));
        }
        return activityPlanProfitList;
    }

    public ActivityPlanTableVo selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto) {
        if (ObjectUtils.isEmpty((Object)dto)) {
            return null;
        }
        ActivityPlanTable activityPlanTable = this.activityPlanTableRepository.selectTableByYearMonthAndOrg(dto);
        if (ObjectUtils.isEmpty((Object)((Object)activityPlanTable))) {
            return null;
        }
        ActivityPlanTableVo tableVo = (ActivityPlanTableVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityPlanTable, ActivityPlanTableVo.class, HashSet.class, ArrayList.class, new String[0]);
        return tableVo;
    }

    public BigDecimal getAutoAmount(String yearAndMonth, String orgCode) {
        Validate.notBlank((CharSequence)yearAndMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        SubComBudgetForecastDto selectDto = new SubComBudgetForecastDto();
        selectDto.setYearMonthLy(yearAndMonth);
        selectDto.setOrgCode(orgCode);
        selectDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
        selectDto.setBusinessUnitCode(BusinessUnitEnum.SON_COMPANY.getCode());
        selectDto.setFeeSourceCode(FeeSourceEnum.AUTO_FEE.getCode());
        List subBudgetForecast = this.subComBudgetForecastService.findListByConditions(selectDto);
        if (!CollectionUtils.isEmpty((Collection)subBudgetForecast)) {
            if (subBudgetForecast.size() > 1) {
                throw new RuntimeException("\u66f4\u636e\u4e1a\u6001+\u4e1a\u52a1\u5355\u5143+\u5e74\u6708+\u7ec4\u7ec7\u7ef4\u5ea6\u67e5\u8be2\u5230\u591a\u4e2a\u81ea\u6295\u8d39\u7528\uff01");
            }
            return ((SubComBudgetForecastVo)subBudgetForecast.get(0)).getRemainderAmount();
        }
        return null;
    }

    public Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditionsForReport(Pageable pageable, FinalFixedExpenseDto dto2) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        return this.finalFixedExpenseRepository.findFinalFixedExpenseByConditionsForReport(pageable, dto2);
    }
}

