/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.plan.table.local.workFlowListener;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.plan.table.local.entity.ActivityPlanTable;
import com.biz.crm.tpm.business.activity.plan.table.local.repository.ActivityPlanTableRepository;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SubComActivityDesignDto;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.service.SubComActivityDesignService;
import com.biz.crm.workflow.sdk.dto.ProcessStatusDto;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.biz.crm.workflow.sdk.listener.ProcessCompleteListener;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class OrdinaryActivityPlanTableProcessCallBackListener
implements ProcessCompleteListener {
    private static final Logger log = LoggerFactory.getLogger(OrdinaryActivityPlanTableProcessCallBackListener.class);
    @Autowired(required=false)
    private SubComActivityDesignService subComActivityDesignService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ActivityPlanTableRepository activityPlanTableRepository;

    public String getBusinessCode() {
        return "ordinary_activity_plan_table_process";
    }

    @Transactional(rollbackFor={Exception.class})
    public void onProcessComplete(ProcessStatusDto dto) {
        Date yearAndMonth;
        SimpleDateFormat df;
        SubComActivityDesignDto subComActivityDesignDto;
        String processStatus = dto.getProcessStatus();
        ActivityPlanTable one = (ActivityPlanTable)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.activityPlanTableRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(UuidEntity::getId, (Object)dto.getBusinessNo())).one());
        Validate.notNull((Object)((Object)one), (String)"\u6838\u9500\u7533\u8bf7\u5ba1\u6279\u6d41\u7a0b\u56de\u8c03\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b9e\u4f8b", (Object[])new Object[0]);
        ActivityPlanTable two = new ActivityPlanTable();
        two.setId(one.getId());
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.PASS.getDictCode())) {
            try {
                this.subComActivityDesignService.passBatch(dto.getProcessNo(), one.getId());
                two.setProcessStatus(ProcessStatusEnum.PASS.getDictCode());
                this.activityPlanTableRepository.updateById((Object)two);
            }
            catch (Exception e) {
                log.error("\u6d3b\u52a8\u89c4\u5212\u5957\u8868\u5ba1\u6279\u51fa\u9519", (Throwable)e);
                throw e;
            }
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.REJECT.getDictCode())) {
            two.setProcessStatus(ProcessStatusEnum.REJECT.getDictCode());
            this.activityPlanTableRepository.updateById((Object)two);
            subComActivityDesignDto = new SubComActivityDesignDto();
            subComActivityDesignDto.setOrgCode(one.getOrgCode());
            df = new SimpleDateFormat("yyyy-MM");
            yearAndMonth = null;
            try {
                yearAndMonth = df.parse(one.getYearAndMonth());
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            subComActivityDesignDto.setFeeYearMonth(yearAndMonth);
            subComActivityDesignDto.setProcessStatus(processStatus);
            subComActivityDesignDto.setProcessNo(dto.getProcessNo());
            this.subComActivityDesignService.rejectBatch(subComActivityDesignDto);
        }
        if (String.valueOf(processStatus).equals(ProcessStatusEnum.RECOVER.getDictCode())) {
            two.setProcessStatus(ProcessStatusEnum.RECOVER.getDictCode());
            this.activityPlanTableRepository.updateById((Object)two);
            subComActivityDesignDto = new SubComActivityDesignDto();
            subComActivityDesignDto.setOrgCode(one.getOrgCode());
            df = new SimpleDateFormat("yyyy-MM");
            yearAndMonth = null;
            try {
                yearAndMonth = df.parse(one.getYearAndMonth());
            }
            catch (ParseException e) {
                log.error(e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            subComActivityDesignDto.setFeeYearMonth(yearAndMonth);
            subComActivityDesignDto.setProcessStatus(processStatus);
            subComActivityDesignDto.setProcessNo(dto.getProcessNo());
            this.subComActivityDesignService.rejectBatch(subComActivityDesignDto);
        }
    }
}

