package com.biz.crm.tpm.business.activity.plan.table.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 14:11
 * @description：活动形式套表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动形式套表")
public class ActivityPlanTableDto extends TenantFlagOpDto {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    private String activityPlanTableCode;

    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearAndMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    private String orgName;
    /**
     * 审批状态
     */
    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String processStatus;

    @ApiModelProperty(name = "审批流程编码", notes = "审批流程编码")
    private String processNo;
}
