package com.biz.crm.tpm.business.activity.plan.table.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/7 15:00
 * @description：固定支出
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("固定支出")
public class FinalFixedExpenseDto extends TenantFlagOpDto {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    private String yearMonthLy;
    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    private String orgName;

    /**
     * 类型[数据字典:tpm_budget_amount_type]
     */
    @ApiModelProperty(value = "类型[数据字典:tpm_budget_amount_type]", notes = "")
    private String typeCode;
    private String typeName;
    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码", notes = "")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称", notes = "")
    private String departmentName;
    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    private BigDecimal amount;

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    /**
     * 所属销售机构名称
     */
    @ApiModelProperty("所属销售机构名称")
    private String salesInstitutionName;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

}
