package com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration;

import com.biz.crm.tpm.business.activity.plan.table.sdk.excel.*;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Description: sheet页签枚举
 * @Author: dengwei
 * @Date: 2023/1/29 11:06
 * @Version: 1.0
 */
@Getter
@AllArgsConstructor
public enum SheetNameEnum {

    ACTIVITY_PLAN_PROFIT(0,"利润测算",null),
    PUT_OUTPUT_RATIO(1,"投入产出比", "Input_output_list"),
    SALE_FORECAST(2,"销售预测", "sale_prediction_list"),
    COST_COLLECT(3,"费用汇总", "fee_summary_list"),
    REFERENDUM_COST(4,"公投费用", "fee_referendum_list"),
    FINAL_FIXED_EXPENSE(5,"固定支出", "fix_pay_list"),
    PRICE(6,"价格","price_list"),
    SKIP(999, "跳过审批版数据查询", null);
    private int code;

    private String value;

    private String functionCode;

    public static String getName(int code){
        for (SheetNameEnum value : SheetNameEnum.values()) {
            if(value.getCode() == code){
                return value.getValue();
            }
        }
        return "";
    }

    public static String getFunctionCode(int code){
        for (SheetNameEnum value : SheetNameEnum.values()) {
            if(value.getCode() == code){
                return value.getFunctionCode();
            }
        }
        return "";
    }

}
