package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 费用汇总
 * @Author: dengwei
 * @Date: 2023/1/29 11:26
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class CostCollectData {
    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    @ExcelProperty("活动规划编码")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    @ExcelProperty("活动规划名称")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    @ExcelProperty("活动规划明细编码")
    private String activityDesignDetailCode;

    @ApiModelProperty("活动类型编码")
    @ExcelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @ExcelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    @ExcelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    @ExcelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("核销方式")
    @ExcelProperty("核销方式")
    private String auditType;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty("活动开始时间")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty("活动结束时间")
    private Date activityEndTime;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ExcelProperty("年月")
    private Date feeYearMonth;

    @ApiModelProperty("客户编码")
    @ExcelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @ExcelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("品牌编码")
    @ExcelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    @ExcelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("品类编码")
    @ExcelProperty("品类编码")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    @ExcelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品项编码")
    @ExcelProperty("品项编码")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    @ExcelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @ExcelProperty("产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @ExcelProperty("产品名称")
    private String productName;

    @ApiModelProperty("费用合计")
    @ExcelProperty("费用合计")
    private BigDecimal totalCost;

    @ApiModelProperty(value = "点外金额")
    @ExcelProperty("点外金额")
    private BigDecimal offAmount;

    @ApiModelProperty(value = "点内金额")
    @ExcelProperty("点内金额")
    private BigDecimal internalAmount;

    @ApiModelProperty(value = "自投金额")
    @ExcelProperty("自投金额")
    private BigDecimal autoAmount;

    @ApiModelProperty("核销条件")
    @ExcelProperty("核销条件")
    private String auditCondition;

    @ApiModelProperty("价格影响")
    @ExcelProperty("价格影响")
    private BigDecimal priceEffect;
}
