package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @Description: 固定支出
 * @Author: dengwei
 * @Date: 2023/1/29 11:37
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class FinalFixedExpenseData {
    /**
     * 年月
     */
    @ApiModelProperty(value = "年月", notes = "")
    @ExcelProperty("年月")
    private String yearMonthLy;
    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码", notes = "")
    @ExcelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "组织名称", notes = "")
    @ExcelProperty("组织名称")
    private String orgName;
    /**
     * 部门编码
     */
    @ApiModelProperty(value = "部门编码", notes = "")
    @ExcelProperty("部门编码")
    private String departmentCode;

    /**
     * 部门名称
     */
    @ApiModelProperty(value = "部门名称", notes = "")
    @ExcelProperty("部门名称")
    private String departmentName;
    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @ExcelProperty("预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @ExcelProperty("预算项目名称")
    private String budgetItemName;

    /**
     * 预算金额
     */
    @ApiModelProperty(value = "预算金额", notes = "")
    @ExcelProperty("预算金额")
    private BigDecimal amount;
}
