package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 价格
 * @Author: dengwei
 * @Date: 2023/1/29 11:40
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class PriceData {
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ExcelProperty("年月")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @ExcelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @ExcelProperty("组织名称")
    private String orgName;
    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    @ExcelProperty("活动规划编码")
    private String activityDesignCode;
    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    @ExcelProperty("活动规划名称")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    @ExcelProperty("活动规划明细编码")
    private String activityDesignDetailCode;
    @ApiModelProperty("分销渠道")
    @ExcelProperty("分销渠道")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    @ExcelProperty("分销渠道编码")
    private String distributionChannelCode;
    @ApiModelProperty("客户编码")
    @ExcelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @ExcelProperty("客户名称")
    private String customerName;

    @ApiModelProperty(name = "分摊产品编码", notes = "分摊产品编码")
    @ExcelProperty("分摊产品编码")
    private String apportionProductCode;

    @ApiModelProperty(name = "分摊产品名称", notes = "分摊产品名称")
    @ExcelProperty("分摊产品名称")
    private String apportionProductName;
    @ApiModelProperty("促销量（件）")
    @ExcelProperty("促销量（件）")
    private BigDecimal promoteSales;
    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    @ExcelProperty("标准供货价")
    private BigDecimal standardSupplyPrice;

    @ApiModelProperty("活动后单价")
    @ExcelProperty("活动后单价")
    private BigDecimal activityAfterUnitPrice;

    @ApiModelProperty("使用优惠明细")
    @ExcelProperty("使用优惠明细")
    private String useDiscountsDetail;

    @ApiModelProperty("活动费用")
    @ExcelProperty("活动费用")
    private BigDecimal activityCost;

    @ApiModelProperty("点内费用")
    @ExcelProperty("点内费用")
    private BigDecimal internalAmount;

    @ApiModelProperty("点外费用")
    @ExcelProperty("点外费用")
    private BigDecimal offAmount;

    @ApiModelProperty("自投费用")
    @ExcelProperty("自投费用")
    private BigDecimal autoAmount;

    @ApiModelProperty("期间促销额（元）")
    @ExcelProperty("期间促销额（元）")
    private BigDecimal promotionAmount;

    @ApiModelProperty("供货红线价")
    @ExcelProperty("供货红线价")
    private BigDecimal supplyMaterialRedLinePrice;

    @ApiModelProperty("是否低于红线价")
    @ExcelProperty("是否低于红线价")
    private Boolean isUnderRedLinePrice;
}
