package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 投入产出比
 * @Author: dengwei
 * @Date: 2023/1/29 11:17
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class PutOutputRatioData {
    @ApiModelProperty("年月")
    @ExcelProperty("年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @ExcelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @ExcelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("部门编码")
    @ExcelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    @ExcelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("客户编码")
    @ExcelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @ExcelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("活动类型编码")
    @ExcelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    @ExcelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("费用总额")
    @ExcelProperty("费用总额")
    private BigDecimal totalCost;

    @ApiModelProperty("点外费用")
    @ExcelProperty("点外费用")
    private BigDecimal offAmount;

    @ApiModelProperty("点内费用")
    @ExcelProperty("点内费用")
    private BigDecimal internalAmount;

    @ApiModelProperty("自投费用")
    @ExcelProperty("自投费用")
    private BigDecimal autoAmount;

    @ApiModelProperty("折前收入")
    @ExcelProperty("折前收入")
    private BigDecimal beforeDiscountIncome;

    @ApiModelProperty("折后收入")
    @ExcelProperty("折后收入")
    private BigDecimal afterDiscountIncome;

    @ApiModelProperty("投入产出比")
    @ExcelProperty("投入产出比")
    private String inputOutPutRatioStr;
}
