package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @Description: 公投费用
 * @Author: dengwei
 * @Date: 2023/1/29 11:35
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class ReferendumCostData {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    @ExcelProperty("年月")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    @ExcelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    @ExcelProperty("销售组织名称")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    @ExcelProperty("预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    @ExcelProperty("预算项目名称")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "费用来源[数据字典:tpm_fee_source]")
    @ExcelProperty("费用来源")
    private String feeSourceCode;


    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额")
    @ExcelProperty("预算金额")
    private BigDecimal budgetAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    @ExcelProperty("核准金额")
    private BigDecimal approvedAmount;

    @ApiModelProperty("已规划金额")
    @ExcelProperty("已规划金额")
    private BigDecimal usedAmount;
}
