package com.biz.crm.tpm.business.activity.plan.table.sdk.excel;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Description: 销售预测
 * @Author: dengwei
 * @Date: 2023/1/29 11:21
 * @Version: 1.0
 */
@Getter
@Setter
@EqualsAndHashCode
public class SaleForecastData {
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @ExcelProperty("年月")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    @ExcelProperty("组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    @ExcelProperty("组织名称")
    private String orgName;

    @ApiModelProperty("部门编码")
    @ExcelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    @ExcelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("所属销售组编码")
    @ExcelProperty("所属销售组编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组编码")
    @ExcelProperty("所属销售组编码")
    private String salesOrgName;

    @ApiModelProperty("系统/客户")
    @ExcelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    @ExcelProperty("客户名称")
    private String customerName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    @ExcelProperty("产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    @ExcelProperty("产品名称")
    private String productName;

    @ApiModelProperty("折前到岸价")
    @ExcelProperty("折前到岸价")
    private BigDecimal beforeDiscountCostAndFreight;

    @ApiModelProperty("折前供货价	")
    @ExcelProperty("折前供货价")
    private BigDecimal beforeDiscountProvideGoodsPrice;

    @ApiModelProperty("全月出库件数")
    @ExcelProperty("全月出库件数")
    private BigDecimal monthOutStockQuantity;

    @ApiModelProperty("折前销售收入")
    @ExcelProperty("折前销售收入")
    private BigDecimal beforeDiscountSaleIncome;

    @ApiModelProperty("折前销售成本")
    @ExcelProperty("折前销售成本")
    private BigDecimal beforeDiscountSaleCost;

    @ApiModelProperty("理论毛利")
    @ExcelProperty("理论毛利")
    private BigDecimal theoryProfit;

    @ApiModelProperty("理论毛利率")
    @ExcelProperty("理论毛利率")
    private BigDecimal theoryGrossMarginRate;

    @ApiModelProperty("折后销量")
    @ExcelProperty("折后销量")
    private BigDecimal afterDiscountSaleQuantity;
}
