package com.biz.crm.tpm.business.activity.plan.table.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableBatchSubmitApprovalDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.ActivityPlanTableDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.dto.FinalFixedExpenseDto;
import com.biz.crm.tpm.business.activity.plan.table.sdk.enumeration.SheetNameEnum;
import com.biz.crm.tpm.business.activity.plan.table.sdk.vo.*;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.dto.SelectActivityPlanTableEventDto;
import org.springframework.data.domain.Pageable;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 14:07
 * @description：活动计划套表
 */
public interface ActivityPlanTableService {
    /**
     * 分页查询活动套表
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ActivityPlanTableVo> findByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 查询明细
     *
     * @param id
     * @return
     */
    ActivityPlanTableVo getById(String id, SheetNameEnum sheetNameEnum);

    /**
     * 创建
     *
     * @param dto
     */
    void save(ActivityPlanTableDto dto);

    /**
     * 分页查询
     *
     * @param dto
     * @return
     */
    List<ActivityPlanTableVo> listByCondition(ActivityPlanTableDto dto);

    /**
     * 批量提交工作流
     *
     * @param ids
     */
    List<String> batchSubmitApproval(ActivityPlanTableBatchSubmitApprovalDto ids);

    /**
     * 批量生成数据
     *
     * @param id
     * @author huojia
     * @date 2023/2/21 15:18
     **/
    void generateData(String id);

    /**
     * 下载excel
     *
     * @param id
     * @param response
     * @return
     */
    ActivityPlanTableVo download(String id, HttpServletResponse response) throws IOException;

    /**
     * 分页查询投入产出比
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<PutOutputRatioVo> findPutOutputRatioByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询投入产出比（客户）
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<PutOutputRatioCustomerVo> findPutOutputRatioCustomerByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询销售预测
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<SaleForecastVo> findSaleForecastByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询费用汇总
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<CostCollectVo> findCostCollectByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询公投费用
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<ReferendumCostVo> findReferendumCostByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询固定支出
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 分页查询价格
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<PriceVo> findPriceByConditions(Pageable pageable, ActivityPlanTableDto dto);

    /**
     * 更新状态
     *
     * @author huojia
     * @date 2023/2/21 17:14
     * @param tableId
     **/
    void updateGenerateStatus(String tableId);

    void saveSubmitBatchByMq(List<String> processNoList);

    void saveSubmitTimeData(String processNo);

    /**
     * 据 年月+组织编码+版本查询套表
     * @param dto
     * @return
     */
    ActivityPlanTableVo selectTableByYearMonthAndOrg(SelectActivityPlanTableEventDto dto);

    /**
     *
     *
     * @param yearAndMonth
     * @param orgCode
     */
    BigDecimal getAutoAmount(String yearAndMonth, String orgCode);

    /**
     * 固定支出监控表
     * @param pageable
     * @param dto2
     * @return
     */
    Page<FinalFixedExpenseVo> findFinalFixedExpenseByConditionsForReport(Pageable pageable, FinalFixedExpenseDto dto2);
}
