package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.vo.FixedExpenseVo;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SpecialCostVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 15:51
 * @description：利润计算
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityPlanProfitVo", description = "利润计算")
public class ActivityPlanProfitVo extends TenantFlagOpVo {

    @ApiModelProperty("是否合计")
    private Boolean isTotal;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    private String customerChannelName;

    @ApiModelProperty("出库件数")
    private BigDecimal outStorageQuantity;

    @ApiModelProperty("折前收入")
    private BigDecimal beforeDiscountIncome;

    @ApiModelProperty("折前成本")
    private BigDecimal beforeDiscountCost;

    @ApiModelProperty("折后收入")
    private BigDecimal afterDiscountIncome;

    @ApiModelProperty("销量占比")
    private BigDecimal saleQuantityRatio;

    @ApiModelProperty("理论毛利额")
    private BigDecimal theoryGrossMarginAmount;

    @ApiModelProperty("理论毛利率")
    private BigDecimal theoryGrossMarginRate;

    @ApiModelProperty("税金及附加")
    private BigDecimal taxAndAddition;

    @ApiModelProperty("专项费用")
    private List<SpecialCostVo> specialCostList;

    @ApiModelProperty("固定支出")
    private List<FixedExpenseVo> fixedExpenseList;

    @ApiModelProperty("点内费用")
    private BigDecimal pointInCost;

    @ApiModelProperty("点外费用")
    private BigDecimal pointOutCost;

    @ApiModelProperty("点数内费率")
    private BigDecimal pointInCostRatio;

    @ApiModelProperty("点数外费率")
    private BigDecimal pointOutCostRatio;

    @ApiModelProperty("总部考核")
    private BigDecimal headquartersAssess;

    @ApiModelProperty("总部支出小计")
    private BigDecimal headquartersExpenseTotal;

    @ApiModelProperty("利润额")
    private BigDecimal profitAmount;

    @ApiModelProperty("产品促销费用率")
    private BigDecimal productPromotionCost;

    @ApiModelProperty("其它费用率")
    private BigDecimal otherCostRatio;

    @ApiModelProperty("专项费用率")
    private BigDecimal specialCostRate;

    @ApiModelProperty("固定支出费用率")
    private BigDecimal pointInExpendCostRate;

    @ApiModelProperty("整体费用率")
    private BigDecimal allCostRate;

//    @ApiModelProperty("固定费用率")
//    private BigDecimal pointInCostRate;
//
//    @ApiModelProperty("后台费用率")
//    private BigDecimal backgroundCostRate;


    @ApiModelProperty("用于计算产品促销费用率，分子")
    private BigDecimal productPromotionCostNumerator;

    @ApiModelProperty("用于计算固定费用率，分子")
    private BigDecimal pointInCostRateNumerator;

}
