package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/5 14:11
 * @description：活动形式套表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityPlanTableVo", description = "活动形式套表")
public class ActivityPlanTableVo extends TenantFlagOpVo {

    /**
     * 活动规划套表编码
     */
    @ApiModelProperty("活动规划套表编码")
    private String activityPlanTableCode;


    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearAndMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    private String orgName;

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "审批状态", notes = "审批状态")
    private String processStatus;

    @ApiModelProperty(name = "审批流程编码", notes = "审批流程编码")
    private String processNo;

    @ApiModelProperty("利润计算")
    private List<ActivityPlanProfitVo> activityPlanProfitList;

    @ApiModelProperty("投入产出比")
    private List<PutOutputRatioVo> putOutputRatioList;

    @ApiModelProperty("投入产出比客户")
    private List<PutOutputRatioCustomerVo> putOutputRatioCustomerList;

    @ApiModelProperty("销售预测")
    private List<SaleForecastVo> saleForecastList;

    @ApiModelProperty("费用汇总")
    private List<CostCollectVo> costCollectList;

    @ApiModelProperty("公投费用")
    private List<ReferendumCostVo> referendumCostList;

    @ApiModelProperty("固定支出")
    private List<FinalFixedExpenseVo> fixedExpenseList;

    @ApiModelProperty("价格")
    private List<PriceVo> priceList;

    @ApiModelProperty(value = "", notes = "活动规划套表版本[activity_plan_table_version]")
    private String tableVersion;
}
