package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.tpm.business.subsidiary.activity.design.sdk.vo.SubComActivityDesignDetailVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/7 14:09
 * @description：费用汇总
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "CostCollectVo", description = "费用汇总")
public class CostCollectVo extends SubComActivityDesignDetailVo {

    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    private String activityDesignCode;

    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    private String activityDesignDetailCode;

    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式编码", notes = "活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("核销方式")
    private String auditType;

    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityBeginTime;

    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date activityEndTime;

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("品牌编码")
    private String productBrandCode;

    @ApiModelProperty("品牌名称")
    private String productBrandName;

    @ApiModelProperty("品类编码")
    private String productCategoryCode;

    @ApiModelProperty("品类名称")
    private String productCategoryName;

    @ApiModelProperty("品项编码")
    private String productItemCode;

    @ApiModelProperty("品项名称")
    private String productItemName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty("费用合计")
    private BigDecimal totalCost;

    /*@ApiModelProperty("总部支持金额")
    private BigDecimal headquartersSupportedAmount;

    @ApiModelProperty("公司自投金额")
    private BigDecimal subComAutoAmount;*/

    @ApiModelProperty(value = "点外金额", notes = "")
    private BigDecimal offAmount;

    @ApiModelProperty(value = "点内金额", notes = "")
    private BigDecimal internalAmount;

    @ApiModelProperty(value = "自投金额", notes = "")
    private BigDecimal autoAmount;

    /**
     * 费销比 = 费用合计/期间促销额
     */
    @ApiModelProperty(value = "费销比", notes = "")
    private BigDecimal costSaleRate;

    @ApiModelProperty("核销条件")
    private String auditCondition;

    @ApiModelProperty("价格影响")
    @ExcelProperty("价格影响")
    private BigDecimal priceEffect;

    @ApiModelProperty("保质期")
    private Integer productExpirationDate;

    @ApiModelProperty("大日期剩余天数")
    private Integer bigDateRemainDay;


    @CrmExcelColumn("点内费用预算项目编码")
    private String inPointBudgetItemCode;
    @CrmExcelColumn("点内费用")
    private BigDecimal internalPointFee;
    @CrmExcelColumn("点外费用预算项目编码")
    private String offPointBudgetItemCode;
    @CrmExcelColumn("点外费用")
    private BigDecimal offPointFee;
    @CrmExcelColumn("自投费用预算项目编码")
    private String autoBudgetItemCode;
    @CrmExcelColumn("自投费用")
    private BigDecimal autoFee;

}
