package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/7 15:35
 * @description：价格
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PriceVo", description = "价格")
public class PriceVo extends TenantFlagOpVo {

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    private String orgName;
    /**
     * 活动规划编码
     */
    @ApiModelProperty(name = "活动规划编码", notes = "")
    private String activityDesignCode;
    /**
     * 活动规划名称
     */
    @ApiModelProperty(name = "活动规划名称", notes = "")
    private String activityDesignName;

    /**
     * 活动规划明细编码
     */
    @ApiModelProperty(name = "活动规划明细编码", notes = "")
    private String activityDesignDetailCode;
    @ApiModelProperty("分销渠道")
    private String distributionChannelName;

    @ApiModelProperty("分销渠道编码")
    private String distributionChannelCode;
    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("产品日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date productDate;

    @ApiModelProperty("是否大日期")
    private String isBigDate;
    /**
     * 到岸价
     */
    @ApiModelProperty(value = "到岸价", notes = "")
    private BigDecimal cifPrice;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty(name = "分摊产品编码", notes = "分摊产品编码")
    private String apportionProductCode;

    @ApiModelProperty(name = "分摊产品名称", notes = "分摊产品名称")
    private String apportionProductName;
    @ApiModelProperty("促销量（件）")
    private BigDecimal promoteSales;
    /**
     * 标准供货价
     */
    @ApiModelProperty(value = "标准供货价", notes = "")
    private BigDecimal standardSupplyPrice;

    @ApiModelProperty("活动价（元）")
    private BigDecimal activityPrice;

    @ApiModelProperty("活动后单价")
    private BigDecimal activityAfterUnitPrice;

    @ApiModelProperty("活动最低价")
    private BigDecimal activityLowestPrice;

    @ApiModelProperty("使用优惠明细")
    private String useDiscountsDetail;

    @ApiModelProperty("活动费用")
    private BigDecimal activityCost;

    @ApiModelProperty("点内费用")
    private BigDecimal internalAmount;

    @ApiModelProperty("点外费用")
    private BigDecimal offAmount;

    @ApiModelProperty("自投费用")
    private BigDecimal autoAmount;

    @ApiModelProperty("期间促销额（元）")
    private BigDecimal promotionAmount;

    @ApiModelProperty("供货红线价")
    private BigDecimal supplyMaterialRedLinePrice;

    @ApiModelProperty("是否低于红线价")
    private String isUnderRedLinePrice;

    @ApiModelProperty("原零售价")
    private BigDecimal originalRetailPrice;

    @ApiModelProperty("活动零售价")
    private BigDecimal activityRetailPrice;

    @ApiModelProperty("还原后价格")
    private BigDecimal restoredPrice;

    @ApiModelProperty("平均价格影响")
    private BigDecimal avgPriceEffect;

    /**
     * 理论毛利：（标准供货价-到岸价）/标准供货价；
     */
    @ApiModelProperty("理论毛利")
    private BigDecimal theoryGrossProfit;

    /**
     * 毛利：（还原后价格-活动单价）/还原后价格；
     */
    @ApiModelProperty("毛利（元）")
    private BigDecimal grossProfit;

    /**
     * 前台毛利：（活动零售价-还原后价格）/活动零售价；
     */
    @ApiModelProperty("前台毛利（元）")
    private BigDecimal frontGrossProfit;

}
