package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/6 18:03
 * @description：投入产出比
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "PutOutputRatioVo", description = "投入产出比")
public class PutOutputRatioVo extends TenantFlagOpVo {

    @ApiModelProperty("年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    private String orgName;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty("费用总额")
    private BigDecimal totalCost;

    @ApiModelProperty("点外费用")
    private BigDecimal offAmount;

    @ApiModelProperty("点内费用")
    private BigDecimal internalAmount;

    @ApiModelProperty("自投费用")
    private BigDecimal autoAmount;

    @ApiModelProperty("折前收入")
    private BigDecimal beforeDiscountIncome;

    @ApiModelProperty("折后收入")
    private BigDecimal afterDiscountIncome;

    @ApiModelProperty("投入产出比")
    private BigDecimal inputOutputRatio;

    @ApiModelProperty("投入产出比百分数")
    private String inputOutPutRatioStr;

    /**
     * 折前投产比 费用总额/折前收入
     */
    @ApiModelProperty("折前投产比")
    private BigDecimal beforeInputOutputRatio;

    /**
     * 折后投产比 费用总额/折后收入
     */
    @ApiModelProperty("折后投产比")
    private BigDecimal afterInputOutputRatio;
}
