package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.SalesApprovalVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/7 14:34
 * @description：公投费用
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ReferendumCostVo", description = "公投费用")
public class ReferendumCostVo extends SalesApprovalVo {

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "费用来源[数据字典:tpm_fee_source]")
    private String feeSourceCode;


    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额")
    private BigDecimal budgetAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    private BigDecimal approvedAmount;

    @ApiModelProperty("已规划金额")
    private BigDecimal usedAmount;
}
