package com.biz.crm.tpm.business.activity.plan.table.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author ：dengwei
 * @date ：Created in 2022/12/7 10:21
 * @description：销售预测
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "SaleForecastVo", description = "销售预测")
public class SaleForecastVo extends TenantFlagOpVo {

    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date feeYearMonth;

    /**
     * 组织编码
     */
    @ApiModelProperty(name = "组织编码", notes = "")
    private String orgCode;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "组织名称", notes = "")
    private String orgName;

    @ApiModelProperty("部门编码")
    private String departmentCode;

    @ApiModelProperty("部门名称")
    private String departmentName;

    @ApiModelProperty("所属销售组编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组编码")
    private String salesOrgName;

    @ApiModelProperty("系统/客户")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码", notes = "")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称", notes = "")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码", notes = "")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称", notes = "")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码", notes = "")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称", notes = "")
    private String productItemName;

    @ApiModelProperty(name = "产品编码", notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "产品名称", notes = "产品名称")
    private String productName;

    @ApiModelProperty("折前到岸价")
    private BigDecimal beforeDiscountCostAndFreight;

    @ApiModelProperty("折前供货价	")
    private BigDecimal beforeDiscountProvideGoodsPrice;

    @ApiModelProperty("全月出库件数")
    private BigDecimal monthOutStockQuantity;

    @ApiModelProperty("折前销售收入")
    private BigDecimal beforeDiscountSaleIncome;

    @ApiModelProperty("折前销售成本")
    private BigDecimal beforeDiscountSaleCost;

    @ApiModelProperty("理论毛利")
    private BigDecimal theoryProfit;

    @ApiModelProperty("理论毛利率")
    private BigDecimal theoryGrossMarginRate;

    @ApiModelProperty("折后销量")
    private BigDecimal afterDiscountSaleQuantity;

    /**
     * 新增折后成本列，
     * 取值逻辑：销售计划中
     * 根据年月+组织+客户+产品取“折后成本”后展示
     */
    @ApiModelProperty("折后成本")
    private BigDecimal afterDiscountCost;

}
