package com.biz.crm.tpm.business.activities.profit.monitoring.sdk.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import java.math.BigDecimal;
import java.util.Date;

/**
 * (DimensionBudget)利润监控（分子公司）实体类
 *
 * @author makejava
 * @since 2022-11-05 12:00:01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ProfitMonitoringVo", description = "利润监控（分子公司）")
public class ProfitMonitoringVo extends TenantFlagOpVo {
    /**
     * 利润率偏差
     */
    @ApiModelProperty(name = "profitDeviationRate", value = "利润率偏差", notes = "利润率偏差")
    private BigDecimal profitDeviationRate;


    /**
     * 预算理论利润率
     */
    @ApiModelProperty(name = "budgetTheoryProfitRate", value = "预算理论利润率", notes = "预算理论利润率")
    private BigDecimal budgetTheoryProfitRate;


    /**
     * 预算理论利润
     */
    @ApiModelProperty(name = "budgetTheoryProfit", value = "预算理论利润", notes = "预算理论利润")
    private BigDecimal budgetTheoryProfit;

    /**
     * 理论考核扣款
     */
    @ApiModelProperty(name = "budgetAssessDeduction", value = "理论考核扣款", notes = "理论考核扣款")
    private BigDecimal budgetAssessDeduction;


    /**
     * 预算理论公投
     */
    @ApiModelProperty(name = "budgetTheoryReferendum", value = "预算理论公投", notes = "预算理论公投")
    private BigDecimal budgetTheoryReferendum;


    /**
     * 预算理论固定支出
     */
    @ApiModelProperty(name = "budgetTheoryFixedFee", value = "预算理论固定支出", notes = "预算理论固定支出")
    private BigDecimal budgetTheoryFixedFee;

    /**
     * 预算理论向下投入
     */
    @ApiModelProperty(name = "budgetTheoryDownInput", value = "预算理论向下投入", notes = "预算理论向下投入")
    private BigDecimal budgetTheoryDownInput;


    /**
     * 预算理论税金及附加
     */
    @ApiModelProperty(name = "budgetTheoryTaxAmount", value = "预算理论税金及附加", notes = "预算理论税金及附加")
    private BigDecimal budgetTheoryTaxAmount;


    /**
     * 预算理论收入
     */
    @ApiModelProperty(name = "actualTheoryProfitIncome", value = "预算理论收入", notes = "预算理论收入")
    private BigDecimal actualTheoryProfitIncome;

    /**
     * 实际理论利润率
     */
    @ApiModelProperty(name = "actualTheoryProfitRate", value = "实际理论利润率", notes = "实际理论利润率")
    private BigDecimal actualTheoryProfitRate;

    /**
     * 实际理论利润
     */
    @ApiModelProperty(name = "actualTheoryProfit", value = "实际理论利润", notes = "实际理论利润")
    private BigDecimal actualTheoryProfit;


    /**
     * 考核扣款
     */
    @ApiModelProperty(name = "assessDeduction", value = "考核扣款", notes = "考核扣款")
    private BigDecimal assessDeduction;

    /**
     * 公投费用
     */
    @ApiModelProperty(name = "referendumFee", value = "公投费用", notes = "公投费用")
    private BigDecimal referendumFee;


    /**
     * 固定支出
     */
    @ApiModelProperty(name = "fixedPay", value = "固定支出", notes = "固定支出")
    private BigDecimal fixedPay;

    /**
     * 专项费用投入
     */
    @ApiModelProperty(name = "specialCostInput", value = "专项费用投入", notes = "专项费用投入")
    private BigDecimal specialCostInput;

    /**
     * 实际理论税金及附加
     */
    @ApiModelProperty(name = "actualTheoryTaxAmount", value = "实际理论税金及附加", notes = "实际理论税金及附加")
    private BigDecimal ruactualTheoryTaxAmount;


    /**
     * 实际理论毛利
     */
    @ApiModelProperty(name = "actualTheoryGrossProfit", value = "实际理论毛利", notes = "实际理论毛利")
    private BigDecimal actualTheoryGrossProfit;

    /**
     * 实际理论成本
     */
    @ApiModelProperty(name = "actualTheoryPrice", value = "实际理论成本", notes = "实际理论成本")
    private BigDecimal actualTheoryPrice;

    /**
     * 实际理论收入
     */
    @ApiModelProperty(name = "actualTheoryIncome", value = "实际理论收入", notes = "实际理论收入")
    private BigDecimal actualTheoryIncome;


    /**
     * 组织名称
     */
    @ApiModelProperty("组织名称")
    private String orgName;

    /**
     * 组织编码
     */
    @ApiModelProperty("组织编码")
    private String orgCode;

    /**
     * 业态
     */
    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    /**
     * 业务单元
     */
    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    /**
     * 费用所属年月
     */
    @ApiModelProperty(name = "activityStartTime", value = "费用所属年月")
    @Column(name = "fee_year_month_time", columnDefinition = "datetime COMMENT '费用所属年月'")
    @JsonFormat(pattern = "yyyy-MM")
    private Date feeYearMonthTime;


    /**
     * 更新时间
     */
    @ApiModelProperty(name = "更新时间", notes = "更新时间")
    @Column(name = "update_time", columnDefinition = "datetime COMMENT '更新时间'")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


}
