package com.biz.crm.tpm.business.audit.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.feign.feign.internal.AuditFeignImpl;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @ClassName AuditFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = AuditFeignImpl.class)
public interface AuditFeign {

    @PostMapping("/v1/audit/autoAudit")
    Result<?> create(@RequestBody AutoAuditDto dto);

    @GetMapping("/v1/audit/{auditCode}")
    Result<AuditVo> findByCode(@PathVariable @ApiParam(name = "auditCode", value = "核销编码") String auditCode);

    @PostMapping("/v1/audit/atomicAudit")
    Result<AutoAuditDto> atomicCreate(@RequestBody AutoAuditDto dto);

    @GetMapping("/v1/audit/findDetailByConditions")
    Result<Page<AuditCustomerDetailCollectionVo>> findDetailByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                         @ApiParam(name = "activityForm", value = "活动形式") @SpringQueryMap AuditFindDetailDto dto);

    @PostMapping("/v1/audit/findAuditVoListByCondition")
    Result<List<AuditTotalReimburseTaxAmountVo>> findAuditVoListByCondition(@RequestBody AuditQueryDto dto);

    @GetMapping("/v1/audit/findPageForOut")
    Result<Page<AuditVo>> findPageForOut(@ApiParam(name = "pageable") Pageable pageable,
                                         @ApiParam(name = "dto") @SpringQueryMap AuditDto dto);
}
