package com.biz.crm.tpm.business.audit.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.feign.feign.AuditFeign;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditOutDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName AuditFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Component
@Slf4j
public class AuditFeignImpl implements FallbackFactory<AuditFeign> {
    @Override
    public AuditFeign create(Throwable cause) {
        log.error("结案核销进入熔断");
        return new AuditFeign(){

            @Override
            public Result<?> create(AutoAuditDto dto) {
                throw new UnsupportedOperationException("创建结案核销熔断");
            }

            @Override
            public Result<AuditVo> findByCode(String auditCode) {
                throw new UnsupportedOperationException("查询结案核销详情熔断");
            }

            @Override
            public Result<AutoAuditDto> atomicCreate(AutoAuditDto dto) {
                throw new UnsupportedOperationException("创建结案核销熔断");
            }

            @Override
            public Result<Page<AuditCustomerDetailCollectionVo>> findDetailByConditions(Pageable pageable, AuditFindDetailDto dto) {
                throw new UnsupportedOperationException("查询结案核销明细信息熔断");
            }

            @Override
            public Result<List<AuditTotalReimburseTaxAmountVo>> findAuditVoListByCondition(AuditQueryDto dto) {
                throw new UnsupportedOperationException("牛e财通查询核销信息熔断");
            }

            @Override
            public Result<Page<AuditVo>> findPageForOut(Pageable pageable, AuditDto dto) {
                throw new UnsupportedOperationException("查询结案核销列表信息熔断");
            }
        };
    }
}
