package com.biz.crm.tpm.business.audit.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.third.system.sd.sdk.dto.AuditCostPostingCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SapRedInvoiceSaleOrderCreateCallbackDto;
import com.biz.crm.mn.third.system.sd.sdk.dto.SonAuditCostPostingCallbackDto;
import com.biz.crm.tpm.business.audit.feign.feign.AuditFeign;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditFindDetailDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AuditQueryDto;
import com.biz.crm.tpm.business.audit.sdk.dto.AutoAuditDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditSdkService;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditCustomerDetailCollectionVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditTotalReimburseTaxAmountVo;
import com.biz.crm.tpm.business.audit.sdk.vo.AuditVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;
import java.util.UUID;

/**
 * @ClassName AuditSdkServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Service
public class AuditSdkServiceImpl implements AuditSdkService {

    @Autowired(required = false)
    private AuditFeign auditFeign;

    @Override
    public void sdAuditCostPostingHeadCallback(AuditCostPostingCallbackDto dto) {

    }

    @Override
    public void sdAuditCostPostingBranchCallback(SonAuditCostPostingCallbackDto dto) {

    }

    @Override
    public void saleOrderCreateCallback(SapRedInvoiceSaleOrderCreateCallbackDto dto) {

    }

    @Override
    public Object create(AutoAuditDto dto) {
        dto.setCacheKey(UUID.randomUUID().toString().replaceAll("-", ""));
        Result<?> result = auditFeign.create(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("结案核销创建失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public AuditVo findByCode(String code) {
        return auditFeign.findByCode(code).getResult();
    }

    @Override
    public AutoAuditDto atomicCreate(AutoAuditDto dto) {
        dto.setCacheKey(UUID.randomUUID().toString().replaceAll("-", ""));
        Result<AutoAuditDto> result = auditFeign.atomicCreate(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("结案核销创建失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public Page<AuditCustomerDetailCollectionVo> findDetailByConditions(Pageable pageable, AuditFindDetailDto dto) {
        Result<Page<AuditCustomerDetailCollectionVo>> result = auditFeign.findDetailByConditions(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Page<AuditVo> findPageForOut(Pageable pageable, AuditDto dto) {
        Result<Page<AuditVo>> result = auditFeign.findPageForOut(pageable, dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("结案核销列表查询失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public List<AuditTotalReimburseTaxAmountVo> findAuditVoListByCondition(AuditQueryDto dto) {
        Result<List<AuditTotalReimburseTaxAmountVo>> result = auditFeign.findAuditVoListByCondition(dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public List<AuditCustomerDetailCollectionVo> findDetailByActivityDetailCodeList(AuditFindDetailDto dto) {
        return null;
    }

    @Override
    public String findBusinessUnitByProcessNo(String processNo) {
        return null;
    }
}
