package com.biz.crm.tpm.business.audit.formula.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.feign.feign.internal.AuditFormulaFeignImpl;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName AuditFormulaFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = AuditFormulaFeignImpl.class)
public interface AuditFormulaFeign {

    @GetMapping("/v1/auditFormulaMain/{id}")
    Result<AuditFormulaMainVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id);

    @PostMapping("/v1/auditFormulaMain")
    Result<AuditFormulaMainVo> create(@RequestBody AuditFormulaMainDto auditFormulaMain);

    @PostMapping(value = "/v1/auditFormulaMain/updatePos")
    Result<AuditFormulaMainVo> update(@RequestBody AuditFormulaMainDto auditFormulaMain);

    @PostMapping(value = "/v1/auditFormulaMain/delete")
    Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList);
}
