package com.biz.crm.tpm.business.audit.formula.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.feign.feign.AuditFormulaFeign;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName AuditFormulaFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Component
@Slf4j
public class AuditFormulaFeignImpl implements FallbackFactory<AuditFormulaFeign> {
    @Override
    public AuditFormulaFeign create(Throwable cause) {
        log.error("核销规则进入熔断");
        return new AuditFormulaFeign(){

            @Override
            public Result<AuditFormulaMainVo> findById(String id) {
                throw new UnsupportedOperationException("查询核销规则详情熔断");
            }

            @Override
            public Result<AuditFormulaMainVo> create(AuditFormulaMainDto auditFormulaMain) {
                throw new UnsupportedOperationException("创建核销规则熔断");
            }

            @Override
            public Result<AuditFormulaMainVo> update(AuditFormulaMainDto auditFormulaMain) {
                throw new UnsupportedOperationException("更改核销规则熔断");
            }

            @Override
            public Result<?> delete(List<String> idList) {
                throw new UnsupportedOperationException("删除核销规则熔断");
            }
        };
    }
}
