package com.biz.crm.tpm.business.audit.formula.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.feign.feign.AuditFormulaFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @ClassName AuditFormulaMainServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Service
public class AuditFormulaMainServiceImpl implements AuditFormulaMainService {

    @Autowired(required = false)
    private AuditFormulaFeign auditFormulaFeign;

    @Override
    public Page<AuditFormulaMainVo> findByConditions(Pageable pageable, AuditFormulaMainDto auditFormulaMain) {
        return null;
    }

    @Override
    public AuditFormulaMainVo findById(String id) {
        Result<AuditFormulaMainVo> result = auditFormulaFeign.findById(id);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("查询核销规则详情失败：" + result.getMessage());
        } else if (result.getResult() != null && DelFlagStatusEnum.DELETE.getCode().equals(result.getResult().getDelFlag())) {
            throw new UnsupportedOperationException("该核销规则已删除");
        }
        return result.getResult();
    }

    @Override
    public AuditFormulaMainVo create(AuditFormulaMainDto auditFormulaMain) {
        Result<AuditFormulaMainVo> result = auditFormulaFeign.create(auditFormulaMain);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("创建核销规则失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public AuditFormulaMainVo update(AuditFormulaMainDto auditFormulaMain) {
        Result<AuditFormulaMainVo> result = auditFormulaFeign.update(auditFormulaMain);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("创建核销规则失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public void delete(List<String> idList) {
        Result<?> result = auditFormulaFeign.delete(idList);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("核销规则删除失败：" + result.getMessage());
        }
    }

    @Override
    public void enable(List<String> idList) {

    }

    @Override
    public void disable(List<String> idList) {

    }

    @Override
    public List<AuditFormulaMainVo> getList(AuditFormulaMainDto auditFormulaMainDto) {
        return null;
    }

    @Override
    public AuditFormulaMainVo findByCode(String code) {
        return null;
    }

    @Override
    public List<AuditFormulaInfoVo> findFormulaInfoListByCodeList(List<String> codeList) {
        return null;
    }

    @Override
    public List<AuditFormulaMainVo> findByCodeList(List<String> codeList) {
        return null;
    }

    @Override
    public List<AuditFormulaMainVo> findListByDto(AuditFormulaMainDto dto) {
        return null;
    }
}
