package com.biz.crm.tpm.business.audit.formula.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaMain;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 核销公式主表(AuditFormulaMain)表相关的http接口
 *
 * @author makejava
 * @since 2022-11-03 11:49:28
 */
@RestController
@RequestMapping("/v1/auditFormulaMain")
@Slf4j
@Api(tags = "核销公式主表")
public class AuditFormulaMainController {
  /**
  * 服务对象
  */
  @Autowired
  private AuditFormulaMainService auditFormulaMainService;
  
  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param auditFormulaMain 查询实体
   * @return 所有数据
  */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<AuditFormulaMainVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                           @ApiParam(name = "auditFormulaMain", value = "核销公式主表") AuditFormulaMainDto auditFormulaMain) {
    try {
      Page<AuditFormulaMainVo> page =  this.auditFormulaMainService.findByConditions(pageable,auditFormulaMain);
      return Result.ok(page);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
  */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<AuditFormulaMainVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      AuditFormulaMainVo auditFormulaMain = this.auditFormulaMainService.findById(id);
      return Result.ok(auditFormulaMain);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过code查询单条数据
   *
   * @param code 编码
   * @return 单条数据
   */
  @ApiOperation(value = "通过code查询单条数据")
  @GetMapping("findByCode")
  public Result<AuditFormulaMainVo> findByCode(@RequestParam("code") String code) {
    try {
      AuditFormulaMainVo auditFormulaMain = this.auditFormulaMainService.findByCode(code);
      return Result.ok(auditFormulaMain);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 新增数据
   *
   * @param auditFormulaMain 实体对象
   * @return 新增结果
  */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<AuditFormulaMainVo> create(@ApiParam(name = "auditFormulaMain", value = "核销公式主表") @RequestBody AuditFormulaMainDto auditFormulaMain) {
    try {
      return Result.ok(this.auditFormulaMainService.create(auditFormulaMain));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, AuditFormulaMain.class));
    }
  }
  
  /**
   * 修改数据
   *
   * @param auditFormulaMain 实体对象
   * @return 修改结果
  */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<AuditFormulaMainVo> update(@ApiParam(name = "auditFormulaMain", value = "核销公式主表") @RequestBody AuditFormulaMainDto auditFormulaMain) {
    try {
      return Result.ok(this.auditFormulaMainService.update(auditFormulaMain));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(DataTooLongGenerateRespUtil.generateRespStr(e, AuditFormulaMain.class));
    }
  }

  /**
   * 修改数据
   *
   * @param auditFormulaMain 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PostMapping("updatePos")
  public Result<AuditFormulaMainVo> updatePos(@ApiParam(name = "auditFormulaMain", value = "核销公式主表") @RequestBody AuditFormulaMainDto auditFormulaMain) {
    try {
      return Result.ok(this.auditFormulaMainService.update(auditFormulaMain));
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
  
  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @PostMapping("delete")
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.auditFormulaMainService.delete(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("enable")
  public Result<?> enable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.auditFormulaMainService.enable(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @PostMapping("disable")
  public Result<?> disable(@ApiParam(name = "idList", value = "主键集合") @RequestBody List<String> idList) {
    try {
      this.auditFormulaMainService.disable(idList);
      return Result.ok();
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("下拉选择框")
  @PostMapping("getList")
  public Result<List<AuditFormulaMainVo>> getList(@RequestBody AuditFormulaMainDto auditFormulaMainDto){
    try {
      return Result.ok(this.auditFormulaMainService.getList(auditFormulaMainDto));
    }catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过条件查询列表
   *
   * @param auditFormulaMain 查询实体
   * @return 所有数据
   */
  @ApiOperation(value = "通过条件查询列表")
  @GetMapping("findListByDto")
  public Result<List<AuditFormulaMainVo>> findListByDto(@ApiParam(name = "auditFormulaMain", value = "核销公式主表") AuditFormulaMainDto auditFormulaMain) {
    try {
      List<AuditFormulaMainVo> list =  this.auditFormulaMainService.findListByDto(auditFormulaMain);
      return Result.ok(list);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
