package com.biz.crm.tpm.business.audit.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-23
 */
@ApiModel(value = "AuditFormulaChannel", description = "核销公式关联渠道")
@TableName("tpm_audit_formula_channel")
@Getter
@Setter
@Entity(name = "tpm_audit_formula_channel")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_formula_channel", comment = "核销公式关联渠道")
@Table(name = "tpm_audit_formula_channel", indexes = {
        @Index(name = "tpm_audit_formula_channel_index1", columnList = "audit_formula_code")
})
public class AuditFormulaChannel extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    @Column(name = "audit_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销公式编码'")
    private String auditFormulaCode;

    @ApiModelProperty(name = "关联渠道等级", notes = "关联渠道等级")
    @Column(name = "channel_type",  length = 10, columnDefinition = "VARCHAR(10) COMMENT '关联渠道等级'")
    private String channelType;

    @ApiModelProperty(name = "渠道编码", notes = "渠道编码")
    @Column(name = "channel_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '渠道编码'")
    private String channelCode;

    @ApiModelProperty(name = "渠道名称", notes = "渠道名称")
    @Column(name = "channel_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '渠道名称'")
    private String channelName;
}
