package com.biz.crm.tpm.business.audit.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 11:23
 * @description：核销配置公式表
 */
@ApiModel(value = "AuditFormulaInfo", description = "核销配置公式表")
@TableName("tpm_audit_formula_info")
@Getter
@Setter
@Entity(name = "tpm_audit_formula_info")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_formula_info", comment = "核销配置公式表")
@Table(name = "tpm_audit_formula_info", indexes = {
        @Index(name = "tpm_audit_formula_info_index1", columnList = "audit_formula_code")
})
public class AuditFormulaInfo extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    @Column(name = "audit_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销公式编码'")
    private String auditFormulaCode;

    @Column(name = "audit_formula_condition" ,   columnDefinition = "VARCHAR(500) COMMENT '核销公式条件'")
    @ApiModelProperty("核销公式条件")
    private String auditFormulaCondition;

    @Column(name = "audit_formula_condition_name" ,   columnDefinition = "VARCHAR(500) COMMENT '核销公式条件（展示用）'")
    @ApiModelProperty("核销公式条件（展示用）")
    private String auditFormulaConditionName;

    @Column(name = "audit_formula" ,   columnDefinition = "VARCHAR(500) COMMENT '核销公式'")
    @ApiModelProperty("核销公式")
    private String auditFormula;

    @Column(name = "audit_formula_name" ,   columnDefinition = "VARCHAR(500) COMMENT '核销公式（展示用）'")
    @ApiModelProperty("核销公式（展示用）")
    private String auditFormulaName;

    @Column(name = "condition_json" ,   columnDefinition = "VARCHAR(500) COMMENT '前端使用'")
    @ApiModelProperty("前端使用")
    private String conditionJson;

    @Column(name = "compute_json" ,   columnDefinition = "VARCHAR(500) COMMENT '前端使用'")
    @ApiModelProperty("前端使用")
    private String computeJson;
}
