package com.biz.crm.tpm.business.audit.formula.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 10:44
 * @description：核销公式主表
 */
@ApiModel(value = "AuditFormula", description = "核销公式主表")
@TableName("tpm_audit_formula_main")
@Getter
@Setter
@Entity(name = "tpm_audit_formula_main")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_formula_main", comment = "核销公式主表")
@Table(name = "tpm_audit_formula_main", indexes = {
        @Index(name = "tpm_audit_formula_main_index1", columnList = "audit_formula_code", unique = true)
})
public class AuditFormulaMain extends TenantFlagOpEntity {
    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    @Column(name = "audit_formula_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销公式编码'")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    @Column(name = "audit_formula_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '核销公式名称'")
    private String auditFormulaName;

    @ApiModelProperty(name = "核销类型", notes = "核销类型")
    @Column(name = "audit_type",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销类型'")
    private String auditType;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    @Column(name = "activity_type_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动类型'")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @Column(name = "activity_type_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织(多个用逗号分割)")
    @Column(name = "sales_org_codes",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织'")
    private String salesOrgCodes;

    @ApiModelProperty(name = "salesOrgNames", notes = "销售组织名称(多个用逗号分割)")
    @Column(name = "sales_org_names",  length = 218, columnDefinition = "VARCHAR(512) COMMENT '销售组织名称'")
    private String salesOrgNames;

    @ApiModelProperty(name = "customerTypes", notes = "客户类型(多个用逗号分割)")
    @Column(name = "customer_types",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户类型(多个用逗号分割)'")
    private String customerTypes;

    @ApiModelProperty(name = "customerTypeNames", notes = "客户类型名称(多个用逗号分割)")
    @Column(name = "customer_type_names",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户类型名称(多个用逗号分割)'")
    private String customerTypeNames;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
    private String writeOffMethod;

    @ApiModelProperty("陈列批次")
    @Column(name = "display_number", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '陈列批次'")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    @Column(name = "customer_account", nullable = true, length = 10, columnDefinition = "varchar(10) COMMENT '是否客户上账'")
    private String customerAccount;

    @ApiModelProperty(value = "渠道编码")
    @Column(name = "channel", nullable = true, length = 20, columnDefinition = "varchar(20) COMMENT '渠道编码'")
    private String channel;

    @ApiModelProperty(value = "渠道名称")
    @Column(name = "channel_name", nullable = true, length = 100, columnDefinition = "varchar(100) COMMENT '渠道名称'")
    private String channelName;

    @ApiModelProperty(name = "orgCode", value = "组织编码")
    @Column(name = "org_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '组织编码'")
    private String orgCode;


    @ApiModelProperty(name = "orgName", value = "组织名称")
    @Column(name = "org_name", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '组织名称'")
    private String orgName;
}
