package com.biz.crm.tpm.business.audit.formula.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainExportsVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author : dengwei
 * @Date :2023/8/17  22:21
 * @Description: 核销公式导出
 */
@Component
@Slf4j
public class AuditFormulaMainExportsProcess implements ExportProcess<AuditFormulaMainExportsVo> {

    @Autowired(required = false)
    private AuditFormulaMainService auditFormulaMainService;

    @Override
    public Integer getPageSize(){
        return CommonConstant.IE_EXPORT_PAGE_SIZE;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        Pageable pageable = PageRequest.of(1, 1);
        AuditFormulaMainDto dto = convertParams(params);
        Page<AuditFormulaMainVo> pageResult = this.auditFormulaMainService.findByConditions(pageable, dto);
        Validate.isTrue(pageResult.getTotal() < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时，" +
                "单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return Long.valueOf(pageResult.getTotal()).intValue();
    }

    private AuditFormulaMainDto convertParams(Map<String, Object> params) {
        // map 参数转换为对应的dto参数对象，可以手工进行修改设置
        return JSON.parseObject(JSON.toJSONString(params), AuditFormulaMainDto.class);
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        params = this.convertEuropaParam(params);
        log.info("=====>      发票管理明细导出[{}]    <=====", JSON.toJSONString(vo));
        Pageable pageable = PageRequest.of(vo.getPageNo() + 1, getPageSize());
        AuditFormulaMainDto dto = convertParams(params);
        Page<AuditFormulaMainVo> pageResult = this.auditFormulaMainService.findByConditions(pageable, dto);
        if (CollectionUtils.isEmpty(pageResult.getRecords())) {
            return new JSONArray();
        }
        List<AuditFormulaMainVo> records = pageResult.getRecords();
        adjustData(records);
        //TODO 按照配置导出字段过滤
        return JSON.parseArray(JSON.toJSONString(records, SerializerFeature.WriteDateUseDateFormat));
    }

    private void adjustData(List<AuditFormulaMainVo> records) {
    }

    @Override
    public String getBusinessCode() {
        return "audit_formula_main_exports";
    }

    @Override
    public String getBusinessName() {
        return "核销公式导出";
    }
}
