package com.biz.crm.tpm.business.audit.formula.local.regiser;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * 执行资料(AuditInformationDataViewRegister)数据视图注册器
 *
 * @author wanghaojia
 * @since 2022-11-11 10:31:00
 */
@Component
public class AuditFormulaDataViewRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_audit_formula_info_data_view";
    }

    @Override
    public String desc() {
        return "TPM-核销条件配置";
    }

    @Override
    public String buildSql() {
        return "SELECT\n" +
                " t.*  FROM tpm_audit_formula_info t"+
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() +"'";
    }

}
