package com.biz.crm.tpm.business.audit.formula.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaChannelDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.enums.TerminalChannelLevelEnum;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaChannelVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaChannel;
import com.biz.crm.tpm.business.audit.formula.local.mapper.AuditFormulaChannelMapper;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Component
public class AuditFormulaChannelRepository extends ServiceImpl<AuditFormulaChannelMapper, AuditFormulaChannel> {

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void replaceAll(AuditFormulaMainDto auditFormulaMain) {
        this.lambdaUpdate().eq(AuditFormulaChannel::getAuditFormulaCode, auditFormulaMain.getAuditFormulaCode()).remove();
        if (!CollectionUtils.isEmpty(auditFormulaMain.getFirstChannelList())
                || !CollectionUtils.isEmpty(auditFormulaMain.getSecondChannelList())) {
            List<AuditFormulaChannelDto> channelList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty(auditFormulaMain.getFirstChannelList())) {
                List<AuditFormulaChannelDto> firstChannelList = auditFormulaMain.getFirstChannelList();
                firstChannelList.forEach(e -> {
                    e.setId(null);
                    e.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                    e.setChannelType(TerminalChannelLevelEnum.FIRST.getCode());
                    e.setTenantCode(TenantUtils.getTenantCode());
                });
                channelList.addAll(firstChannelList);
            }
            if (!CollectionUtils.isEmpty(auditFormulaMain.getSecondChannelList())) {
                List<AuditFormulaChannelDto> secondChannelList = auditFormulaMain.getSecondChannelList();
                secondChannelList.forEach(e -> {
                    e.setId(null);
                    e.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                    e.setChannelType(TerminalChannelLevelEnum.SECOND.getCode());
                    e.setTenantCode(TenantUtils.getTenantCode());
                });
                channelList.addAll(secondChannelList);
            }
            this.saveBatch(nebulaToolkitService.copyCollectionByWhiteList(channelList, AuditFormulaChannelDto.class, AuditFormulaChannel.class, HashSet.class, ArrayList.class));
        }
    }

    public void loadDetail(AuditFormulaMainVo auditFormulaMainVo) {
        List<AuditFormulaChannel> list = this.lambdaQuery()
                .eq(AuditFormulaChannel::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFormulaChannel::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFormulaChannel::getAuditFormulaCode, auditFormulaMainVo.getAuditFormulaCode())
                .list();
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<AuditFormulaChannelVo> channelList = (List<AuditFormulaChannelVo>) nebulaToolkitService.copyCollectionByWhiteList(list, AuditFormulaChannel.class, AuditFormulaChannelVo.class, HashSet.class, ArrayList.class);
        Map<String, List<AuditFormulaChannelVo>> listMap = channelList.stream().collect(Collectors.groupingBy(AuditFormulaChannelVo::getChannelType));
        List<AuditFormulaChannelVo> firstChannelList = listMap.getOrDefault(TerminalChannelLevelEnum.FIRST.getCode(), Lists.newArrayList());
        firstChannelList.sort(Comparator.comparing(AuditFormulaChannelVo::getChannelCode));
        List<AuditFormulaChannelVo> secondChannelList = listMap.getOrDefault(TerminalChannelLevelEnum.SECOND.getCode(), Lists.newArrayList());
        secondChannelList.sort(Comparator.comparing(AuditFormulaChannelVo::getChannelCode));
        auditFormulaMainVo.setFirstChannelList(firstChannelList);
        auditFormulaMainVo.setSecondChannelList(secondChannelList);
    }
}

