package com.biz.crm.tpm.business.audit.formula.local.repository;



import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaInfo;
import com.biz.crm.tpm.business.audit.formula.local.mapper.AuditFormulaInfoMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;


/**
 * 核销配置公式表(AuditFormulaInfo)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 11:49:28
 */
@Component
public class AuditFormulaInfoRepository extends ServiceImpl<AuditFormulaInfoMapper, AuditFormulaInfo> {

  @Autowired
  private AuditFormulaInfoMapper auditFormulaInfoMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param auditFormulaInfo 实体对象
   * @return
   */
  public Page<AuditFormulaInfo> findByConditions(Pageable pageable, AuditFormulaInfo auditFormulaInfo) {
    Page<AuditFormulaInfo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<AuditFormulaInfo> pageList = this.auditFormulaInfoMapper.findByConditions(page, auditFormulaInfo);
    return pageList;
  }

  public List<AuditFormulaInfo> findByAuditFormulaCodeList(List<String> codeList) {
    return this.lambdaQuery()
            .in(AuditFormulaInfo::getAuditFormulaCode, codeList)
            .eq(AuditFormulaInfo::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFormulaInfo::getTenantCode, TenantUtils.getTenantCode())
            .list();
  }
}

