package com.biz.crm.tpm.business.audit.formula.local.repository;



import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaMain;
import com.biz.crm.tpm.business.audit.formula.local.mapper.AuditFormulaMainMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Optional;


/**
 * 核销公式主表(AuditFormulaMain)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-03 11:49:28
 */
@Component
public class AuditFormulaMainRepository extends ServiceImpl<AuditFormulaMainMapper, AuditFormulaMain> {

  @Autowired
  private AuditFormulaMainMapper auditFormulaMainMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param auditFormulaMain 实体对象
   * @return
   */
  public Page<AuditFormulaMainVo> findByConditions(Pageable pageable, AuditFormulaMainDto auditFormulaMain) {
    Page<AuditFormulaMainVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    if (StringUtils.isNotEmpty(auditFormulaMain.getSelectedCode())) {
      List<String> selectCodeList = Optional.ofNullable(auditFormulaMain.getSelectedCodeList()).orElse(Lists.newArrayList());
      selectCodeList.add(auditFormulaMain.getSelectedCode());
      auditFormulaMain.setSelectedCodeList(selectCodeList);
    }
    Page<AuditFormulaMainVo> pageList = this.auditFormulaMainMapper.findByConditions(page, auditFormulaMain);
    return pageList;
  }

  public List<AuditFormulaMain> findByIdList(List<String> idList) {
    return this.lambdaQuery()
            .eq(AuditFormulaMain::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .eq(AuditFormulaMain::getTenantCode, TenantUtils.getTenantCode())
            .in(AuditFormulaMain::getId, idList)
            .list();
  }

  public AuditFormulaMain findById(String id) {
    return this.lambdaQuery()
            .eq(AuditFormulaMain::getId, id)
            .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
            .one();
  }
}

