package com.biz.crm.tpm.business.audit.formula.local.service.internal;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.audit.business.sdk.dto.*;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaInfoDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.ConVariableMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.log.AuditFormulaLogEventDto;
import com.biz.crm.tpm.business.audit.business.sdk.event.log.AuditFormulaEventListener;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.ConVariableMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaInfo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaMain;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaChannelRepository;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaInfoRepository;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaMainRepository;
import com.biz.crm.tpm.business.audit.formula.local.service.AuditFormulaItemService;
import com.biz.crm.tpm.business.audit.formula.local.util.AuditFormulaUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.biz.crm.tpm.business.variable.sdk.vo.dynamic.ConfigurableCriterionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * 核销公式主表(AuditFormulaMain)表服务实现类
 *
 * @author makejava
 * @since 2022-11-03 11:49:28
 */
@Service("auditFormulaMainService")
public class AuditFormulaMainServiceImpl implements AuditFormulaMainService {

    @Autowired
    private AuditFormulaMainRepository auditFormulaMainRepository;

    @Autowired
    private ActivityFormService activityFormService;

    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Autowired
    private AuditFormulaInfoRepository auditFormulaInfoRepository;

    @Autowired(required = false)
    private ApplicationContext applicationContext;

    private static final String AUDIT_FORMULA_PREFIX = "HXGS";

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private List<FormulaVariableRegister> formulaVariableRegisters;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;

    @Autowired(required = false)
    private ConVariableDetailSdkService conVariableDetailSdkService;

    @Resource
    private AuditFormulaItemService auditFormulaItemService;

    @Resource
    private AuditFormulaChannelRepository auditFormulaChannelRepository;

    @Autowired(required = false)
    private AuditFormulaUtil auditFormulaUtil;

    @Autowired(required = false)
    private VariableService variableService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询数据
     *
     * @param pageable         分页对象
     * @param auditFormulaMain 实体对象
     * @return
     */
    @Override
    public Page<AuditFormulaMainVo> findByConditions(Pageable pageable, AuditFormulaMainDto auditFormulaMain) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(auditFormulaMain)) {
            auditFormulaMain = new AuditFormulaMainDto();
        }
        return this.auditFormulaMainRepository.findByConditions(pageable, auditFormulaMain);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public AuditFormulaMainVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        AuditFormulaMain auditFormulaMain = this.auditFormulaMainRepository.findById(id);
        AuditFormulaMainVo auditFormulaMainVo = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMain, AuditFormulaMainVo.class, null, null);
        List<AuditFormulaInfo> list = this.auditFormulaInfoRepository.lambdaQuery().eq(AuditFormulaInfo::getAuditFormulaCode, auditFormulaMain.getAuditFormulaCode()).list();
        Collection<AuditFormulaInfoVo> auditFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class);
        auditFormulaMainVo.setAuditFormulaInfoVoList((List<AuditFormulaInfoVo>) auditFormulaInfoVos);
        //查询可配置变量
        this.buildConVariableDetailVos(auditFormulaMainVo);
        //查询关联的一级渠道、二级渠道
        this.auditFormulaChannelRepository.loadDetail(auditFormulaMainVo);
        return auditFormulaMainVo;
    }

    /**
     * 查询可配置变量
     *
     * @param auditFormulaMainVo
     */
    private void buildConVariableDetailVos(AuditFormulaMainVo auditFormulaMainVo) {
        ConVariableDetailDto conVariableDetailDto = new ConVariableDetailDto();
        conVariableDetailDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        List<ConVariableDetailVo> itemDetail = this.conVariableDetailSdkService.getItemDetail(conVariableDetailDto);
        if (!CollectionUtils.isEmpty(itemDetail)) {
            Map<String, List<ConVariableDetailVo>> conVariableDetailMap =
                    itemDetail.stream().collect(Collectors.groupingBy(ConVariableDetailVo::getVariableCode));
            List<ConVariableMainVo> conVariableMainVos = Lists.newArrayList();
            conVariableDetailMap.forEach((k, v) -> {
                ConVariableDetailVo conVariableDetailVo = v.get(0);
                ConVariableMainVo mainVo = new ConVariableMainVo();
                mainVo.setVariableCode(k);
                mainVo.setBeginTime(conVariableDetailVo.getBeginTime());
                mainVo.setEndTime(conVariableDetailVo.getEndTime());
                mainVo.setSummaryDimension(conVariableDetailVo.getSummaryDimension());
                conVariableMainVos.add(mainVo);
            });
            auditFormulaMainVo.setConVariableMainVos(conVariableMainVos);
        }
    }

    /**
     * 新增数据
     *
     * @param auditFormulaMain 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public AuditFormulaMainVo create(AuditFormulaMainDto auditFormulaMain) {
//todo    this.createValidate(auditFormulaMain);
        this.createValidate(auditFormulaMain);
        if (StringUtils.isBlank(auditFormulaMain.getOrgCode())) {
            //HR组织为空默认自动从当前登录人上获取
            FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull(loginUserDetails,"未获取到当前登录人信息！");
            Validate.notBlank(loginUserDetails.getOrgCode(),"未获取到当前登录人的组织信息为空！");
            auditFormulaMain.setOrgCode(loginUserDetails.getOrgCode());
            auditFormulaMain.setOrgName(loginUserDetails.getOrgName());
        }
//        String ruleCode = StringUtils.join(AUDIT_FORMULA_PREFIX, DateFormatUtils.format(new Date(), "yyyyMMdd"));
        String code = this.generateCodeService.generateCode(AUDIT_FORMULA_PREFIX, 1, 5, 2, TimeUnit.DAYS).get(0);
        auditFormulaMain.setAuditFormulaCode(code);
        AuditFormulaMain auditFormulaMainEntity = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMain, AuditFormulaMain.class, null, null);
        auditFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
        this.auditFormulaMainRepository.saveOrUpdate(auditFormulaMainEntity);

        //更新活动形式关联
        if (StringUtils.isNotEmpty(auditFormulaMainEntity.getActivityFormCode())) {
            String[] formCodes = auditFormulaMainEntity.getActivityFormCode().split(",");
            List<ActivityFormVo> activityFormByCode = activityFormService.findActivityFormByCode(Sets.newHashSet(formCodes));
            activityFormByCode.forEach(x -> {
                x.setAuditCondition(auditFormulaMainEntity.getAuditFormulaCode());
                ActivityFormDto activityFormDto = nebulaToolkitService.copyObjectByWhiteList(x, ActivityFormDto.class, HashSet.class, ArrayList.class);
                this.activityFormService.updateAuditCondition(activityFormDto);
            });

        }

        // 如果有自定义配置的核销变量也要保存
        this.saveCriterionConfig(auditFormulaMain);
        List<AuditFormulaInfoDto> auditFormulaInfoDtoList = auditFormulaMain.getAuditFormulaInfoDtoList();
        if (!CollectionUtils.isEmpty(auditFormulaInfoDtoList)) {
            auditFormulaInfoDtoList.forEach(item -> {
                item.setAuditFormulaCode(auditFormulaMainEntity.getAuditFormulaCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection<AuditFormulaInfo> auditFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList(auditFormulaInfoDtoList, AuditFormulaInfoDto.class, AuditFormulaInfo.class, LinkedHashSet.class, ArrayList.class);
            auditFormulaInfoRepository.saveBatch(auditFormulaInfos);
        }
        //保存可配置变量配置信息
        this.saveConVariableDetail(auditFormulaMain);

        //保存关联一级渠道、二级渠道
        this.auditFormulaChannelRepository.replaceAll(auditFormulaMain);

        //新增业务日志
        AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFormulaMain);
        SerializableBiConsumer<AuditFormulaEventListener, AuditFormulaLogEventDto> onCreate =
                AuditFormulaEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFormulaEventListener.class, onCreate);

        AuditFormulaMainVo auditFormulaMainVo = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMainEntity, AuditFormulaMainVo.class, null, null);
        return auditFormulaMainVo;
    }

    /**
     * 保存可配置变量配置信息
     *
     * @param auditFormulaMain
     */
    public void saveConVariableDetail(AuditFormulaMainDto auditFormulaMain) {
        //删除所以可配置变量信息
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
        this.conVariableDetailSdkService.deleteByAuditFormulaCode(detailDto);
        if (CollectionUtils.isEmpty(auditFormulaMain.getConVariableMainDtos())) {
            return;
        }
        //保存新的
        List<ConVariableDetailDto> detailDtos = Lists.newArrayList();
        auditFormulaMain.getConVariableMainDtos().forEach(var -> {
            String brandCacheKey = var.getBrandCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, brandCacheKey, ConItemTypeEnum.BRAND.getCode()));
            String itemCacheKey = var.getItemCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, itemCacheKey, ConItemTypeEnum.ITEM.getCode()));
            String categoryCacheKey = var.getCategoryCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, categoryCacheKey, ConItemTypeEnum.CATEGORY.getCode()));
            String goodsCacheKey = var.getGoodsCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, goodsCacheKey, ConItemTypeEnum.GOODS.getCode()));
            String includeGoodsCacheKey = var.getIncludeGoodsCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, includeGoodsCacheKey, ConItemTypeEnum.INCLUDE_GOODS.getCode()));
            //商品互斥校验
            this.checkDuplicate(var.getVariableCode(), detailDtos);
            String customerCacheKey = var.getCustomerCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, customerCacheKey, ConItemTypeEnum.CUSTOMER.getCode()));
            String includeSalesOrgCacheKey = var.getIncludeSalesOrgCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, includeSalesOrgCacheKey, ConItemTypeEnum.INCLUDE_SALES_ORG.getCode()));
            String includeActivityFormCacheKey = var.getIncludeActivityFormCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, var, includeActivityFormCacheKey, ConItemTypeEnum.INCLUDE_ACTIVITY_FORM.getCode()));
        });
        this.conVariableDetailSdkService.batchSave(detailDtos);
    }

    /**
     * 商品互斥校验
     *
     * @param variableCode
     * @param detailDtos
     */
    private void checkDuplicate(String variableCode, List<ConVariableDetailDto> detailDtos) {
        //获取变量名称
        FormulaVariableRegister register = formulaVariableRegisters.stream()
                .filter(o -> o.getVariableCode().equals(variableCode)).findFirst().get();
        String variableName = register.getVariableName();
        Map<String, List<ConVariableDetailDto>> goodsMap = detailDtos.stream().filter(o -> o.getItemType().equals(ConItemTypeEnum.GOODS.getCode())
                || o.getItemType().equals(ConItemTypeEnum.INCLUDE_GOODS.getCode())).collect(Collectors.groupingBy(ConVariableDetailDto::getItemCode));
        List<String> duplicateCodes = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (v.size() > 1) {
                duplicateCodes.add(k);
            }
        });
        Assert.isTrue(CollectionUtils.isEmpty(duplicateCodes)
                , "变量[" + variableName + "]商品包含于非包含存在重复商品：" + String.join(",", duplicateCodes));
    }

    /**
     * 构建可配置变量明细
     *
     * @param auditFormulaMain
     * @param var
     * @param cacheKey
     * @param itemType
     * @return {@link List}<{@link ConVariableDetailDto}>
     */
    private List<ConVariableDetailDto> buildConVariableDetailDto(AuditFormulaMainDto auditFormulaMain
            , ConVariableMainDto var, String cacheKey, String itemType) {
        if (org.springframework.util.StringUtils.hasText(cacheKey)) {
            List<ConVariableDetailDto> cacheList = this.auditFormulaItemService.findCacheList(cacheKey);
            cacheList.forEach(cache -> {
                cache.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                cache.setBeginTime(var.getBeginTime());
                cache.setEndTime(var.getEndTime());
                cache.setItemType(itemType);
                cache.setSummaryDimension(var.getSummaryDimension());
                cache.setVariableCode(var.getVariableCode());
            });
            return cacheList;
        }
        return Lists.newArrayList();
    }

    private void saveCriterionConfig(AuditFormulaMainDto auditFormulaMain) {
        /**
         * - 扩展信息全部都放到这个json里了。
         * (ps: demo中的入参就是json，它可以把json转成业务主表vo模型。但这里不可以，因为入参是业务主表的javaBean的Dto，接收会丢失数据，所以，这里补充了个json属性，但只用来接收可变表单数据）
         */
        JSONObject configurableCriterion = auditFormulaMain.getConfigurableCriterion();
        // -把前端传过来的json转换成动态表单可是使用的结构
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble) {
            // - 没有可配置核销变量的表单信息
            return;
        }
        /**
         * - 把json里的信息转成动态表单的可用模型(ps:动态表单，还必须用map接收第一层参数）
         * - 所以必须有模型让动态表单用，模型里还必须有个map来接收每个表单
         */
        DynamicFormServiceBuilder<ConfigurableCriterionVo> dynamicFormServiceBuilder = applicationContext.getBean(DynamicFormServiceBuilder.class, ConfigurableCriterionVo.class, this.applicationContext);
        /**
         * - 构建 DynamicFormService
         * - map<核销变量code，动态表单编码>
         * - 动态表单编码，可以随意命名。
         *   - 但必须在动态表单所有业务中唯一
         *   - 操作策略实现类里的dynamicFormCode()方法返回值必须是同一个值
         *   - 此处业务开发，让核销变量code和动态表单code一致
         */
        DynamicFormService<ConfigurableCriterionVo> dynamicFormService =
                dynamicFormServiceBuilder.dynamicField("criterionMap")
//todo 临时替换为字符串                   .addDynamicMapping(SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE, SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE)
                        .addDynamicMapping("CPXSSL", "CPXSSL")
                        .config()
                        .build();
        /**
         * 将json转成模型
         */
        ConfigurableCriterionVo configurableCriterionVo = dynamicFormService.dynamic(configurableCriterion);
        /**
         * 保存信息
         */
        dynamicFormService.createDynamicDetails(configurableCriterionVo, auditFormulaMain.getAuditFormulaCode());
    }

    /**
     * 重新组装
     * - 原结构：
     * {
     * "configurableCriterion":{
     * "criterionMap":{
     * “核销变量实例编码”：{表单内容}
     * }
     * }
     * }
     * - 转换后的结构：
     * {
     * "configurableCriterion":{
     * "criterionMap":{
     * "核销变量模板"：[
     * {
     * "instanceCode":"核销变量实例编码",
     * // 表单内容的其它属性对
     * }
     * ]
     * }
     * }
     * }
     *
     * @param configurableCriterion 可配置标准
     */
    private Boolean reassemble(JSONObject configurableCriterion) {
        Validate.isTrue(!CollectionUtils.isEmpty(formulaVariableRegisters), "系统中不存在核销变量！");
        if (ObjectUtils.isEmpty(configurableCriterion)) {
            return false;
        }
        JSONObject criterionMap = configurableCriterion.getJSONObject("criterionMap");
        if (ObjectUtils.isEmpty(criterionMap)) {
            return false;
        }
        Set<String> keySet = criterionMap.keySet();
        if (CollectionUtils.isEmpty(keySet)) {
            return false;
        }
        JSONObject criterionMapAfter = new JSONObject(keySet.size());
        for (String instanceCode : keySet) {
            // - 变量模板code
            Optional<FormulaVariableRegister> registerOpt = formulaVariableRegisters.stream()
                    .filter(register ->
                            StringUtils.startsWith(instanceCode, register.getVariableCode())
                    )
                    .findFirst();
            if (!registerOpt.isPresent()) {
                continue;
            }
            FormulaVariableRegister criterionRegister = registerOpt.get();
            String variableCode = criterionRegister.getVariableCode();
            // - 表单内添加属性
            JSONObject formJson = criterionMap.getJSONObject(instanceCode);
            formJson.put("instanceCode", instanceCode);
            // - 表单信息按核销变量模板分组
            JSONArray jsonArray = criterionMapAfter.getJSONArray(variableCode);
            if (ObjectUtils.isNotEmpty(jsonArray)) {
                jsonArray.add(formJson);
            } else {
                JSONArray array = new JSONArray();
                array.add(formJson);
                criterionMapAfter.put(variableCode, array);
            }
        }
        // - 替换原来的criterionMap
        configurableCriterion.put("criterionMap", criterionMapAfter);
        return true;
    }

    /**
     * 修改新据
     *
     * @param auditFormulaMain 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public AuditFormulaMainVo update(AuditFormulaMainDto auditFormulaMain) {
        //todo this.updateValidate(auditFormulaMain);
        this.updateValidate(auditFormulaMain);
        if (StringUtils.isBlank(auditFormulaMain.getOrgCode())) {
            //HR组织为空默认自动从当前登录人上获取
            FacturerUserDetails loginUserDetails = loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull(loginUserDetails,"未获取到当前登录人信息！");
            Validate.notBlank(loginUserDetails.getOrgCode(),"未获取到当前登录人的组织信息为空！");
            auditFormulaMain.setOrgCode(loginUserDetails.getOrgCode());
            auditFormulaMain.setOrgName(loginUserDetails.getOrgName());
        }
        AuditFormulaMainVo oldVo = this.findById(auditFormulaMain.getId());
        AuditFormulaMain auditFormulaMainEntity = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMain, AuditFormulaMain.class, null, null);
        auditFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
        this.auditFormulaMainRepository.saveOrUpdate(auditFormulaMainEntity);

        //更新活动形式关联
        if (StringUtils.isNotEmpty(auditFormulaMainEntity.getActivityFormCode())) {
            String[] formCodes = auditFormulaMainEntity.getActivityFormCode().split(",");
            List<ActivityFormVo> activityFormByCode = activityFormService.findActivityFormByCode(Sets.newHashSet(formCodes));
            activityFormByCode.forEach(x -> {
                x.setAuditCondition(auditFormulaMainEntity.getAuditFormulaCode());
                ActivityFormDto activityFormDto = nebulaToolkitService.copyObjectByWhiteList(x, ActivityFormDto.class, HashSet.class, ArrayList.class);
                this.activityFormService.updateAuditCondition(activityFormDto);
            });

        }

        // 如果有自定义配置的返利变量也要修改
        this.updateCriterionConfig(auditFormulaMain);

        //更新公式
        auditFormulaInfoRepository.remove(Wrappers.lambdaUpdate(AuditFormulaInfo.class).eq(AuditFormulaInfo::getAuditFormulaCode, auditFormulaMain.getAuditFormulaCode()));
        List<AuditFormulaInfoDto> auditFormulaInfoDtoList = auditFormulaMain.getAuditFormulaInfoDtoList();
        if (!CollectionUtils.isEmpty(auditFormulaInfoDtoList)) {
            auditFormulaInfoDtoList.forEach(item -> {
                item.setAuditFormulaCode(auditFormulaMainEntity.getAuditFormulaCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection<AuditFormulaInfo> auditFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList(auditFormulaInfoDtoList, AuditFormulaInfoDto.class, AuditFormulaInfo.class, LinkedHashSet.class, ArrayList.class);
            auditFormulaInfoRepository.saveBatch(auditFormulaInfos);
        }
        //保存可配置变量配置信息
        this.saveConVariableDetail(auditFormulaMain);

        //保存关联一级渠道、二级渠道
        this.auditFormulaChannelRepository.replaceAll(auditFormulaMain);

        //修改业务日志
        AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFormulaMain);
        SerializableBiConsumer<AuditFormulaEventListener, AuditFormulaLogEventDto> onUpdate =
                AuditFormulaEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, AuditFormulaEventListener.class, onUpdate);

        AuditFormulaMainVo auditFormulaMainVo = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMainEntity, AuditFormulaMainVo.class, null, null);
        return auditFormulaMainVo;
    }

    private void updateCriterionConfig(AuditFormulaMainDto auditFormulaMain) {
        JSONObject configurableCriterion = auditFormulaMain.getConfigurableCriterion();
        // -把前端传过来的json转换成动态表单可是使用的结构
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble) {
            // - 没有可配置返利变量的表单信息
            return;
        }
        DynamicFormServiceBuilder<ConfigurableCriterionVo> dynamicFormServiceBuilder = applicationContext.getBean(DynamicFormServiceBuilder.class, ConfigurableCriterionVo.class, this.applicationContext);
        DynamicFormService<ConfigurableCriterionVo> dynamicFormService =
                dynamicFormServiceBuilder.dynamicField("criterionMap")
                        .addDynamicMapping("CPXSSL", "CPXSSL")
//todo 临时替换                    .addDynamicMapping(SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE, SaleVolumeCriterionImpl.REBATE_POLICY_CRITERION_CODE)
                        .config()
                        .build();
        /**
         * 将json转成模型
         */
        ConfigurableCriterionVo configurableCriterionVo = dynamicFormService.dynamic(configurableCriterion);
        /**
         * 保存信息
         */
        dynamicFormService.modifyDynamicDetails(configurableCriterionVo, auditFormulaMain.getAuditFormulaCode());
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<AuditFormulaMain> auditFormulaMains1 = this.auditFormulaMainRepository.findByIdList(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(auditFormulaMains1), "没有找到id对应的数据");
        List<AuditFormulaMain> auditFormulaMains = new ArrayList<>();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            auditFormulaMains.add(auditFormulaMain);

            //删除业务日志
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto auditFormulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainDto.class, null, null);
            auditFormulaMainDto.setDelFlag(auditFormulaMain.getDelFlag());
            logEventDto.setNewest(auditFormulaMainDto);
            SerializableBiConsumer<AuditFormulaEventListener, AuditFormulaLogEventDto> onDelete =
                    AuditFormulaEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, AuditFormulaEventListener.class, onDelete);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    @Override
    public void enable(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "启用数据时，主键集合不能为空！");
        List<AuditFormulaMain> auditFormulaMains1 = this.auditFormulaMainRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(auditFormulaMains1), "没有找到id对应的数据");
        List<AuditFormulaMain> auditFormulaMains = new ArrayList<>();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            auditFormulaMains.add(auditFormulaMain);

            //启用业务日志
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto auditFormulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainDto.class, null, null);
            auditFormulaMainDto.setEnableStatus(auditFormulaMain.getEnableStatus());
            logEventDto.setNewest(auditFormulaMainDto);
            SerializableBiConsumer<AuditFormulaEventListener, AuditFormulaLogEventDto> onEnable =
                    AuditFormulaEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, AuditFormulaEventListener.class, onEnable);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    @Override
    public void disable(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "禁用数据时，主键集合不能为空！");
        List<AuditFormulaMain> auditFormulaMains1 = this.auditFormulaMainRepository.listByIds(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(auditFormulaMains1), "没有找到id对应的数据");
        List<AuditFormulaMain> auditFormulaMains = new ArrayList<>();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            auditFormulaMains.add(auditFormulaMain);

            //禁用业务日志
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto formulaMainDto = this.nebulaToolkitService.copyObjectByWhiteList(item, AuditFormulaMainDto.class, null, null);
            formulaMainDto.setEnableStatus(auditFormulaMain.getEnableStatus());
            logEventDto.setNewest(formulaMainDto);
            SerializableBiConsumer<AuditFormulaEventListener, AuditFormulaLogEventDto> onDisable =
                    AuditFormulaEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, AuditFormulaEventListener.class, onDisable);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    @Override
    public List<AuditFormulaMainVo> getList(AuditFormulaMainDto auditFormulaMainDto) {

        List<AuditFormulaMain> list = this.auditFormulaMainRepository.lambdaQuery().eq(AuditFormulaMain::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .eq(AuditFormulaMain::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.isNotEmpty(auditFormulaMainDto.getBusinessFormatCode()), AuditFormulaMain::getBusinessFormatCode, auditFormulaMainDto.getBusinessFormatCode())
                .eq(StringUtils.isNotEmpty(auditFormulaMainDto.getActivityFormCode()), AuditFormulaMain::getActivityFormCode, auditFormulaMainDto.getActivityFormCode())
                .eq(StringUtils.isNotEmpty(auditFormulaMainDto.getBusinessUnitCode()), AuditFormulaMain::getBusinessUnitCode, auditFormulaMainDto.getBusinessUnitCode())
                .eq(StringUtils.isNotEmpty(auditFormulaMainDto.getAuditFormulaName()), AuditFormulaMain::getAuditFormulaName, auditFormulaMainDto.getAuditFormulaName()).list();

        Collection<AuditFormulaMainVo> auditFormulaMainVos = this.nebulaToolkitService.copyCollectionByBlankList(Optional.of(list).orElse(new ArrayList<>()), AuditFormulaMain.class, AuditFormulaMainVo.class, LinkedHashSet.class, ArrayList.class);
        return (List<AuditFormulaMainVo>) auditFormulaMainVos;
    }

    @Override
    public AuditFormulaMainVo findByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        AuditFormulaMain auditFormulaMain = this.auditFormulaMainRepository.lambdaQuery().eq(AuditFormulaMain::getAuditFormulaCode, code).one();
        Validate.notNull(auditFormulaMain, "未找到数据");
        AuditFormulaMainVo auditFormulaMainVo = this.nebulaToolkitService.copyObjectByWhiteList(auditFormulaMain, AuditFormulaMainVo.class, null, null);
        List<AuditFormulaInfo> list = this.auditFormulaInfoRepository.lambdaQuery().eq(AuditFormulaInfo::getAuditFormulaCode, auditFormulaMain.getAuditFormulaCode()).list();
        Collection<AuditFormulaInfoVo> auditFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList(list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class);
        auditFormulaMainVo.setAuditFormulaInfoVoList((List<AuditFormulaInfoVo>) auditFormulaInfoVos);
        //查询可配置变量
        this.buildConVariableDetailVos(auditFormulaMainVo);
        return auditFormulaMainVo;
    }

    /**
     * 批量查询核销公式
     */
    @Override
    public List<AuditFormulaInfoVo> findFormulaInfoListByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        List<AuditFormulaInfo> list = this.auditFormulaInfoRepository.findByAuditFormulaCodeList(codeList);
        return (List<AuditFormulaInfoVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class);
    }

    @Override
    public List<AuditFormulaMainVo> findByCodeList(List<String> codeList) {
        List<AuditFormulaMain> list = this.auditFormulaMainRepository.lambdaQuery()
                .eq(AuditFormulaMain::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .eq(AuditFormulaMain::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(AuditFormulaMain::getAuditFormulaCode, codeList).list();
        return (List<AuditFormulaMainVo>) this.nebulaToolkitService.copyCollectionByBlankList(Optional.of(list).orElse(new ArrayList<>()), AuditFormulaMain.class, AuditFormulaMainVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 通过条件查询列表
     * 制度核销找核销条件逻辑：（优先级由上往下）
     * 1、活动形式和销售组织均有值：核销类型取制度核销+活动形式+活动分类+销售组织+业务单元+业态
     * 2、活动形式没值：核销类型取制度核销+活动分类+销售组织+业务单元+业态
     * 3、销售组织没值：核销类型取制度核销+活动形式+活动分类+业务单元+业态
     * 4、活动销售和销售组织均没值：核销类型取制度核销+活动分类+业务单元+业态
     */
    @Override
    public List<AuditFormulaMainVo> findListByDto(AuditFormulaMainDto dto) {
        if (StringUtils.isEmpty(dto.getAuditType())
                || StringUtils.isEmpty(dto.getBusinessFormatCode())
                || StringUtils.isEmpty(dto.getBusinessUnitCode())
                || StringUtils.isEmpty(dto.getActivityTypeCode())) {
            return Lists.newArrayList();
        }
        boolean headQuarters = BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode());//主体

        LambdaQueryWrapper<AuditFormulaMain> wrapper = Wrappers.<AuditFormulaMain>lambdaQuery();
        wrapper.eq(AuditFormulaMain::getAuditType, dto.getAuditType());
        wrapper.eq(AuditFormulaMain::getBusinessFormatCode, dto.getBusinessFormatCode());
        wrapper.eq(AuditFormulaMain::getBusinessUnitCode, dto.getBusinessUnitCode());
        wrapper.like(AuditFormulaMain::getActivityTypeCode, dto.getActivityTypeCode());
        wrapper.eq(AuditFormulaMain::getDelFlag, DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(AuditFormulaMain::getEnableStatus, EnableStatusEnum.ENABLE.getCode());
        wrapper.orderByDesc(AuditFormulaMain::getCreateTime);
        List<AuditFormulaMain> list = this.auditFormulaMainRepository.list(wrapper);

        if (!headQuarters) {
            //主体尚不清楚是否需要这个过滤
            if (StringUtils.isEmpty(dto.getWriteOffMethod())) {
                list = list.stream().filter(e -> StringUtils.isEmpty(e.getWriteOffMethod())).collect(Collectors.toList());
            } else {
                list = list.stream().filter(e -> StringUtils.isEmpty(e.getWriteOffMethod()) || Arrays.asList(e.getWriteOffMethod().split(",")).contains(dto.getWriteOffMethod())).collect(Collectors.toList());
            }
        }

        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        //如果组织不为空，查询组织及上级组织信息
        Map<String, String> orgParentMap = new HashMap<>();
        if (StringUtils.isNotEmpty(dto.getSalesOrgCodes())) {
            List<SalesOrgVo> salesOrgVos = salesOrgVoService.findAllParentBySalesOrgCode(dto.getSalesOrgCodes());
            orgParentMap.putAll(
                    salesOrgVos.stream()
                            .filter(e -> StringUtils.isNotEmpty(e.getParentCode()))
                            .collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getParentCode)));
        }
        //主体逻辑
        if (headQuarters) {
            return auditFormulaUtil.headQuarterFilter(dto, list, orgParentMap);
        }
        List<AuditFormulaMain> filterList = Lists.newArrayList();
        //活动形式+销售组织递归过滤
        if (StringUtils.isNotEmpty(dto.getSalesOrgCodes()) && StringUtils.isNotEmpty(dto.getActivityFormCode())) {
            AtomicReference<String> orgCode = new AtomicReference<>(dto.getSalesOrgCodes());
            int deep = 5;
            while (StringUtils.isNotEmpty(orgCode.get()) && CollectionUtils.isEmpty(filterList) && deep > 0) {
                deep--;
                filterList = list.stream().filter(e -> StringUtils.isNotEmpty(e.getSalesOrgCodes())
                                && Arrays.asList(e.getSalesOrgCodes().split(",")).contains(orgCode.get())
                                && StringUtils.isNotEmpty(e.getActivityFormCode())
                                && Arrays.asList(e.getActivityFormCode().split(",")).contains(dto.getActivityFormCode()))
                        .collect(Collectors.toList());
                orgCode.set(orgParentMap.get(orgCode.get()));
            }
        }

        //销售组织递归过滤
        if (CollectionUtils.isEmpty(filterList) && StringUtils.isNotEmpty(dto.getSalesOrgCodes())) {
            AtomicReference<String> orgCode = new AtomicReference<>(dto.getSalesOrgCodes());
            int deep = 5;
            while (StringUtils.isNotEmpty(orgCode.get()) && CollectionUtils.isEmpty(filterList) && deep > 0) {
                deep--;
                filterList = list.stream().filter(e -> StringUtils.isNotEmpty(e.getSalesOrgCodes())
                                && Arrays.asList(e.getSalesOrgCodes().split(",")).contains(orgCode.get()))
                        .collect(Collectors.toList());
                orgCode.set(orgParentMap.get(orgCode.get()));
            }
        }
        if (CollectionUtils.isEmpty(filterList) && StringUtils.isNotEmpty(dto.getActivityFormCode())) {
            filterList = list.stream().filter(e -> StringUtils.isNotEmpty(e.getActivityFormCode())
                            && Arrays.asList(e.getActivityFormCode().split(",")).contains(dto.getActivityFormCode()))
                    .collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(filterList)) {
            filterList = list;
        }
        return this.auditFormulaUtil.buildResult(filterList);
    }

    /**
     * 创建验证
     *
     * @param auditFormulaMain
     */
    private void createValidate(AuditFormulaMainDto auditFormulaMain) {
        Validate.notNull(auditFormulaMain, "新增时，对象信息不能为空！");
        auditFormulaMain.setId(null);
        auditFormulaMain.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(auditFormulaMain.getTenantCode(), "新增数据时，租户编号不能为空！");
//        Validate.notBlank(auditFormulaMain.getAuditFormulaCode(), "新增数据时，核销公式编码不能为空！");
        Validate.notBlank(auditFormulaMain.getAuditFormulaName(), "新增数据时，核销公式名称不能为空！");
        Validate.notBlank(auditFormulaMain.getAuditType(), "新增数据时，核销类型不能为空！");
        Validate.notBlank(auditFormulaMain.getBusinessFormatCode(), "新增数据时，业态不能为空！");
        Validate.notBlank(auditFormulaMain.getBusinessUnitCode(), "新增数据时，业务单元不能为空！");

//        Validate.notBlank(auditFormulaMain.getActivityFormCode(), "新增数据时，活动形式不能为空！");
//        Validate.notBlank(auditFormulaMain.getActivityFormName(), "新增数据时，活动形式名称不能为空！");
        if ("1".equals(auditFormulaMain.getAuditType())) {
            Validate.notBlank(auditFormulaMain.getActivityTypeCode(), "新增数据时，活动分类不能为空！");
//            Validate.notBlank(auditFormulaMain.getActivityTypeName(), "新增数据时，活动分类名称不能为空！");
            if (BusinessUnitEnum.isDefaultBusinessUnit(auditFormulaMain.getBusinessUnitCode())) {
                Validate.notBlank(auditFormulaMain.getCustomerTypes(), "新增数据时，客户类型不能为空！");
//                Validate.notBlank(auditFormulaMain.getCustomerTypeNames(), "新增数据时，客户类型名称不能为空！");
            }
        }

        if (!CollectionUtils.isEmpty(auditFormulaMain.getFirstChannelList())) {
            auditFormulaMain.getFirstChannelList().forEach(v -> {
                Validate.notBlank(v.getChannelCode(), "一级渠道-渠道编码不能为空！");
                Validate.notBlank(v.getChannelName(), "一级渠道-渠道名称不能为空！");
            });
        }
        if (!CollectionUtils.isEmpty(auditFormulaMain.getSecondChannelList())) {
            auditFormulaMain.getSecondChannelList().forEach(v -> {
                Validate.notBlank(v.getChannelCode(), "二级渠道-渠道编码不能为空！");
                Validate.notBlank(v.getChannelName(), "二级渠道-渠道名称不能为空！");
            });
        }
        if (!CollectionUtils.isEmpty(auditFormulaMain.getAuditFormulaInfoDtoList())) {
            List<AuditFormulaInfoVo> list = (List<AuditFormulaInfoVo>) nebulaToolkitService.copyCollectionByWhiteList(auditFormulaMain.getAuditFormulaInfoDtoList(), AuditFormulaInfoDto.class, AuditFormulaInfoVo.class, HashSet.class, ArrayList.class);
            variableService.testFormula(this.copyFormulaInfoList(list));
        }
    }

    /**
     * 修改验证
     *
     * @param auditFormulaMain
     */
    private void updateValidate(AuditFormulaMainDto auditFormulaMain) {
        Validate.notNull(auditFormulaMain, "修改时，对象信息不能为空！");
        auditFormulaMain.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank(auditFormulaMain.getId(), "修改时，不能为空！");
        Validate.notBlank(auditFormulaMain.getTenantCode(), "修改时，租户编号不能为空！");
        Validate.notBlank(auditFormulaMain.getAuditFormulaCode(), "修改时，核销公式编码不能为空！");
        Validate.notBlank(auditFormulaMain.getAuditFormulaName(), "修改时，核销公式名称不能为空！");
        Validate.notBlank(auditFormulaMain.getAuditType(), "修改时，核销类型不能为空！");
        Validate.notBlank(auditFormulaMain.getBusinessFormatCode(), "修改时，业态不能为空！");
        Validate.notBlank(auditFormulaMain.getBusinessUnitCode(), "修改时，业务单元不能为空！");

//        Validate.notBlank(auditFormulaMain.getActivityFormCode(), "修改时，活动形式不能为空！");
//        Validate.notBlank(auditFormulaMain.getActivityFormName(), "修改时，活动形式名称不能为空！");
        if ("1".equals(auditFormulaMain.getAuditType())) {
            Validate.notBlank(auditFormulaMain.getActivityTypeCode(), "修改时，活动分类不能为空！");
//            Validate.notBlank(auditFormulaMain.getActivityTypeName(), "修改时，活动分类名称不能为空！");
            if (BusinessUnitEnum.isDefaultBusinessUnit(auditFormulaMain.getBusinessUnitCode())) {
                Validate.notBlank(auditFormulaMain.getCustomerTypes(), "修改时，客户类型不能为空！");
//                Validate.notBlank(auditFormulaMain.getCustomerTypeNames(), "修改时，客户类型名称不能为空！");
            }
        }

        if (!CollectionUtils.isEmpty(auditFormulaMain.getFirstChannelList())) {
            auditFormulaMain.getFirstChannelList().forEach(v -> {
                Validate.notBlank(v.getChannelCode(), "一级渠道-渠道编码不能为空！");
                Validate.notBlank(v.getChannelName(), "一级渠道-渠道名称不能为空！");
            });
        }
        if (!CollectionUtils.isEmpty(auditFormulaMain.getSecondChannelList())) {
            auditFormulaMain.getSecondChannelList().forEach(v -> {
                Validate.notBlank(v.getChannelCode(), "二级渠道-渠道编码不能为空！");
                Validate.notBlank(v.getChannelName(), "二级渠道-渠道名称不能为空！");
            });
        }
        if (!CollectionUtils.isEmpty(auditFormulaMain.getAuditFormulaInfoDtoList())) {
            List<AuditFormulaInfoVo> list = (List<AuditFormulaInfoVo>) nebulaToolkitService.copyCollectionByWhiteList(auditFormulaMain.getAuditFormulaInfoDtoList(), AuditFormulaInfoDto.class, AuditFormulaInfoVo.class, HashSet.class, ArrayList.class);
            variableService.testFormula(this.copyFormulaInfoList(list));
        }
    }

    private List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        List<FormulaInfoDto> list = new ArrayList<>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }
}

