/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.formula.local.cache;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class AuditFormulaItemCacheHelper
extends MnPageCacheHelper<ConVariableDetailVo, ConVariableDetailDto> {
    private static final Logger log = LoggerFactory.getLogger(AuditFormulaItemCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ConVariableDetailSdkService conVariableDetailSdkService;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "tpm_audit_formula_item_key:";
    }

    public Class<ConVariableDetailDto> getDtoClass() {
        return ConVariableDetailDto.class;
    }

    public Class<ConVariableDetailVo> getVoClass() {
        return ConVariableDetailVo.class;
    }

    public List<ConVariableDetailDto> findDtoListFromRepository(ConVariableDetailDto detailDto, String cacheKey) {
        try {
            Assert.notNull((Object)detailDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)cacheKey, (String)"\u7f13\u5b58key\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.hasText((String)detailDto.getVariableCode(), (String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (!StringUtils.hasText((String)detailDto.getAuditFormulaCode())) {
                return Lists.newArrayList();
            }
            Assert.hasText((String)detailDto.getItemType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            List detailVos = this.conVariableDetailSdkService.getItemDetail(detailDto);
            List detailDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)detailVos, ConVariableDetailVo.class, ConVariableDetailDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)detailDtos)) {
                String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
                String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
                detailDtos.forEach(o -> o.setId(cacheKey + "-" + o.getItemCode()));
                Map detailDtoMap = detailDtos.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
                this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), detailDtoMap.keySet().toArray());
                this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, detailDtoMap);
                this.redisService.expire(redisCacheDataKey, this.getExpireTime());
            }
            return detailDtos;
        }
        catch (Exception e) {
            String redisCacheInitKey = this.getRedisCacheInitKey(cacheKey);
            this.redisService.del(redisCacheInitKey);
            throw new RuntimeException(e.getMessage());
        }
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<ConVariableDetailDto> newItem(String cacheKey, List<ConVariableDetailDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List<ConVariableDetailDto> newList = itemList.stream().filter(item -> !idList.contains(cacheKey + "-" + item.getItemCode())).collect(Collectors.toList());
        Assert.notEmpty(newList, (String)"\u6dfb\u52a0\u7684\u6570\u636e\u5168\u90e8\u91cd\u590d");
        newList.forEach(dto -> {
            dto.setId(cacheKey + "-" + dto.getItemCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantUtils.getTenantCode());
        });
        return newList;
    }

    public void updateItem(String cacheKey, List<ConVariableDetailDto> itemList) {
    }

    public List<ConVariableDetailDto> copyItem(String cacheKey, List<ConVariableDetailDto> itemList) {
        return null;
    }

    public Object getDtoKey(ConVariableDetailDto detailDto) {
        return detailDto.getId();
    }

    public String getCheckedStatus(ConVariableDetailDto detailDto) {
        return detailDto.getChecked();
    }

    public void importSave(String cacheKey, ConVariableDetailDto dto) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        dto.setId(cacheKey + "-" + dto.getItemCode());
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        if (!idList.contains(dto.getId())) {
            Object[] newIdArr = new Object[]{dto.getId()};
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        HashMap ratioDtoMap = Maps.newHashMap();
        ratioDtoMap.put(dto.getId(), dto);
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, (Map)ratioDtoMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

