/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.formula.local.imports;

import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.audit.formula.local.cache.AuditFormulaItemCacheHelper;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Component
public class AuditFormulaItemImportProcess
implements ImportProcess<ConVariableDetailImportVo> {
    private static final Logger log = LoggerFactory.getLogger(AuditFormulaItemImportProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private CustomerVoService customerVoService;
    @Resource
    private AuditFormulaItemCacheHelper auditFormulaItemCacheHelper;
    private static final String TPM_CON_ITEM_TYPE = "tpm_con_item_type";
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, ConVariableDetailImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<ConVariableDetailImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        ConVariableDetailImportVo vo = first.get();
        try {
            String cacheKey = String.valueOf(params.get("cacheKey"));
            Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
            String itemType = String.valueOf(params.get("itemType"));
            Assert.hasText((String)itemType, (String)"\u7c7b\u578b[itemType]\u4e0d\u80fd\u4e3a\u7a7a");
            ConVariableDetailDto dto = this.validate(vo, itemType);
            this.auditFormulaItemCacheHelper.importSave(cacheKey, dto);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u6708\u5ea6\u9884\u7b97\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList((Object[])new String[]{TPM_CON_ITEM_TYPE}));
    }

    private ConVariableDetailDto validate(ConVariableDetailImportVo vo, String itemType) {
        this.verifyEmpty(vo);
        ConVariableDetailDto dto = new ConVariableDetailDto();
        dto.setItemCode(vo.getItemCode());
        ConItemTypeEnum typeEnum = ConItemTypeEnum.findByCode((String)itemType);
        Assert.notNull((Object)typeEnum, (String)"\u7c7b\u578b\u9519\u8bef");
        switch (typeEnum) {
            case BRAND: {
                break;
            }
            case ITEM: {
                break;
            }
            case CATEGORY: {
                break;
            }
            case GOODS: 
            case INCLUDE_GOODS: {
                List productList = this.productVoService.findByCodes((List)Lists.newArrayList((Object[])new String[]{vo.getItemCode()}));
                Assert.notEmpty((Collection)productList, (String)"\u672a\u67e5\u8be2\u5230\u4ea7\u54c1\u4fe1\u606f");
                ProductVo productVo = (ProductVo)productList.get(0);
                dto.setItemName(productVo.getProductName());
                dto.setId(productVo.getId());
                dto.setPoint(vo.getPoint());
                break;
            }
            case CUSTOMER: {
                CustomerVo customerVo = this.customerVoService.findDetailsByIdOrCode(null, vo.getItemCode());
                Assert.notNull((Object)customerVo, (String)"\u672a\u67e5\u8be2\u5230\u5ba2\u6237\u4fe1\u606f");
                dto.setItemName(customerVo.getCustomerName());
                dto.setId(customerVo.getId());
                break;
            }
        }
        return dto;
    }

    private void verifyDictCode(ConVariableDetailImportVo vo) {
    }

    private void verifyEmpty(ConVariableDetailImportVo vo) {
        Assert.hasText((String)vo.getItemCode(), (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private String findDictValue(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    private String findDictCode(String dictCode, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictCode().equals(dictCode)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return 1;
    }

    public Class<ConVariableDetailImportVo> findCrmExcelVoClass() {
        return ConVariableDetailImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_CON_VARIABLE_DETAIL_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u6838\u9500\u6761\u4ef6\u53ef\u914d\u7f6e\u53d8\u91cf\u660e\u7ec6\u7c7b\u578b\u5bfc\u5165\u6a21\u7248";
    }

    public String getBusinessCode() {
        return "TPM_AUDIT_FORMULA_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u6838\u9500\u6761\u4ef6\u914d\u7f6e\u5bfc\u5165";
    }
}

