/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.formula.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaChannelDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.enums.TerminalChannelLevelEnum;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaChannelVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaChannel;
import com.biz.crm.tpm.business.audit.formula.local.mapper.AuditFormulaChannelMapper;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFormulaChannelRepository
extends ServiceImpl<AuditFormulaChannelMapper, AuditFormulaChannel> {
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Transactional
    public void replaceAll(AuditFormulaMainDto auditFormulaMain) {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(AuditFormulaChannel::getAuditFormulaCode, (Object)auditFormulaMain.getAuditFormulaCode())).remove();
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getFirstChannelList()) || !CollectionUtils.isEmpty((Collection)auditFormulaMain.getSecondChannelList())) {
            ArrayList channelList = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getFirstChannelList())) {
                List firstChannelList = auditFormulaMain.getFirstChannelList();
                firstChannelList.forEach(e -> {
                    e.setId(null);
                    e.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                    e.setChannelType(TerminalChannelLevelEnum.FIRST.getCode());
                    e.setTenantCode(TenantUtils.getTenantCode());
                });
                channelList.addAll(firstChannelList);
            }
            if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getSecondChannelList())) {
                List secondChannelList = auditFormulaMain.getSecondChannelList();
                secondChannelList.forEach(e -> {
                    e.setId(null);
                    e.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                    e.setChannelType(TerminalChannelLevelEnum.SECOND.getCode());
                    e.setTenantCode(TenantUtils.getTenantCode());
                });
                channelList.addAll(secondChannelList);
            }
            this.saveBatch(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)channelList, AuditFormulaChannelDto.class, AuditFormulaChannel.class, HashSet.class, ArrayList.class, new String[0]));
        }
    }

    public void loadDetail(AuditFormulaMainVo auditFormulaMainVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(AuditFormulaChannel::getAuditFormulaCode, (Object)auditFormulaMainVo.getAuditFormulaCode())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List channelList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)list, AuditFormulaChannel.class, AuditFormulaChannelVo.class, HashSet.class, ArrayList.class, new String[0]);
        Map<String, List<AuditFormulaChannelVo>> listMap = channelList.stream().collect(Collectors.groupingBy(AuditFormulaChannelVo::getChannelType));
        List<AuditFormulaChannelVo> firstChannelList = listMap.getOrDefault(TerminalChannelLevelEnum.FIRST.getCode(), Lists.newArrayList());
        firstChannelList.sort(Comparator.comparing(AuditFormulaChannelVo::getChannelCode));
        List<AuditFormulaChannelVo> secondChannelList = listMap.getOrDefault(TerminalChannelLevelEnum.SECOND.getCode(), Lists.newArrayList());
        secondChannelList.sort(Comparator.comparing(AuditFormulaChannelVo::getChannelCode));
        auditFormulaMainVo.setFirstChannelList(firstChannelList);
        auditFormulaMainVo.setSecondChannelList(secondChannelList);
    }
}

