/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.formula.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.form.sdk.DynamicFormService;
import com.biz.crm.common.form.sdk.DynamicFormServiceBuilder;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaInfoDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.ConVariableMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.dto.log.AuditFormulaLogEventDto;
import com.biz.crm.tpm.business.audit.business.sdk.event.log.AuditFormulaEventListener;
import com.biz.crm.tpm.business.audit.business.sdk.service.AuditFormulaMainService;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.ConVariableMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaInfo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaMain;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaChannelRepository;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaInfoRepository;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaMainRepository;
import com.biz.crm.tpm.business.audit.formula.local.service.AuditFormulaItemService;
import com.biz.crm.tpm.business.audit.formula.local.util.AuditFormulaUtil;
import com.biz.crm.tpm.business.variable.sdk.dto.ConVariableDetailDto;
import com.biz.crm.tpm.business.variable.sdk.dto.FormulaInfoDto;
import com.biz.crm.tpm.business.variable.sdk.enums.ConItemTypeEnum;
import com.biz.crm.tpm.business.variable.sdk.register.FormulaVariableRegister;
import com.biz.crm.tpm.business.variable.sdk.service.ConVariableDetailSdkService;
import com.biz.crm.tpm.business.variable.sdk.service.VariableService;
import com.biz.crm.tpm.business.variable.sdk.vo.ConVariableDetailVo;
import com.biz.crm.tpm.business.variable.sdk.vo.dynamic.ConfigurableCriterionVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="auditFormulaMainService")
public class AuditFormulaMainServiceImpl
implements AuditFormulaMainService {
    @Autowired
    private AuditFormulaMainRepository auditFormulaMainRepository;
    @Autowired
    private ActivityFormService activityFormService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private AuditFormulaInfoRepository auditFormulaInfoRepository;
    @Autowired(required=false)
    private ApplicationContext applicationContext;
    private static final String AUDIT_FORMULA_PREFIX = "HXGS";
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private List<FormulaVariableRegister> formulaVariableRegisters;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private ConVariableDetailSdkService conVariableDetailSdkService;
    @Resource
    private AuditFormulaItemService auditFormulaItemService;
    @Resource
    private AuditFormulaChannelRepository auditFormulaChannelRepository;
    @Autowired(required=false)
    private AuditFormulaUtil auditFormulaUtil;
    @Autowired(required=false)
    private VariableService variableService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<AuditFormulaMainVo> findByConditions(Pageable pageable, AuditFormulaMainDto auditFormulaMain) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(auditFormulaMain)) {
            auditFormulaMain = new AuditFormulaMainDto();
        }
        return this.auditFormulaMainRepository.findByConditions(pageable, auditFormulaMain);
    }

    public AuditFormulaMainVo findById(String id) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditFormulaMain auditFormulaMain = this.auditFormulaMainRepository.findById(id);
        AuditFormulaMainVo auditFormulaMainVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMain, AuditFormulaMainVo.class, null, null, new String[0]);
        List list = ((LambdaQueryChainWrapper)this.auditFormulaInfoRepository.lambdaQuery().eq(AuditFormulaInfo::getAuditFormulaCode, (Object)auditFormulaMain.getAuditFormulaCode())).list();
        Collection auditFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditFormulaMainVo.setAuditFormulaInfoVoList((List)auditFormulaInfoVos);
        this.buildConVariableDetailVos(auditFormulaMainVo);
        this.auditFormulaChannelRepository.loadDetail(auditFormulaMainVo);
        return auditFormulaMainVo;
    }

    private void buildConVariableDetailVos(AuditFormulaMainVo auditFormulaMainVo) {
        ConVariableDetailDto conVariableDetailDto = new ConVariableDetailDto();
        conVariableDetailDto.setAuditFormulaCode(auditFormulaMainVo.getAuditFormulaCode());
        List itemDetail = this.conVariableDetailSdkService.getItemDetail(conVariableDetailDto);
        if (!CollectionUtils.isEmpty((Collection)itemDetail)) {
            Map<String, List<ConVariableDetailVo>> conVariableDetailMap = itemDetail.stream().collect(Collectors.groupingBy(ConVariableDetailVo::getVariableCode));
            ArrayList conVariableMainVos = Lists.newArrayList();
            conVariableDetailMap.forEach((k, v) -> {
                ConVariableDetailVo conVariableDetailVo = (ConVariableDetailVo)v.get(0);
                ConVariableMainVo mainVo = new ConVariableMainVo();
                mainVo.setVariableCode(k);
                mainVo.setBeginTime(conVariableDetailVo.getBeginTime());
                mainVo.setEndTime(conVariableDetailVo.getEndTime());
                mainVo.setSummaryDimension(conVariableDetailVo.getSummaryDimension());
                conVariableMainVos.add(mainVo);
            });
            auditFormulaMainVo.setConVariableMainVos((List)conVariableMainVos);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFormulaMainVo create(AuditFormulaMainDto auditFormulaMain) {
        this.createValidate(auditFormulaMain);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)auditFormulaMain.getOrgCode())) {
            FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull((Object)loginUserDetails, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)loginUserDetails.getOrgCode(), (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            auditFormulaMain.setOrgCode(loginUserDetails.getOrgCode());
            auditFormulaMain.setOrgName(loginUserDetails.getOrgName());
        }
        String code = (String)this.generateCodeService.generateCode(AUDIT_FORMULA_PREFIX, 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
        auditFormulaMain.setAuditFormulaCode(code);
        AuditFormulaMain auditFormulaMainEntity = (AuditFormulaMain)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMain, AuditFormulaMain.class, null, null, new String[0]));
        auditFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
        this.auditFormulaMainRepository.saveOrUpdate((Object)auditFormulaMainEntity);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainEntity.getActivityFormCode())) {
            Object[] formCodes = auditFormulaMainEntity.getActivityFormCode().split(",");
            List activityFormByCode = this.activityFormService.findActivityFormByCode((Set)Sets.newHashSet((Object[])formCodes));
            activityFormByCode.forEach(x -> {
                x.setAuditCondition(auditFormulaMainEntity.getAuditFormulaCode());
                ActivityFormDto activityFormDto = (ActivityFormDto)this.nebulaToolkitService.copyObjectByWhiteList(x, ActivityFormDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.activityFormService.updateAuditCondition(activityFormDto);
            });
        }
        this.saveCriterionConfig(auditFormulaMain);
        List auditFormulaInfoDtoList = auditFormulaMain.getAuditFormulaInfoDtoList();
        if (!CollectionUtils.isEmpty((Collection)auditFormulaInfoDtoList)) {
            auditFormulaInfoDtoList.forEach(item -> {
                item.setAuditFormulaCode(auditFormulaMainEntity.getAuditFormulaCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection auditFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)auditFormulaInfoDtoList, AuditFormulaInfoDto.class, AuditFormulaInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditFormulaInfoRepository.saveBatch(auditFormulaInfos);
        }
        this.saveConVariableDetail(auditFormulaMain);
        this.auditFormulaChannelRepository.replaceAll(auditFormulaMain);
        AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(auditFormulaMain);
        SerializableBiConsumer & Serializable onCreate = AuditFormulaEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFormulaEventListener.class, (SerializableBiConsumer)onCreate);
        AuditFormulaMainVo auditFormulaMainVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMainEntity, AuditFormulaMainVo.class, null, null, new String[0]);
        return auditFormulaMainVo;
    }

    public void saveConVariableDetail(AuditFormulaMainDto auditFormulaMain) {
        ConVariableDetailDto detailDto = new ConVariableDetailDto();
        detailDto.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
        this.conVariableDetailSdkService.deleteByAuditFormulaCode(detailDto);
        if (CollectionUtils.isEmpty((Collection)auditFormulaMain.getConVariableMainDtos())) {
            return;
        }
        ArrayList detailDtos = Lists.newArrayList();
        auditFormulaMain.getConVariableMainDtos().forEach(var -> {
            String brandCacheKey = var.getBrandCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, brandCacheKey, ConItemTypeEnum.BRAND.getCode()));
            String itemCacheKey = var.getItemCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, itemCacheKey, ConItemTypeEnum.ITEM.getCode()));
            String categoryCacheKey = var.getCategoryCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, categoryCacheKey, ConItemTypeEnum.CATEGORY.getCode()));
            String goodsCacheKey = var.getGoodsCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, goodsCacheKey, ConItemTypeEnum.GOODS.getCode()));
            String includeGoodsCacheKey = var.getIncludeGoodsCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, includeGoodsCacheKey, ConItemTypeEnum.INCLUDE_GOODS.getCode()));
            this.checkDuplicate(var.getVariableCode(), detailDtos);
            String customerCacheKey = var.getCustomerCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, customerCacheKey, ConItemTypeEnum.CUSTOMER.getCode()));
            String includeSalesOrgCacheKey = var.getIncludeSalesOrgCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, includeSalesOrgCacheKey, ConItemTypeEnum.INCLUDE_SALES_ORG.getCode()));
            String includeActivityFormCacheKey = var.getIncludeActivityFormCacheKey();
            detailDtos.addAll(this.buildConVariableDetailDto(auditFormulaMain, (ConVariableMainDto)var, includeActivityFormCacheKey, ConItemTypeEnum.INCLUDE_ACTIVITY_FORM.getCode()));
        });
        this.conVariableDetailSdkService.batchSave((List)detailDtos);
    }

    private void checkDuplicate(String variableCode, List<ConVariableDetailDto> detailDtos) {
        FormulaVariableRegister register = this.formulaVariableRegisters.stream().filter(o -> o.getVariableCode().equals(variableCode)).findFirst().get();
        String variableName = register.getVariableName();
        Map<String, List<ConVariableDetailDto>> goodsMap = detailDtos.stream().filter(o -> o.getItemType().equals(ConItemTypeEnum.GOODS.getCode()) || o.getItemType().equals(ConItemTypeEnum.INCLUDE_GOODS.getCode())).collect(Collectors.groupingBy(ConVariableDetailDto::getItemCode));
        ArrayList duplicateCodes = Lists.newArrayList();
        goodsMap.forEach((k, v) -> {
            if (v.size() > 1) {
                duplicateCodes.add(k);
            }
        });
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)duplicateCodes), (String)("\u53d8\u91cf[" + variableName + "]\u5546\u54c1\u5305\u542b\u4e8e\u975e\u5305\u542b\u5b58\u5728\u91cd\u590d\u5546\u54c1\uff1a" + String.join((CharSequence)",", duplicateCodes)));
    }

    private List<ConVariableDetailDto> buildConVariableDetailDto(AuditFormulaMainDto auditFormulaMain, ConVariableMainDto var, String cacheKey, String itemType) {
        if (StringUtils.hasText((String)cacheKey)) {
            List cacheList = this.auditFormulaItemService.findCacheList(cacheKey);
            cacheList.forEach(cache -> {
                cache.setAuditFormulaCode(auditFormulaMain.getAuditFormulaCode());
                cache.setBeginTime(var.getBeginTime());
                cache.setEndTime(var.getEndTime());
                cache.setItemType(itemType);
                cache.setSummaryDimension(var.getSummaryDimension());
                cache.setVariableCode(var.getVariableCode());
            });
            return cacheList;
        }
        return Lists.newArrayList();
    }

    private void saveCriterionConfig(AuditFormulaMainDto auditFormulaMain) {
        JSONObject configurableCriterion = auditFormulaMain.getConfigurableCriterion();
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble.booleanValue()) {
            return;
        }
        DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ConfigurableCriterionVo.class, this.applicationContext});
        DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("criterionMap").addDynamicMapping("CPXSSL", "CPXSSL").config().build();
        ConfigurableCriterionVo configurableCriterionVo = (ConfigurableCriterionVo)dynamicFormService.dynamic(configurableCriterion);
        dynamicFormService.createDynamicDetails((Object)configurableCriterionVo, auditFormulaMain.getAuditFormulaCode());
    }

    private Boolean reassemble(JSONObject configurableCriterion) {
        Validate.isTrue((!CollectionUtils.isEmpty(this.formulaVariableRegisters) ? 1 : 0) != 0, (String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6838\u9500\u53d8\u91cf\uff01", (Object[])new Object[0]);
        if (ObjectUtils.isEmpty((Object)configurableCriterion)) {
            return false;
        }
        JSONObject criterionMap = configurableCriterion.getJSONObject("criterionMap");
        if (ObjectUtils.isEmpty((Object)criterionMap)) {
            return false;
        }
        Set keySet = criterionMap.keySet();
        if (CollectionUtils.isEmpty((Collection)keySet)) {
            return false;
        }
        JSONObject criterionMapAfter = new JSONObject(keySet.size());
        for (String instanceCode : keySet) {
            Optional<FormulaVariableRegister> registerOpt = this.formulaVariableRegisters.stream().filter(register -> org.apache.commons.lang3.StringUtils.startsWith((CharSequence)instanceCode, (CharSequence)register.getVariableCode())).findFirst();
            if (!registerOpt.isPresent()) continue;
            FormulaVariableRegister criterionRegister = registerOpt.get();
            String variableCode = criterionRegister.getVariableCode();
            JSONObject formJson = criterionMap.getJSONObject(instanceCode);
            formJson.put("instanceCode", (Object)instanceCode);
            JSONArray jsonArray = criterionMapAfter.getJSONArray(variableCode);
            if (ObjectUtils.isNotEmpty((Object)jsonArray)) {
                jsonArray.add((Object)formJson);
                continue;
            }
            JSONArray array = new JSONArray();
            array.add((Object)formJson);
            criterionMapAfter.put(variableCode, (Object)array);
        }
        configurableCriterion.put("criterionMap", (Object)criterionMapAfter);
        return true;
    }

    @Transactional(rollbackFor={Exception.class})
    public AuditFormulaMainVo update(AuditFormulaMainDto auditFormulaMain) {
        this.updateValidate(auditFormulaMain);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)auditFormulaMain.getOrgCode())) {
            FacturerUserDetails loginUserDetails = (FacturerUserDetails)this.loginUserService.getLoginDetails(FacturerUserDetails.class);
            Validate.notNull((Object)loginUserDetails, (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)loginUserDetails.getOrgCode(), (String)"\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u4eba\u7684\u7ec4\u7ec7\u4fe1\u606f\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            auditFormulaMain.setOrgCode(loginUserDetails.getOrgCode());
            auditFormulaMain.setOrgName(loginUserDetails.getOrgName());
        }
        AuditFormulaMainVo oldVo = this.findById(auditFormulaMain.getId());
        AuditFormulaMain auditFormulaMainEntity = (AuditFormulaMain)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMain, AuditFormulaMain.class, null, null, new String[0]));
        auditFormulaMainEntity.setTenantCode(TenantUtils.getTenantCode());
        this.auditFormulaMainRepository.saveOrUpdate((Object)auditFormulaMainEntity);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainEntity.getActivityFormCode())) {
            Object[] formCodes = auditFormulaMainEntity.getActivityFormCode().split(",");
            List activityFormByCode = this.activityFormService.findActivityFormByCode((Set)Sets.newHashSet((Object[])formCodes));
            activityFormByCode.forEach(x -> {
                x.setAuditCondition(auditFormulaMainEntity.getAuditFormulaCode());
                ActivityFormDto activityFormDto = (ActivityFormDto)this.nebulaToolkitService.copyObjectByWhiteList(x, ActivityFormDto.class, HashSet.class, ArrayList.class, new String[0]);
                this.activityFormService.updateAuditCondition(activityFormDto);
            });
        }
        this.updateCriterionConfig(auditFormulaMain);
        this.auditFormulaInfoRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditFormulaInfo.class).eq(AuditFormulaInfo::getAuditFormulaCode, (Object)auditFormulaMain.getAuditFormulaCode()));
        List auditFormulaInfoDtoList = auditFormulaMain.getAuditFormulaInfoDtoList();
        if (!CollectionUtils.isEmpty((Collection)auditFormulaInfoDtoList)) {
            auditFormulaInfoDtoList.forEach(item -> {
                item.setAuditFormulaCode(auditFormulaMainEntity.getAuditFormulaCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            Collection auditFormulaInfos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)auditFormulaInfoDtoList, AuditFormulaInfoDto.class, AuditFormulaInfo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            this.auditFormulaInfoRepository.saveBatch(auditFormulaInfos);
        }
        this.saveConVariableDetail(auditFormulaMain);
        this.auditFormulaChannelRepository.replaceAll(auditFormulaMain);
        AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(auditFormulaMain);
        SerializableBiConsumer & Serializable onUpdate = AuditFormulaEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFormulaEventListener.class, (SerializableBiConsumer)onUpdate);
        AuditFormulaMainVo auditFormulaMainVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMainEntity, AuditFormulaMainVo.class, null, null, new String[0]);
        return auditFormulaMainVo;
    }

    private void updateCriterionConfig(AuditFormulaMainDto auditFormulaMain) {
        JSONObject configurableCriterion = auditFormulaMain.getConfigurableCriterion();
        Boolean reassemble = this.reassemble(configurableCriterion);
        if (!reassemble.booleanValue()) {
            return;
        }
        DynamicFormServiceBuilder dynamicFormServiceBuilder = (DynamicFormServiceBuilder)this.applicationContext.getBean(DynamicFormServiceBuilder.class, new Object[]{ConfigurableCriterionVo.class, this.applicationContext});
        DynamicFormService dynamicFormService = dynamicFormServiceBuilder.dynamicField("criterionMap").addDynamicMapping("CPXSSL", "CPXSSL").config().build();
        ConfigurableCriterionVo configurableCriterionVo = (ConfigurableCriterionVo)dynamicFormService.dynamic(configurableCriterion);
        dynamicFormService.modifyDynamicDetails((Object)configurableCriterionVo, auditFormulaMain.getAuditFormulaCode());
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<AuditFormulaMain> auditFormulaMains1 = this.auditFormulaMainRepository.findByIdList(idList);
        Validate.isTrue((!CollectionUtils.isEmpty(auditFormulaMains1) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230id\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        ArrayList auditFormulaMains = new ArrayList();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            auditFormulaMains.add(auditFormulaMain);
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto auditFormulaMainDto = (AuditFormulaMainDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainDto.class, null, null, new String[0]);
            auditFormulaMainDto.setDelFlag(auditFormulaMain.getDelFlag());
            logEventDto.setNewest(auditFormulaMainDto);
            SerializableBiConsumer & Serializable onDelete = AuditFormulaEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFormulaEventListener.class, (SerializableBiConsumer)onDelete);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    public void enable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u542f\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List auditFormulaMains1 = this.auditFormulaMainRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)auditFormulaMains1) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230id\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        ArrayList auditFormulaMains = new ArrayList();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            auditFormulaMains.add(auditFormulaMain);
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto auditFormulaMainDto = (AuditFormulaMainDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainDto.class, null, null, new String[0]);
            auditFormulaMainDto.setEnableStatus(auditFormulaMain.getEnableStatus());
            logEventDto.setNewest(auditFormulaMainDto);
            SerializableBiConsumer & Serializable onEnable = AuditFormulaEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFormulaEventListener.class, (SerializableBiConsumer)onEnable);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    public void disable(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u7981\u7528\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List auditFormulaMains1 = this.auditFormulaMainRepository.listByIds(idList);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)auditFormulaMains1) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230id\u5bf9\u5e94\u7684\u6570\u636e", (Object[])new Object[0]);
        ArrayList auditFormulaMains = new ArrayList();
        auditFormulaMains1.forEach(item -> {
            AuditFormulaMain auditFormulaMain = new AuditFormulaMain();
            auditFormulaMain.setId(item.getId());
            auditFormulaMain.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            auditFormulaMains.add(auditFormulaMain);
            AuditFormulaLogEventDto logEventDto = new AuditFormulaLogEventDto();
            AuditFormulaMainVo oldVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainVo.class, null, null, new String[0]);
            logEventDto.setOriginal(oldVo);
            AuditFormulaMainDto formulaMainDto = (AuditFormulaMainDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)item, AuditFormulaMainDto.class, null, null, new String[0]);
            formulaMainDto.setEnableStatus(auditFormulaMain.getEnableStatus());
            logEventDto.setNewest(formulaMainDto);
            SerializableBiConsumer & Serializable onDisable = AuditFormulaEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditFormulaEventListener.class, (SerializableBiConsumer)onDisable);
        });
        this.auditFormulaMainRepository.updateBatchById(auditFormulaMains);
    }

    public List<AuditFormulaMainVo> getList(AuditFormulaMainDto auditFormulaMainDto) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditFormulaMainRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainDto.getBusinessFormatCode()), AuditFormulaMain::getBusinessFormatCode, (Object)auditFormulaMainDto.getBusinessFormatCode())).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainDto.getActivityFormCode()), AuditFormulaMain::getActivityFormCode, (Object)auditFormulaMainDto.getActivityFormCode())).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainDto.getBusinessUnitCode()), AuditFormulaMain::getBusinessUnitCode, (Object)auditFormulaMainDto.getBusinessUnitCode())).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)auditFormulaMainDto.getAuditFormulaName()), AuditFormulaMain::getAuditFormulaName, (Object)auditFormulaMainDto.getAuditFormulaName())).list();
        Collection auditFormulaMainVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)Optional.of(list).orElse(new ArrayList()), AuditFormulaMain.class, AuditFormulaMainVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return (List)auditFormulaMainVos;
    }

    public AuditFormulaMainVo findByCode(String code) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        AuditFormulaMain auditFormulaMain = (AuditFormulaMain)((Object)((LambdaQueryChainWrapper)this.auditFormulaMainRepository.lambdaQuery().eq(AuditFormulaMain::getAuditFormulaCode, (Object)code)).one());
        Validate.notNull((Object)((Object)auditFormulaMain), (String)"\u672a\u627e\u5230\u6570\u636e", (Object[])new Object[0]);
        AuditFormulaMainVo auditFormulaMainVo = (AuditFormulaMainVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)auditFormulaMain, AuditFormulaMainVo.class, null, null, new String[0]);
        List list = ((LambdaQueryChainWrapper)this.auditFormulaInfoRepository.lambdaQuery().eq(AuditFormulaInfo::getAuditFormulaCode, (Object)auditFormulaMain.getAuditFormulaCode())).list();
        Collection auditFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        auditFormulaMainVo.setAuditFormulaInfoVoList((List)auditFormulaInfoVos);
        this.buildConVariableDetailVos(auditFormulaMainVo);
        return auditFormulaMainVo;
    }

    public List<AuditFormulaInfoVo> findFormulaInfoListByCodeList(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return null;
        }
        List<AuditFormulaInfo> list = this.auditFormulaInfoRepository.findByAuditFormulaCodeList(codeList);
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFormulaMainVo> findByCodeList(List<String> codeList) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditFormulaMainRepository.lambdaQuery().eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(AuditFormulaMain::getAuditFormulaCode, codeList)).list();
        return (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)Optional.of(list).orElse(new ArrayList()), AuditFormulaMain.class, AuditFormulaMainVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditFormulaMainVo> findListByDto(AuditFormulaMainDto dto) {
        int deep;
        AtomicReference<String> orgCode;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getAuditType()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getBusinessFormatCode()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getBusinessUnitCode()) || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getActivityTypeCode())) {
            return Lists.newArrayList();
        }
        boolean headQuarters = BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(AuditFormulaMain::getAuditType, (Object)dto.getAuditType());
        wrapper.eq(AuditFormulaMain::getBusinessFormatCode, (Object)dto.getBusinessFormatCode());
        wrapper.eq(AuditFormulaMain::getBusinessUnitCode, (Object)dto.getBusinessUnitCode());
        wrapper.like(AuditFormulaMain::getActivityTypeCode, (Object)dto.getActivityTypeCode());
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode());
        wrapper.orderByDesc(UuidOpEntity::getCreateTime);
        List<AuditFormulaMain> list = this.auditFormulaMainRepository.list((Wrapper)wrapper);
        if (!headQuarters) {
            list = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dto.getWriteOffMethod()) ? list.stream().filter(e -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)e.getWriteOffMethod())).collect(Collectors.toList()) : list.stream().filter(e -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)e.getWriteOffMethod()) || Arrays.asList(e.getWriteOffMethod().split(",")).contains(dto.getWriteOffMethod())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList();
        }
        HashMap<String, String> orgParentMap = new HashMap<String, String>();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCodes())) {
            List salesOrgVos = this.salesOrgVoService.findAllParentBySalesOrgCode(dto.getSalesOrgCodes());
            orgParentMap.putAll(salesOrgVos.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getParentCode())).collect(Collectors.toMap(SalesOrgVo::getSalesOrgCode, SalesOrgVo::getParentCode)));
        }
        if (headQuarters) {
            return this.auditFormulaUtil.headQuarterFilter(dto, list, orgParentMap);
        }
        List<Object> filterList = Lists.newArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCodes()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getActivityFormCode())) {
            orgCode = new AtomicReference<String>(dto.getSalesOrgCodes());
            for (deep = 5; org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgCode.get()) && CollectionUtils.isEmpty((Collection)filterList) && deep > 0; --deep) {
                filterList = list.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCodes()) && Arrays.asList(e.getSalesOrgCodes().split(",")).contains(orgCode.get()) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getActivityFormCode()) && Arrays.asList(e.getActivityFormCode().split(",")).contains(dto.getActivityFormCode())).collect(Collectors.toList());
                orgCode.set((String)orgParentMap.get(orgCode.get()));
            }
        }
        if (CollectionUtils.isEmpty((Collection)filterList) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getSalesOrgCodes())) {
            orgCode = new AtomicReference<String>(dto.getSalesOrgCodes());
            for (deep = 5; org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)orgCode.get()) && CollectionUtils.isEmpty((Collection)filterList) && deep > 0; --deep) {
                filterList = list.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCodes()) && Arrays.asList(e.getSalesOrgCodes().split(",")).contains(orgCode.get())).collect(Collectors.toList());
                orgCode.set((String)orgParentMap.get(orgCode.get()));
            }
        }
        if (CollectionUtils.isEmpty((Collection)filterList) && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getActivityFormCode())) {
            filterList = list.stream().filter(e -> org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.getActivityFormCode()) && Arrays.asList(e.getActivityFormCode().split(",")).contains(dto.getActivityFormCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)filterList)) {
            filterList = list;
        }
        return this.auditFormulaUtil.buildResult(filterList);
    }

    private void createValidate(AuditFormulaMainDto auditFormulaMain) {
        Validate.notNull((Object)auditFormulaMain, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditFormulaMain.setId(null);
        auditFormulaMain.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)auditFormulaMain.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getAuditFormulaName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u516c\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getAuditType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getBusinessFormatCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getBusinessUnitCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("1".equals(auditFormulaMain.getAuditType())) {
            Validate.notBlank((CharSequence)auditFormulaMain.getActivityTypeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)auditFormulaMain.getBusinessUnitCode())) {
                Validate.notBlank((CharSequence)auditFormulaMain.getCustomerTypes(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getFirstChannelList())) {
            auditFormulaMain.getFirstChannelList().forEach(v -> {
                Validate.notBlank((CharSequence)v.getChannelCode(), (String)"\u4e00\u7ea7\u6e20\u9053-\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)v.getChannelName(), (String)"\u4e00\u7ea7\u6e20\u9053-\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getSecondChannelList())) {
            auditFormulaMain.getSecondChannelList().forEach(v -> {
                Validate.notBlank((CharSequence)v.getChannelCode(), (String)"\u4e8c\u7ea7\u6e20\u9053-\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)v.getChannelName(), (String)"\u4e8c\u7ea7\u6e20\u9053-\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getAuditFormulaInfoDtoList())) {
            List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditFormulaMain.getAuditFormulaInfoDtoList(), AuditFormulaInfoDto.class, AuditFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.variableService.testFormula(this.copyFormulaInfoList(list));
        }
    }

    private void updateValidate(AuditFormulaMainDto auditFormulaMain) {
        Validate.notNull((Object)auditFormulaMain, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        auditFormulaMain.setTenantCode(TenantUtils.getTenantCode());
        Validate.notBlank((CharSequence)auditFormulaMain.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getTenantCode(), (String)"\u4fee\u6539\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getAuditFormulaCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u516c\u5f0f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getAuditFormulaName(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u516c\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getAuditType(), (String)"\u4fee\u6539\u65f6\uff0c\u6838\u9500\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getBusinessFormatCode(), (String)"\u4fee\u6539\u65f6\uff0c\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)auditFormulaMain.getBusinessUnitCode(), (String)"\u4fee\u6539\u65f6\uff0c\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if ("1".equals(auditFormulaMain.getAuditType())) {
            Validate.notBlank((CharSequence)auditFormulaMain.getActivityTypeCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (BusinessUnitEnum.isDefaultBusinessUnit((String)auditFormulaMain.getBusinessUnitCode())) {
                Validate.notBlank((CharSequence)auditFormulaMain.getCustomerTypes(), (String)"\u4fee\u6539\u65f6\uff0c\u5ba2\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getFirstChannelList())) {
            auditFormulaMain.getFirstChannelList().forEach(v -> {
                Validate.notBlank((CharSequence)v.getChannelCode(), (String)"\u4e00\u7ea7\u6e20\u9053-\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)v.getChannelName(), (String)"\u4e00\u7ea7\u6e20\u9053-\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getSecondChannelList())) {
            auditFormulaMain.getSecondChannelList().forEach(v -> {
                Validate.notBlank((CharSequence)v.getChannelCode(), (String)"\u4e8c\u7ea7\u6e20\u9053-\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notBlank((CharSequence)v.getChannelName(), (String)"\u4e8c\u7ea7\u6e20\u9053-\u6e20\u9053\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)auditFormulaMain.getAuditFormulaInfoDtoList())) {
            List list = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)auditFormulaMain.getAuditFormulaInfoDtoList(), AuditFormulaInfoDto.class, AuditFormulaInfoVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.variableService.testFormula(this.copyFormulaInfoList(list));
        }
    }

    private List<FormulaInfoDto> copyFormulaInfoList(List<AuditFormulaInfoVo> auditFormulaInfoVoList) {
        ArrayList<FormulaInfoDto> list = new ArrayList<FormulaInfoDto>();
        auditFormulaInfoVoList.forEach(info -> {
            FormulaInfoDto dto = new FormulaInfoDto();
            dto.setFormulaCode(info.getAuditFormulaCode());
            dto.setFormulaCondition(info.getAuditFormulaCondition());
            dto.setFormulaConditionName(info.getAuditFormulaConditionName());
            dto.setFormula(info.getAuditFormula());
            dto.setFormulaName(info.getAuditFormulaName());
            list.add(dto);
        });
        return list;
    }
}

