/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.formula.local.util;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.customer.sdk.enums.RtmModelEnum;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.enums.TerminalChannelLevelEnum;
import com.biz.crm.tpm.business.audit.business.sdk.enums.YesOrNoEnum;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaChannel;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaInfo;
import com.biz.crm.tpm.business.audit.formula.local.entity.AuditFormulaMain;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaChannelRepository;
import com.biz.crm.tpm.business.audit.formula.local.repository.AuditFormulaInfoRepository;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AuditFormulaUtil {
    private static final Logger log = LoggerFactory.getLogger(AuditFormulaUtil.class);
    @Autowired(required=false)
    private AuditFormulaChannelRepository auditFormulaChannelRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private AuditFormulaInfoRepository auditFormulaInfoRepository;

    public List<AuditFormulaMainVo> headQuarterFilter(AuditFormulaMainDto dto, List<AuditFormulaMain> list, Map<String, String> orgParentMap) {
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        list = StringUtils.equals((CharSequence)RtmModelEnum.SON_COMPANY.getDictCode(), (CharSequence)dto.getCustomerTypes()) ? list.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerTypes()) && Arrays.asList(e.getCustomerTypes().split(",")).contains(RtmModelEnum.SON_COMPANY.getDictCode())).collect(Collectors.toList()) : list.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getCustomerTypes()) && Arrays.asList(e.getCustomerTypes().split(",")).contains(RtmModelEnum.DEALER.getDictCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List<Object> filterList = Lists.newArrayList();
        if (StringUtils.equals((CharSequence)"Z0001", (CharSequence)dto.getActivityTypeCode())) {
            dto.setDisplayNumber(StringUtils.isNotEmpty((CharSequence)dto.getDisplayNumber()) ? dto.getDisplayNumber() : "1");
            dto.setCustomerAccount(null);
        } else if (StringUtils.equals((CharSequence)"Z0002", (CharSequence)dto.getActivityTypeCode())) {
            dto.setCustomerAccount(StringUtils.isNotEmpty((CharSequence)dto.getCustomerAccount()) ? dto.getCustomerAccount() : YesOrNoEnum.YES.getCode());
            dto.setDisplayNumber(null);
        } else {
            dto.setDisplayNumber(null);
            dto.setCustomerAccount(null);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getFirstChannel())) {
            dto.setFirstChannel("Q");
        }
        List auditFormulaCodes = list.stream().map(AuditFormulaMain::getAuditFormulaCode).collect(Collectors.toList());
        List channelList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.auditFormulaChannelRepository.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(AuditFormulaChannel::getAuditFormulaCode, auditFormulaCodes)).list();
        Map<String, Map<String, List<String>>> channelInfoMap = channelList.stream().collect(Collectors.groupingBy(AuditFormulaChannel::getAuditFormulaCode, Collectors.groupingBy(AuditFormulaChannel::getChannelType, Collectors.mapping(AuditFormulaChannel::getChannelCode, Collectors.toList()))));
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u6838\u9500\u516c\u5f0f======\u300b{}", JSONObject.toJSON(list));
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u5165\u53c2======\u300b{}", JSONObject.toJSON((Object)dto));
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u6e20\u9053======\u300b{}", JSONObject.toJSON(channelInfoMap));
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7ec4\u7ec7======\u300b{}", JSONObject.toJSON(orgParentMap));
        filterList = this.filter(dto, list, (List<AuditFormulaMain>)filterList, channelInfoMap, orgParentMap, true, true, true, true, true, true);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c1\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, true, true, true, true, false, true);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c2\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, true, true, true, true, true, false);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c3\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, true, true, true, true, false, false);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c4\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, true, true, true, false, true, true);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c5\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, true, true, true, false, false, false);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c6\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        filterList = this.filter(dto, list, filterList, channelInfoMap, orgParentMap, false, true, true, false, false, false);
        log.info("\u6838\u9500\u6761\u4ef6\u5339\u914d=====\u300b\u7b2c7\u4f18\u5148\u7ea7=====>{}=====>{}", (Object)filterList.size(), (Object)JSONObject.toJSONString(filterList));
        return this.buildResult(filterList);
    }

    public List<AuditFormulaMainVo> buildResult(List<AuditFormulaMain> filterList) {
        if (CollectionUtil.isNotEmpty(filterList)) {
            Collection mainVos = this.nebulaToolkitService.copyCollectionByBlankList(filterList, AuditFormulaMain.class, AuditFormulaMainVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List codes = mainVos.stream().map(AuditFormulaMainVo::getAuditFormulaCode).collect(Collectors.toList());
            List infos = ((LambdaQueryChainWrapper)this.auditFormulaInfoRepository.lambdaQuery().in(AuditFormulaInfo::getAuditFormulaCode, codes)).list();
            Map<String, List<AuditFormulaInfo>> listMap = infos.stream().collect(Collectors.groupingBy(AuditFormulaInfo::getAuditFormulaCode));
            for (AuditFormulaMainVo mainVo : mainVos) {
                List<AuditFormulaInfo> infoList = listMap.getOrDefault(mainVo.getAuditFormulaCode(), Lists.newArrayList());
                Collection auditFormulaInfoVos = this.nebulaToolkitService.copyCollectionByBlankList(infoList, AuditFormulaInfo.class, AuditFormulaInfoVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                mainVo.setAuditFormulaInfoVoList((List)auditFormulaInfoVos);
            }
            return (List)mainVos;
        }
        return Lists.newArrayList();
    }

    public List<AuditFormulaMain> filter(AuditFormulaMainDto dto, List<AuditFormulaMain> list, List<AuditFormulaMain> filterList, Map<String, Map<String, List<String>>> channelInfoMap, Map<String, String> orgParentMap, boolean saleOrg, boolean displayNumber, boolean customerAccount, boolean firstChannel, boolean secondChannel, boolean activityFormCode) {
        if (CollectionUtils.isEmpty(filterList)) {
            if (!saleOrg) {
                filterList = list.stream().filter(e -> !(displayNumber && !this.containsFilter(dto.getDisplayNumber(), e.getDisplayNumber()) || customerAccount && !this.containsFilter(dto.getCustomerAccount(), e.getCustomerAccount()))).collect(Collectors.toList());
            }
            if (saleOrg) {
                AtomicReference<String> orgCode = new AtomicReference<String>(dto.getSalesOrgCodes());
                int deep = 5;
                while (StringUtils.isNotEmpty((CharSequence)orgCode.get()) && CollectionUtils.isEmpty(filterList) && deep > 0) {
                    --deep;
                    filterList = list.stream().filter(e -> !(!StringUtils.isNotEmpty((CharSequence)e.getSalesOrgCodes()) || !Arrays.asList(e.getSalesOrgCodes().split(",")).contains(orgCode.get()) || displayNumber && !this.containsFilter(dto.getDisplayNumber(), e.getDisplayNumber()) || customerAccount && !this.containsFilter(dto.getCustomerAccount(), e.getCustomerAccount()) || activityFormCode && !this.containsFilter(dto.getActivityFormCode(), e.getActivityFormCode()))).collect(Collectors.toList());
                    if (firstChannel) {
                        filterList = this.channelFilter(filterList, TerminalChannelLevelEnum.FIRST, channelInfoMap, true, dto.getFirstChannel());
                    }
                    if (secondChannel) {
                        filterList = this.channelFilter(filterList, TerminalChannelLevelEnum.SECOND, channelInfoMap, true, dto.getSecondChannel());
                    }
                    orgCode.set(orgParentMap.get(orgCode.get()));
                }
            }
        }
        return filterList;
    }

    public List<AuditFormulaMain> channelFilter(List<AuditFormulaMain> filterList, TerminalChannelLevelEnum levelEnum, Map<String, Map<String, List<String>>> channelInfoMap, boolean matchFlag, String value) {
        if (CollectionUtils.isEmpty(filterList)) {
            return filterList;
        }
        return filterList.stream().filter(e -> {
            if (!channelInfoMap.containsKey(e.getAuditFormulaCode())) {
                return !matchFlag;
            }
            Map channelTypeMap = (Map)channelInfoMap.get(e.getAuditFormulaCode());
            if (!channelTypeMap.containsKey(levelEnum.getCode())) {
                return !matchFlag;
            }
            List channelCodes = (List)channelTypeMap.get(levelEnum.getCode());
            if (StringUtils.isEmpty((CharSequence)value)) {
                return CollectionUtils.isEmpty((Collection)channelCodes);
            }
            if (!channelCodes.contains(value)) {
                return !matchFlag;
            }
            return matchFlag;
        }).collect(Collectors.toList());
    }

    public boolean containsFilter(String param, String value) {
        if (StringUtils.isEmpty((CharSequence)param) && StringUtils.isEmpty((CharSequence)value)) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)param) && StringUtils.isNotEmpty((CharSequence)value)) {
            return Arrays.asList(value.split(",")).contains(param);
        }
        return false;
    }
}

