package com.biz.crm.tpm.business.audit.business.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 13:48
 * @description：核销公式dto
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "核销公式dto")
public class AuditFormulaInfoDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty("核销公式条件")
    private String auditFormulaCondition;

    @ApiModelProperty("核销公式条件（展示用）")
    private String auditFormulaConditionName;

    @ApiModelProperty("核销公式")
    private String auditFormula;

    @ApiModelProperty("核销公式（展示用）")
    private String auditFormulaName;

    @ApiModelProperty("前端使用")
    private String conditionJson;

    @ApiModelProperty("前端使用")
    private String computeJson;
}
