package com.biz.crm.tpm.business.audit.business.sdk.dto;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 11:52
 * @description：核销公式主表
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "核销公式主表")
public class AuditFormulaMainDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    private String auditFormulaName;

    @ApiModelProperty(name = "核销类型", notes = "核销类型")
    private String auditType;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织(多个用逗号分割)")
    private String salesOrgCodes;

    @ApiModelProperty(name = "salesOrgNames", notes = "销售组织名称(多个用逗号分割)")
    private String salesOrgNames;

    @ApiModelProperty(name = "customerTypes", notes = "客户类型(多个用逗号分割)")
    private String customerTypes;

    @ApiModelProperty(name = "customerTypeNames", notes = "客户类型名称(多个用逗号分割)")
    private String customerTypeNames;


    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    /**
     * 可配的返利变量（返利基准）
     * - ConfigurableCriterionVo
     * - 返利变量注册实现类可以视同一个返利变量模板
     * - 返利变量实例编码=返利变量注册实现类的编码+数字
     * {
     *    "configurableCriterion":{
     *        "criterionMap":{
     *          "返利变量实例编码":{
     *            返利变量实例的表单内容
     *          }
     *        }
     *    }
     * }
     */
    @ApiModelProperty
    private JSONObject configurableCriterion;

    @ApiModelProperty(name = "核销公式", notes = "核销公式")
    private List<AuditFormulaInfoDto> auditFormulaInfoDtoList;

    @ApiModelProperty(value = "已选择的编码")
    private String selectedCode;

    @ApiModelProperty(value = "已选择的编码集合")
    private List<String> selectedCodeList;

    @ApiModelProperty(value = "可配置变量集合",name = "conVariableMainDtos",notes = "可配置变量集合")
    private List<ConVariableMainDto> conVariableMainDtos;

    @ApiModelProperty("陈列批次")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    private String customerAccount;

    @ApiModelProperty(value = "一级渠道")
    private List<AuditFormulaChannelDto> firstChannelList;
    private String firstChannel;//匹配变量查询条件

    @ApiModelProperty(value = "二级渠道")
    private List<AuditFormulaChannelDto> secondChannelList;
    private String secondChannel;//匹配变量查询条件

    @ApiModelProperty(value = "渠道编码")
    private String channel;

    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    @ApiModelProperty("HR组织编码")
    private String orgCode;

    @ApiModelProperty("HR组织名称")
    private String orgName;

}
