package com.biz.crm.tpm.business.audit.business.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Description 可配置变量
 * @Author YangWei
 * @Date 2023/3/17 下午2:06
 */
@Data
@ApiModel(value = "可配置变量")
public class ConVariableMainDto {

    @ApiModelProperty(name = "配置变量编码code", notes = "配置变量编码code")
    private String variableCode;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "开始时间", notes = "开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date beginTime;

    /**
     * 结束时间
     */
    @ApiModelProperty(name = "结束时间", notes = "结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;

    @ApiModelProperty(name = "summaryDimension",value = "汇总维度", notes = "汇总维度")
    private String summaryDimension;

    /**
     * 可配置品牌缓存key
     */
    @ApiModelProperty(value = "可配置品牌缓存key",name = "brandCacheKey",notes = "可配置品牌缓存key")
    private String brandCacheKey;

    /**
     * 可配置品项缓存key
     */
    @ApiModelProperty(value = "可配置品项缓存key",name = "itemCacheKey",notes = "可配置品项缓存key")
    private String itemCacheKey;

    /**
     * 可配置品类缓存key
     */
    @ApiModelProperty(value = "可配置品类缓存key",name = "categoryCacheKey",notes = "可配置品类缓存key")
    private String categoryCacheKey;

    /**
     * 可配置产品缓存key
     */
    @ApiModelProperty(value = "可配置产品缓存key",name = "goodsCacheKey",notes = "可配置产品缓存key")
    private String goodsCacheKey;

    /**
     * 可配置包含产品缓存key
     */
    @ApiModelProperty(value = "可配置包含产品缓存key",name = "includeGoodsCacheKey",notes = "可配置包含产品缓存key")
    private String includeGoodsCacheKey;

    /**
     * 可配置客户缓存key
     */
    @ApiModelProperty(value = "可配置客户缓存key",name = "customerCacheKey",notes = "可配置客户缓存key")
    private String customerCacheKey;

    /**
     * 可选择销售组织缓存key
     */
    @ApiModelProperty(value = "可选择销售组织缓存key",name = "includeSalesOrgCacheKey",notes = "可选择销售组织缓存key")
    private String includeSalesOrgCacheKey;

    /**
     * 可选择活动形式缓存key
     */
    @ApiModelProperty(value = "可选择活动形式缓存key",name = "includeActivityFormCacheKey",notes = "可选择活动形式缓存key")
    private String includeActivityFormCacheKey;

}