package com.biz.crm.tpm.business.audit.business.sdk.event.log;

import com.biz.crm.tpm.business.audit.business.sdk.dto.log.AuditFormulaLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/11 11:11
 * @description：日志监听
 */
public interface AuditFormulaEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(AuditFormulaLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(AuditFormulaLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(AuditFormulaLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(AuditFormulaLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(AuditFormulaLogEventDto eventDto);
}
