package com.biz.crm.tpm.business.audit.business.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.business.sdk.dto.AuditFormulaMainDto;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaInfoVo;
import com.biz.crm.tpm.business.audit.business.sdk.vo.AuditFormulaMainVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 核销公式主表(AuditFormulaMain)表服务接口
 *
 * @author makejava
 * @since 2022-11-03 11:49:28
 */
public interface AuditFormulaMainService {

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param auditFormulaMain 实体对象
   * @return
   */
  Page<AuditFormulaMainVo> findByConditions(Pageable pageable, AuditFormulaMainDto auditFormulaMain);
  
   /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
   AuditFormulaMainVo findById(String id);
  
   /**
   * 新增数据
   * @param auditFormulaMain 实体对象
   * @return 新增结果
   */
   AuditFormulaMainVo create(AuditFormulaMainDto auditFormulaMain);
  
   /**
   * 修改新据
   * @param auditFormulaMain 实体对象
   * @return 修改结果
   */
   AuditFormulaMainVo update(AuditFormulaMainDto auditFormulaMain);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

    /**
     * 启用
     * @param idList
     */
    void enable(List<String> idList);

    /**
     * 禁用
     * @param idList
     */
    void disable(List<String> idList);

    List<AuditFormulaMainVo> getList(AuditFormulaMainDto auditFormulaMainDto);

    /**
     * 通过code查询明细
     * @param code 编码
     * @return
     */
    AuditFormulaMainVo findByCode(String code);

    /**
     * 批量查询核销公式
     */
    List<AuditFormulaInfoVo> findFormulaInfoListByCodeList(List<String> codeList);

    /**
     * 通过编码列表查询核销条件数据
     * @param codeList
     * @return
     */
    List<AuditFormulaMainVo> findByCodeList(List<String> codeList);

    /**
     * 通过条件查询列表
     * @param dto
     * @return
     */
    List<AuditFormulaMainVo> findListByDto(AuditFormulaMainDto dto);
}

