package com.biz.crm.tpm.business.audit.business.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 14:09
 * @description：核销公式vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditFormulaInfoVo", description = "核销公式vo")
public class AuditFormulaInfoVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty("核销公式条件")
    private String auditFormulaCondition;

    @ApiModelProperty("核销公式条件（展示用）")
    private String auditFormulaConditionName;

    @ApiModelProperty("核销公式")
    private String auditFormula;

    @ApiModelProperty("核销公式（展示用）")
    private String auditFormulaName;

    @ApiModelProperty("前端使用")
    private String conditionJson;

    @ApiModelProperty("前端使用")
    private String computeJson;
}
