package com.biz.crm.tpm.business.audit.business.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * @Author : dengwei
 * @Date :2023/8/17  22:22
 * @Description: 核销公式主表导出
 */
@ApiModel("核销公式主表导出")
@Getter
@Setter
@CrmExcelExport
public class AuditFormulaMainExportsVo extends CrmExcelVo {

    @ApiModelProperty(name = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    @CrmExcelColumn("核销公式编码")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    @CrmExcelColumn("核销公式名称")
    private String auditFormulaName;

    @ApiModelProperty(name = "核销类型", notes = "核销类型")
    @CrmExcelColumn("核销类型")
    private String auditType;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    @CrmExcelColumn("活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    @CrmExcelColumn("活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    @CrmExcelColumn("活动形式")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @CrmExcelColumn("活动类型名称")
    private String activityFormName;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织(多个用逗号分割)")
    @CrmExcelColumn("销售组织")
    private String salesOrgCodes;

    @ApiModelProperty(name = "salesOrgNames", notes = "销售组织名称(多个用逗号分割)")
    @CrmExcelColumn("销售组织名称")
    private String salesOrgNames;

    @ApiModelProperty(name = "customerTypes", notes = "客户类型(多个用逗号分割)")
    @CrmExcelColumn("客户类型")
    private String customerTypes;

    @ApiModelProperty(name = "customerTypeNames", notes = "客户类型名称(多个用逗号分割)")
    @CrmExcelColumn("客户类型名称")
    private String customerTypeNames;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @CrmExcelColumn("核销方式")
    private String writeOffMethod;

    @ApiModelProperty("陈列批次")
    @CrmExcelColumn("陈列批次")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    @CrmExcelColumn("是否客户上账")
    private String customerAccount;

    @ApiModelProperty(value = "渠道编码")
    @CrmExcelColumn("渠道编码")
    private String channel;

    @ApiModelProperty(value = "渠道名称")
    @CrmExcelColumn("渠道名称")
    private String channelName;
}
