package com.biz.crm.tpm.business.audit.business.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/3 11:51
 * @description：核销公式主表
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditFormulaMainVo", description = "核销公式主表")
public class AuditFormulaMainVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "核销公式编码", notes = "核销code")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称", notes = "核销公式名称")
    private String auditFormulaName;

    @ApiModelProperty(name = "核销类型", notes = "核销类型")
    private String auditType;

    @ApiModelProperty(name = "活动类型", notes = "活动类型")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称", notes = "活动类型名称")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式", notes = "活动形式")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "salesOrgCode", notes = "销售组织(多个用逗号分割)")
    private String salesOrgCodes;

    @ApiModelProperty(name = "salesOrgNames", notes = "销售组织名称(多个用逗号分割)")
    private String salesOrgNames;

    @ApiModelProperty(name = "customerTypes", notes = "客户类型(多个用逗号分割)")
    private String customerTypes;

    @ApiModelProperty(name = "customerTypeNames", notes = "客户类型名称(多个用逗号分割)")
    private String customerTypeNames;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    private String writeOffMethod;

    @ApiModelProperty(name = "活动公式", notes = "活动公式")
    private List<AuditFormulaInfoVo> auditFormulaInfoVoList;

    @ApiModelProperty(value = "可配置变量集合",name = "conVariableMainVos",notes = "可配置变量集合")
    private List<ConVariableMainVo> conVariableMainVos;

    @ApiModelProperty("陈列批次")
    private String displayNumber;

    @ApiModelProperty("是否客户上账")
    private String customerAccount;

    @ApiModelProperty(value = "一级渠道")
    private List<AuditFormulaChannelVo> firstChannelList;

    @ApiModelProperty(value = "二级渠道")
    private List<AuditFormulaChannelVo> secondChannelList;

    @ApiModelProperty(value = "渠道编码")
    private String channel;

    @ApiModelProperty(value = "渠道名称")
    private String channelName;

    @ApiModelProperty("HR组织编码")
    private String orgCode;

    @ApiModelProperty("HR组织名称")
    private String orgName;
}
